/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.utils;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.utils.PrinterBase;
import de.fau.cs.osr.utils.StringUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.sweble.wikitext.parser.nodes.WtBody;
import org.sweble.wikitext.parser.nodes.WtBold;
import org.sweble.wikitext.parser.nodes.WtDefinitionList;
import org.sweble.wikitext.parser.nodes.WtDefinitionListDef;
import org.sweble.wikitext.parser.nodes.WtDefinitionListTerm;
import org.sweble.wikitext.parser.nodes.WtExternalLink;
import org.sweble.wikitext.parser.nodes.WtHeading;
import org.sweble.wikitext.parser.nodes.WtHorizontalRule;
import org.sweble.wikitext.parser.nodes.WtIgnored;
import org.sweble.wikitext.parser.nodes.WtIllegalCodePoint;
import org.sweble.wikitext.parser.nodes.WtImEndTag;
import org.sweble.wikitext.parser.nodes.WtImStartTag;
import org.sweble.wikitext.parser.nodes.WtImageLink;
import org.sweble.wikitext.parser.nodes.WtInternalLink;
import org.sweble.wikitext.parser.nodes.WtItalics;
import org.sweble.wikitext.parser.nodes.WtLctFlags;
import org.sweble.wikitext.parser.nodes.WtLctRule;
import org.sweble.wikitext.parser.nodes.WtLctRuleConv;
import org.sweble.wikitext.parser.nodes.WtLctRuleGarbage;
import org.sweble.wikitext.parser.nodes.WtLctRules;
import org.sweble.wikitext.parser.nodes.WtLctVarConv;
import org.sweble.wikitext.parser.nodes.WtLinkOptionAltText;
import org.sweble.wikitext.parser.nodes.WtLinkOptionGarbage;
import org.sweble.wikitext.parser.nodes.WtLinkOptionKeyword;
import org.sweble.wikitext.parser.nodes.WtLinkOptionLinkTarget;
import org.sweble.wikitext.parser.nodes.WtLinkOptionResize;
import org.sweble.wikitext.parser.nodes.WtLinkOptions;
import org.sweble.wikitext.parser.nodes.WtLinkTarget;
import org.sweble.wikitext.parser.nodes.WtLinkTitle;
import org.sweble.wikitext.parser.nodes.WtListItem;
import org.sweble.wikitext.parser.nodes.WtName;
import org.sweble.wikitext.parser.nodes.WtNewline;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtOnlyInclude;
import org.sweble.wikitext.parser.nodes.WtOrderedList;
import org.sweble.wikitext.parser.nodes.WtPageName;
import org.sweble.wikitext.parser.nodes.WtPageSwitch;
import org.sweble.wikitext.parser.nodes.WtParagraph;
import org.sweble.wikitext.parser.nodes.WtParsedWikitextPage;
import org.sweble.wikitext.parser.nodes.WtPreproWikitextPage;
import org.sweble.wikitext.parser.nodes.WtRedirect;
import org.sweble.wikitext.parser.nodes.WtSection;
import org.sweble.wikitext.parser.nodes.WtSemiPre;
import org.sweble.wikitext.parser.nodes.WtSemiPreLine;
import org.sweble.wikitext.parser.nodes.WtSignature;
import org.sweble.wikitext.parser.nodes.WtTable;
import org.sweble.wikitext.parser.nodes.WtTableCaption;
import org.sweble.wikitext.parser.nodes.WtTableCell;
import org.sweble.wikitext.parser.nodes.WtTableHeader;
import org.sweble.wikitext.parser.nodes.WtTableImplicitTableBody;
import org.sweble.wikitext.parser.nodes.WtTableRow;
import org.sweble.wikitext.parser.nodes.WtTagExtension;
import org.sweble.wikitext.parser.nodes.WtTagExtensionBody;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.nodes.WtTemplateArgument;
import org.sweble.wikitext.parser.nodes.WtTemplateArguments;
import org.sweble.wikitext.parser.nodes.WtTemplateParameter;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.nodes.WtTicks;
import org.sweble.wikitext.parser.nodes.WtUnorderedList;
import org.sweble.wikitext.parser.nodes.WtUrl;
import org.sweble.wikitext.parser.nodes.WtValue;
import org.sweble.wikitext.parser.nodes.WtWhitespace;
import org.sweble.wikitext.parser.nodes.WtXmlAttribute;
import org.sweble.wikitext.parser.nodes.WtXmlAttributeGarbage;
import org.sweble.wikitext.parser.nodes.WtXmlAttributes;
import org.sweble.wikitext.parser.nodes.WtXmlCharRef;
import org.sweble.wikitext.parser.nodes.WtXmlComment;
import org.sweble.wikitext.parser.nodes.WtXmlElement;
import org.sweble.wikitext.parser.nodes.WtXmlEmptyTag;
import org.sweble.wikitext.parser.nodes.WtXmlEndTag;
import org.sweble.wikitext.parser.nodes.WtXmlEntityRef;
import org.sweble.wikitext.parser.nodes.WtXmlStartTag;

public class WtPrettyPrinter
extends AstVisitor<WtNode> {
    protected final PrinterBase p;
    private final LinkedList<WtNode> scope = new LinkedList();
    private boolean newlineAtEof = false;
    private int insideList;

    public void visit(WtLinkOptionLinkTarget n) {
        this.p.print("|link=");
        switch (n.getTargetType()) {
            case PAGE: 
            case URL: {
                this.dispatch(n.getTarget());
                break;
            }
            case DEFAULT: {
                throw new InternalError();
            }
        }
    }

    public void visit(WtRedirect n) {
        this.p.print("#REDIRECT[[");
        this.dispatch(n.getTarget());
        this.p.print("]]");
    }

    public void visit(WtTableImplicitTableBody n) {
        this.dispatch(n.getBody());
    }

    public void visit(WtXmlAttribute n) {
        this.p.print(' ');
        this.dispatch(n.getName());
        if (n.hasValue()) {
            boolean needQuotes = true;
            if (n.getValue().size() == 1) {
                switch (((WtNode)n.getValue().get(0)).getNodeType()) {
                    case 458756: 
                    case 458758: {
                        needQuotes = false;
                    }
                }
            }
            this.p.print(needQuotes ? "=\"" : "=");
            this.dispatch(n.getValue());
            if (needQuotes) {
                this.p.print('\"');
            }
        }
    }

    public void visit(WtXmlEmptyTag n) {
        this.p.print('<');
        this.p.print(n.getName());
        this.dispatch(n.getXmlAttributes());
        this.p.print(" />");
    }

    public void visit(WtXmlStartTag n) {
        this.p.print('<');
        this.p.print(n.getName());
        this.dispatch(n.getXmlAttributes());
        this.p.print(">");
    }

    public void visit(WtImStartTag n) {
    }

    public void visit(WtLctRule n) {
        if (!n.isDirectConvert()) {
            this.p.print(n.getSearch());
            this.p.print("=>");
        }
        this.p.print(n.getVariant());
        this.p.print(":");
        this.dispatch(n.getReplace());
    }

    public void visit(WtExternalLink n) {
        this.scope.push(n);
        this.p.print("[");
        this.dispatch(n.getTarget());
        if (n.hasTitle()) {
            this.dispatch(n.getTitle());
        }
        this.p.print("]");
        this.scope.pop();
    }

    public void visit(WtInternalLink n) {
        this.scope.push(n);
        this.p.print(n.getPrefix());
        this.p.print("[[");
        this.dispatch(n.getTarget());
        if (n.hasTitle()) {
            this.dispatch(n.getTitle());
        }
        this.p.print("]]");
        this.p.print(n.getPostfix());
        this.scope.pop();
    }

    public void visit(WtSection n) {
        this.scope.push(n);
        this.p.clearEatNewlinesAndIndents();
        this.p.needNewlines(2);
        this.iterate(n);
        this.p.needNewlines(2);
        this.scope.pop();
    }

    public void visit(WtTable n) {
        this.p.clearEatNewlinesAndIndents();
        this.p.needNewlines(2);
        this.p.print("{|");
        this.dispatch(n.getXmlAttributes());
        this.p.println();
        this.dispatch(n.getBody());
        this.p.clearEatNewlinesAndIndents();
        this.p.capNewlines(1, 1);
        this.p.println(" |}");
        this.p.needNewlines(2);
    }

    public void visit(WtTableCaption n) {
        this.p.clearEatNewlinesAndIndents();
        this.p.capNewlines(1, 1);
        this.p.print(" |+");
        if (!n.getXmlAttributes().isEmpty()) {
            this.dispatch(n.getXmlAttributes());
            this.p.print(" |");
        }
        this.p.eatNewlinesAndIndents(2);
        this.dispatch(n.getBody());
        this.p.capNewlines(1, 1);
    }

    public void visit(WtTableCell n) {
        this.p.clearEatNewlinesAndIndents();
        this.p.capNewlines(1, 1);
        this.p.print(" |");
        if (!n.getXmlAttributes().isEmpty()) {
            this.dispatch(n.getXmlAttributes());
            this.p.print(" |");
        }
        this.p.eatNewlinesAndIndents(2);
        this.dispatch(n.getBody());
        this.p.capNewlines(1, 1);
    }

    public void visit(WtTableHeader n) {
        this.p.clearEatNewlinesAndIndents();
        this.p.capNewlines(1, 1);
        this.p.print(" !");
        if (!n.getXmlAttributes().isEmpty()) {
            this.dispatch(n.getXmlAttributes());
            this.p.print(" |");
        }
        this.p.eatNewlinesAndIndents(2);
        this.dispatch(n.getBody());
        this.p.capNewlines(1, 1);
    }

    public void visit(WtTableRow n) {
        if (!n.isImplicit()) {
            this.p.clearEatNewlinesAndIndents();
            this.p.capNewlines(1, 1);
            this.p.print(" |-");
            this.dispatch(n.getXmlAttributes());
            this.p.println();
        }
        this.dispatch(n.getBody());
    }

    public void visit(WtTagExtension n) {
        this.p.print('<');
        this.p.print(n.getName());
        this.dispatch(n.getXmlAttributes());
        this.p.print(n.hasBody() ? ">" : "/>");
        if (n.hasBody()) {
            this.dispatch(n.getBody());
            this.p.print("</");
            this.p.print(n.getName());
            this.p.print('>');
        }
    }

    public void visit(WtTemplate n) {
        if (n.isPrecededByNewline()) {
            this.p.clearEatNewlinesAndIndents();
            this.p.println();
        }
        this.p.print("{{");
        this.iterate(n);
        this.p.print("}}");
    }

    public void visit(WtTemplateArgument n) {
        this.p.print('|');
        if (n.hasName()) {
            this.dispatch(n.getName());
            this.p.print('=');
        }
        this.dispatch(n.getValue());
    }

    public void visit(WtXmlElement n) {
        this.p.print('<');
        this.p.print(n.getName());
        this.dispatch(n.getXmlAttributes());
        this.p.print(n.hasBody() ? ">" : " />");
        if (n.hasBody()) {
            this.dispatch(n.getBody());
            this.p.print("</");
            this.p.print(n.getName());
            this.p.print('>');
        }
    }

    public void visit(WtLctVarConv n) {
        this.p.print("-{");
        if (n.hasFlags()) {
            this.dispatch(n.getFlags());
            this.p.print('|');
        }
        this.dispatch(n.getText());
        this.p.print("}-");
    }

    public void visit(WtLctRuleConv n) {
        this.p.print("-{");
        if (n.hasFlags()) {
            this.dispatch(n.getFlags());
            this.p.print('|');
        }
        this.dispatch(n.getRules());
        this.p.print("}-");
    }

    public void visit(WtImageLink n) {
        this.scope.push(n);
        this.p.print("[[");
        this.dispatch(n.getTarget());
        this.dispatch(n.getOptions());
        this.p.print("]]");
        this.scope.pop();
    }

    public void visit(WtTemplateParameter n) {
        this.p.print("{{{");
        this.dispatch(n.getName());
        if (n.hasDefault()) {
            this.p.print('|');
            this.dispatch(n.getDefault());
        }
        this.p.print("}}}");
    }

    public void visit(WtHorizontalRule n) {
        this.p.clearEatNewlinesAndIndents();
        this.p.needNewlines(2);
        this.p.println("----");
        this.p.needNewlines(2);
    }

    public void visit(WtIllegalCodePoint n) {
        this.p.print(n.getCodePoint());
    }

    public void visit(WtLinkOptionKeyword n) {
        this.p.print('|');
        this.p.print(n.getKeyword());
    }

    public void visit(WtLinkOptionResize n) {
        this.p.print('|');
        if (n.getHeight() >= 0) {
            if (n.getWidth() >= 0) {
                this.p.print(String.valueOf(n.getWidth()));
            }
            this.p.print('x');
            this.p.print(String.valueOf(n.getHeight()));
        } else {
            this.p.print(String.valueOf(n.getWidth()));
        }
        this.p.print("px");
    }

    public void visit(WtPageSwitch n) {
        this.p.print("__");
        this.p.print(n.getName());
        this.p.print("__");
    }

    public void visit(WtSignature n) {
        this.p.print(StringUtils.strrep((char)'~', (int)n.getTildeCount()));
    }

    public void visit(WtTicks n) {
        this.p.print(StringUtils.strrep((char)'\'', (int)n.getTickCount()));
    }

    public void visit(WtUrl n) {
        if (!n.getProtocol().isEmpty()) {
            this.p.print(n.getProtocol());
            this.p.print(':');
        }
        this.p.print(n.getPath());
    }

    public void visit(WtXmlCharRef n) {
        this.p.print("&#");
        this.p.print(String.valueOf(n.getCodePoint()));
        this.p.print(';');
    }

    public void visit(WtXmlEndTag n) {
        this.p.print("</");
        this.p.print(n.getName());
        this.p.print('>');
    }

    public void visit(WtImEndTag n) {
    }

    public void visit(WtXmlEntityRef n) {
        this.p.print('&');
        this.p.print(n.getName());
        this.p.print(';');
    }

    public void visit(WtLctFlags n) {
        ArrayList<String> flags = new ArrayList<String>();
        flags.addAll(n.getFlags());
        flags.addAll(n.getVariants());
        for (int i = 0; i < flags.size(); ++i) {
            if (i > 0) {
                this.p.print(';');
            }
            this.p.print((String)flags.get(i));
        }
    }

    public void visit(WtNodeList n) {
        this.iterate(n);
    }

    public void visit(WtBody n) {
        this.iterate(n);
    }

    public void visit(WtBold n) {
        this.p.print("'''");
        this.iterate(n);
        this.p.print("'''");
    }

    public void visit(WtDefinitionList n) {
        ++this.insideList;
        this.scope.push(n);
        if (this.insideList <= 1) {
            this.p.needNewlines(2);
        }
        this.iterate(n);
        this.p.needNewlines(this.insideList > 1 ? 1 : 2);
        this.scope.pop();
        --this.insideList;
    }

    public void visit(WtDefinitionListDef n) {
        this.scope.push(n);
        this.printListPrefix(n);
        this.iterate(n);
        this.p.println();
        this.scope.pop();
    }

    public void visit(WtDefinitionListTerm n) {
        this.scope.push(n);
        this.printListPrefix(n);
        this.iterate(n);
        this.p.println();
        this.scope.pop();
    }

    public void visit(WtHeading n) {
        int level = ((WtSection)this.scope.peek()).getLevel();
        String equals = StringUtils.strrep((char)'=', (int)level);
        this.p.print(equals);
        this.iterate(n);
        this.p.println(equals);
    }

    public void visit(WtItalics n) {
        this.p.print("''");
        this.iterate(n);
        this.p.print("''");
    }

    public void visit(WtLinkOptionAltText n) {
        this.p.print("|alt=");
        this.iterate(n);
    }

    public void visit(WtLinkOptions n) {
        Iterator i$ = n.iterator();
        while (i$.hasNext()) {
            WtNode a = (WtNode)i$.next();
            switch (a.getNodeType()) {
                case 720904: 
                case 720905: 
                case 720906: 
                case 720907: 
                case 720908: {
                    break;
                }
                default: {
                    this.p.print('|');
                }
            }
            this.dispatch(a);
        }
    }

    public void visit(WtLinkTitle n) {
        switch (this.scope.peek().getNodeType()) {
            case 720902: {
                this.p.print('|');
                break;
            }
            case 720901: {
                this.p.print(' ');
                break;
            }
        }
        this.iterate(n);
    }

    public void visit(WtListItem n) {
        this.scope.push(n);
        this.printListPrefix(n);
        this.iterate(n);
        this.p.println();
        this.scope.pop();
    }

    private void printListPrefix(WtNode item) {
        WtNode parentContainer;
        String prefix = "";
        boolean multipleNewLevels = false;
        WtNode parent2 = this.scope.get(1);
        if (this.scope.size() > 2 && !parent2.isEmpty() && parent2.get(0) == item && !(parentContainer = this.scope.get(2)).isEmpty() && parentContainer.get(0) == parent2) {
            multipleNewLevels = true;
        }
        block8: for (WtNode parent2 : this.scope) {
            switch (parent2.getNodeType()) {
                case 720926: {
                    if (multipleNewLevels) continue block8;
                }
                case 720921: {
                    break;
                }
                case 720923: {
                    prefix = "#" + prefix;
                    break;
                }
                case 720925: {
                    prefix = "*" + prefix;
                    break;
                }
                case 720920: {
                    prefix = ":" + prefix;
                    break;
                }
                case 720922: {
                    prefix = ";" + prefix;
                    break;
                }
                default: {
                    break block8;
                }
            }
            if (!multipleNewLevels) continue;
        }
        if (!multipleNewLevels) {
            this.p.clearEatNewlinesAndIndents();
            this.p.println();
        }
        this.p.print(prefix);
    }

    public void visit(WtName n) {
        this.iterate(n);
    }

    public void visit(WtOnlyInclude n) {
        this.p.print("<onlyinclude>");
        this.iterate(n);
        this.p.print("</onlyinclude>");
    }

    public void visit(WtOrderedList n) {
        ++this.insideList;
        this.scope.push(n);
        if (this.insideList <= 1) {
            this.p.needNewlines(2);
        }
        this.iterate(n);
        this.p.needNewlines(this.insideList > 1 ? 1 : 2);
        this.scope.pop();
        --this.insideList;
    }

    public void visit(WtParsedWikitextPage n) {
        this.iterate(n);
    }

    public void visit(WtPreproWikitextPage n) {
        this.iterate(n);
    }

    public void visit(WtParagraph n) {
        this.p.needNewlines(2);
        this.iterate(n);
        this.p.needNewlines(2);
    }

    public void visit(WtSemiPre n) {
        this.p.needNewlines(2);
        this.iterate(n);
        this.p.needNewlines(2);
    }

    public void visit(WtSemiPreLine n) {
        this.p.print(' ');
        this.iterate(n);
        this.p.println();
    }

    public void visit(WtTemplateArguments n) {
        this.iterate(n);
    }

    public void visit(WtUnorderedList n) {
        ++this.insideList;
        this.scope.push(n);
        if (this.insideList <= 1) {
            this.p.needNewlines(2);
        }
        this.iterate(n);
        this.p.needNewlines(this.insideList > 1 ? 1 : 2);
        this.scope.pop();
        --this.insideList;
    }

    public void visit(WtValue n) {
        this.iterate(n);
    }

    public void visit(WtWhitespace n) {
        this.iterate(n);
    }

    public void visit(WtXmlAttributes n) {
        Iterator i$ = n.iterator();
        while (i$.hasNext()) {
            WtNode a = (WtNode)i$.next();
            switch (a.getNodeType()) {
                case 720929: 
                case 720930: {
                    break;
                }
                default: {
                    this.p.print(' ');
                }
            }
            this.dispatch(a);
        }
    }

    public void visit(WtLctRules n) {
        int i = 0;
        Iterator i$ = n.iterator();
        while (i$.hasNext()) {
            WtNode rule = (WtNode)i$.next();
            if (rule instanceof WtLctRuleGarbage) continue;
            if (i++ > 0) {
                this.p.print(";");
            }
            this.dispatch(rule);
        }
    }

    public void visit(WtIgnored n) {
        this.p.print(n.getContent());
    }

    public void visit(WtLinkOptionGarbage n) {
    }

    public void visit(WtNewline n) {
        this.p.println();
    }

    public void visit(WtPageName n) {
        this.iterate(n);
    }

    public void visit(WtLinkTarget.WtNoLink n) {
    }

    public void visit(WtXmlAttributeGarbage n) {
    }

    public void visit(WtXmlComment n) {
        this.p.print(n.getPrefix());
        this.p.print("<!--");
        this.p.print(n.getContent());
        this.p.print("-->");
        this.p.print(n.getSuffix());
    }

    public void visit(WtTagExtensionBody n) {
        this.p.verbatim(n.getContent());
    }

    public void visit(WtLctRuleGarbage n) {
    }

    public void visit(WtText n) {
        this.p.print(n.getContent());
    }

    public static <T extends WtNode> String print(T node) {
        return WtPrettyPrinter.print(new StringWriter(), node).toString();
    }

    public static <T extends WtNode> Writer print(Writer writer, T node) {
        new WtPrettyPrinter(writer).go(node);
        return writer;
    }

    public WtPrettyPrinter(Writer writer) {
        this.p = new PrinterBase(writer);
        this.p.setMemoize(false);
    }

    public void setNewlineAtEof(boolean newlineAtEof) {
        this.newlineAtEof = newlineAtEof;
    }

    public boolean isNewlineAtEof() {
        return this.newlineAtEof;
    }

    protected boolean before(WtNode node) {
        this.p.eatNewlinesAndIndents(2);
        return super.before((Object)node);
    }

    protected Object after(WtNode node, Object result) {
        this.p.ignoreNewlines();
        if (this.newlineAtEof) {
            this.p.println();
        }
        this.p.flush();
        return result;
    }
}

