/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.utils;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.sweble.wikitext.parser.WtRtData;
import org.sweble.wikitext.parser.nodes.WtContentNode;
import org.sweble.wikitext.parser.nodes.WtIgnored;
import org.sweble.wikitext.parser.nodes.WtNewline;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtStringNode;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.utils.WtPrettyPrinter;

public class WtRtDataPrettyPrinter
extends WtPrettyPrinter {
    @Override
    public void visit(WtNewline n) {
        this.p.verbatim(n.getContent());
    }

    @Override
    public void visit(WtIgnored n) {
        this.p.verbatim(n.getContent());
    }

    @Override
    public void visit(WtText n) {
        this.p.verbatim(n.getContent());
    }

    protected Object dispatch(WtNode node) {
        WtRtData rtd = node.getRtd();
        if (rtd != null) {
            if (node instanceof WtStringNode) {
                this.printStringNode(rtd, (WtStringNode)node);
            } else if (node instanceof WtContentNode) {
                this.printContentNode(rtd, (WtContentNode)node);
            } else {
                this.printAnyOtherNode(rtd, node);
            }
        } else {
            super.dispatch((AstNode)node);
        }
        return null;
    }

    protected void printStringNode(WtRtData rtd, WtStringNode contentNode) {
        if (rtd != null) {
            this.printRtd(rtd.getField(0));
        } else {
            this.p.verbatim(contentNode.getContent());
        }
    }

    protected void printContentNode(WtRtData rtd, WtContentNode contentNode) {
        if (rtd != null) {
            this.printRtd(rtd.getField(0));
            this.iterate(contentNode);
            this.printRtd(rtd.getField(1));
        } else {
            this.iterate(contentNode);
        }
    }

    protected void printAnyOtherNode(WtRtData rtd, WtNode node) {
        if (rtd != null) {
            int i = 0;
            Iterator i$ = node.iterator();
            while (i$.hasNext()) {
                WtNode n = (WtNode)i$.next();
                this.printRtd(rtd.getField(i++));
                this.dispatch(n);
            }
            this.printRtd(rtd.getField(i));
        } else {
            this.iterate(node);
        }
    }

    protected void printRtd(Object[] fields) {
        for (Object o : fields) {
            if (o instanceof WtNode) {
                this.dispatch((WtNode)o);
                continue;
            }
            this.p.verbatim(String.valueOf(o));
        }
    }

    public static <T extends WtNode> String print(T node) {
        return WtRtDataPrettyPrinter.print(new StringWriter(), node).toString();
    }

    public static <T extends WtNode> Writer print(Writer writer, T node) {
        new WtRtDataPrettyPrinter(writer).go(node);
        return writer;
    }

    public WtRtDataPrettyPrinter(Writer writer) {
        super(writer);
    }
}

