/*
 * Decompiled with CFR 0.152.
 */
package org.coweb.admin;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.coweb.admin.Admin;
import org.coweb.admin.ConferenceDB;
import org.coweb.admin.acls.SessionAcls;

public class AdminImpl
implements Admin {
    private ConferenceDB db = null;
    @Resource(name="SystemDatasource")
    private DataSource dbsource;
    private Connection dbconnect;

    @PostConstruct
    public void initialize() {
        try {
            this.dbconnect = this.dbsource.getConnection();
            this.db = new ConferenceDB(this.dbconnect);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int registerApplication(String username, String title, String description, String appUrl, String thumbnailUrl) {
        System.out.println("Admin::registerApplication");
        return this.db.registerApplication(username, title, description, appUrl, thumbnailUrl);
    }

    @Override
    public boolean unregisterApplication(String username, String title) {
        System.out.println("AdminBean::unregisterApplication");
        return this.db.unregisterApplication(title);
    }

    @Override
    public boolean unregisterApplication(String username, int appid) {
        System.out.println("AdminBean::unregisterApplication");
        return this.db.unregisterApplication(appid);
    }

    @Override
    public boolean createSession(String username, String appTitle, String sessionTitle, String description, Map<String, Integer> aclsDict) {
        System.out.println("AdminBean::createSession");
        System.out.println("username = " + username + " appTitle = " + appTitle);
        System.out.println("sessionTitle = " + sessionTitle + " description = " + description);
        int sessionId = this.db.createSession(username, appTitle, sessionTitle, description);
        if (sessionId == -1) {
            return false;
        }
        if (aclsDict != null && !aclsDict.isEmpty()) {
            return this.db.setSessionAcls(sessionId, aclsDict);
        }
        return true;
    }

    @Override
    public SessionAcls getSessionAclsForUser(String username, String sessionid) {
        int acls = this.db.getSessionAclsForUser(username, sessionid);
        SessionAcls sessionAcls = new SessionAcls(acls);
        return sessionAcls;
    }

    @Override
    public Map<String, Object> getApplication(String username, String appTitle) {
        return this.db.getApplication(username, appTitle);
    }

    @Override
    public Map<String, Object> getSession(String username, String appTitle, String sessionId) {
        return this.db.getSession(username, appTitle, sessionId);
    }

    @Override
    public List<Map<String, Object>> getSessionsForUser(String username, int acls, String query, String sortBy, String direction, int offset, int limit) {
        if (query == null) {
            query = "";
        }
        if (sortBy == null) {
            sortBy = "title";
        }
        if (direction == null) {
            direction = "DESC";
        }
        offset = offset == -1 ? 0 : offset;
        limit = limit == -1 ? 30 : limit;
        return this.db.getSessionsForUser(username, acls, query, sortBy, offset, limit);
    }

    @Override
    public List<Map<String, Object>> getApplicationsForUser(String username, Map<String, Object> args) {
        return null;
    }
}

