/*
 * Decompiled with CFR 0.152.
 */
package org.coweb.admin.rs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONObject;
import org.coweb.admin.Admin;
import org.coweb.admin.AdminImpl;

public class ApplicationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Admin cowebAdmin;

    public void init() throws ServletException {
        super.init();
        ServletConfig config = this.getServletConfig();
        String adminClass = config.getInitParameter("cowebAdminClass");
        if (adminClass == null) {
            this.cowebAdmin = new AdminImpl();
        } else {
            try {
                Class<?> clazz = Class.forName(adminClass);
                this.cowebAdmin = (Admin)clazz.newInstance();
            }
            catch (Exception e) {
                this.cowebAdmin = new AdminImpl();
            }
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.endsWith("/session")) {
            this.getSessions(req, resp);
        } else if (path.startsWith("/session")) {
            this.getSession(req, resp);
        } else if (path.startsWith("/application")) {
            this.getApplication(req, resp);
        } else {
            resp.setStatus(400);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.startsWith("/session")) {
            this.createSession(req, resp);
        } else if (path.startsWith("/application")) {
            this.registerApplication(req, resp);
        } else {
            resp.setStatus(400);
        }
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.startsWith("/session")) {
            this.updateSession(req, resp);
        } else if (path.startsWith("/application")) {
            this.updateApplication(req, resp);
        } else {
            resp.setStatus(400);
        }
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.startsWith("/session")) {
            this.deleteSession(req, resp);
        } else if (path.startsWith("/application")) {
            this.unregisterApplication(req, resp);
        } else {
            resp.setStatus(400);
        }
    }

    private void getSessions(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            BufferedReader r = req.getReader();
            JSONObject args = null;
            if (((Reader)r).read() != -1) {
                ((Reader)r).reset();
                args = new JSONObject((Reader)req.getReader());
            } else {
                args = new JSONObject();
            }
            Integer acls = null;
            acls = args.containsKey((Object)"acls") ? Integer.valueOf((Integer)args.get("acls")) : Integer.valueOf(1);
            System.out.println("acls = " + acls);
            String query = null;
            if (args.containsKey((Object)"query")) {
                query = (String)args.get("query");
            }
            String sortBy = null;
            if (args.containsKey((Object)"sortby")) {
                sortBy = (String)args.get("sortby");
            }
            String direction = null;
            if (args.containsKey((Object)"direction")) {
                direction = (String)args.get("direction");
            }
            List<Map<String, Object>> sessions = this.cowebAdmin.getSessionsForUser(req.getRemoteUser(), acls, query, sortBy, direction, -1, -1);
            System.out.println(sessions);
            JSONArray arr = null;
            arr = sessions != null ? new JSONArray(sessions) : new JSONArray();
            arr.write((Writer)resp.getWriter());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getSession(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            String path = req.getPathInfo();
            String[] parts = path.split("/");
            String sessionId = parts[parts.length - 1];
            String name = this.getServletContext().getServletContextName();
            Map<String, Object> session = this.cowebAdmin.getSession(req.getRemoteUser(), name, sessionId);
            JSONObject json = new JSONObject(session);
            json.write((Writer)resp.getWriter());
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
    }

    private void createSession(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        block4: {
            try {
                BufferedReader r = req.getReader();
                JSONObject args = null;
                String name = this.getServletContext().getServletContextName();
                ((Reader)r).mark(1024);
                if (((Reader)r).read() != -1) {
                    ((Reader)r).reset();
                    args = new JSONObject((Reader)r);
                    System.out.println(args);
                    if (!this.cowebAdmin.createSession(req.getRemoteUser(), name, (String)args.get("title"), (String)args.get("description"), (Map)args.get("aclsDict"))) {
                        throw new ServletException("Error Creating Session");
                    }
                    break block4;
                }
                throw new ServletException("No Session Info");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void getApplication(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            String name = this.getServletContext().getServletContextName();
            Map<String, Object> application = this.cowebAdmin.getApplication(req.getRemoteUser(), name);
            JSONObject json = new JSONObject(name);
            json.write((Writer)resp.getWriter());
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
    }

    private void registerApplication(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        ServletContext ctx = this.getServletContext();
        String title = ctx.getServletContextName();
        String description = ctx.getInitParameter("description");
        String appUrl = ctx.getInitParameter("appurl");
        String thumbnailUrl = ctx.getInitParameter("thumbnailurl");
        int ret = this.cowebAdmin.registerApplication(req.getRemoteUser(), title, description, appUrl, thumbnailUrl);
        if (ret == -1) {
            throw new ServletException("Error Registering App " + title);
        }
    }

    private void unregisterApplication(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        ServletContext ctx = this.getServletContext();
        String title = ctx.getServletContextName();
        boolean ret = this.cowebAdmin.unregisterApplication(req.getRemoteUser(), title);
        if (!ret) {
            throw new ServletException("Error Registering App " + title);
        }
    }

    private void updateSession(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        ServletContext ctx = this.getServletContext();
        String title = ctx.getServletContextName();
    }

    private void updateApplication(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
    }

    private void deleteSession(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
    }
}

