/*
 * OpenCredo-Esper - simplifies adopting Esper in Java applications. 
 * Copyright (C) 2010  OpenCredo Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package org.opencredo.esper.integration.config.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

public class EsperChannelThroughputMonitorParser extends AbstractSingleBeanDefinitionParser {

    private final static String BASE_PACKAGE_NAME = "org.opencredo.esper.integration";

    @Override
    protected String getBeanClassName(Element element) {
        return BASE_PACKAGE_NAME + ".throughput.EsperChannelThroughputMonitor";
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {

        String channelRef = element.getAttribute("channel-ref");
        builder.addConstructorArgReference(channelRef);

        String sourceId = element.getAttribute("sourceId");
        Assert.hasText(sourceId, "sourceId attribute is required");
        builder.addConstructorArgValue(sourceId);

        String timeSample = element.getAttribute("time-sample");
        builder.addPropertyValue("timeSample", timeSample);

    }
}
