/*
 * OpenCredo-Esper - simplifies adopting Esper in Java applications. 
 * Copyright (C) 2010  OpenCredo Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package org.opencredo.esper.integration.config.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class InboundChannelAdapterParser extends AbstractSingleBeanDefinitionParser {

    private final static String BASE_PACKAGE_NAME = "org.opencredo.esper.integration";

    @Override
    protected String getBeanClassName(Element element) {
        return BASE_PACKAGE_NAME + ".EventDrivenEsperInboundChannelAdapter";
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String channelRef = element.getAttribute("channel");
        Assert.hasText(channelRef, "channel attribute must be provided");
        builder.addConstructorArgReference(channelRef);

        Element eplElements = DomUtils.getChildElementByTagName(element, "epl");

        if (eplElements != null) {
            builder.addConstructorArgValue(eplElements.getTextContent());
        } else {
            builder.addConstructorArgValue(null);
        }

        Attr templateNameNode = element.getAttributeNode("template-name");
        if (templateNameNode != null) {
            builder.addPropertyValue("templateName", templateNameNode.getTextContent());
        }
    }

}
