/*
 * Decompiled with CFR 0.152.
 */
package org.opencredo.esper.integration;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UnmatchedListener;
import com.espertech.esper.client.UpdateListener;
import org.opencredo.esper.EsperStatement;
import org.opencredo.esper.EsperTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.message.GenericMessage;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EventDrivenEsperInboundChannelAdapter
implements InitializingBean,
DisposableBean,
UpdateListener,
UnmatchedListener {
    private static final Logger LOG = LoggerFactory.getLogger(EventDrivenEsperInboundChannelAdapter.class);
    private final MessageChannel channel;
    private final String eplQuery;
    private Long timeout;
    private String templateName;
    private EsperTemplate template;

    public EventDrivenEsperInboundChannelAdapter(MessageChannel channel, String epl) {
        this.channel = channel;
        this.eplQuery = epl;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void afterPropertiesSet() {
        this.template = new EsperTemplate();
        this.template.setName(this.templateName);
        if (StringUtils.hasText((String)this.eplQuery)) {
            EsperStatement statement = new EsperStatement(this.eplQuery);
            statement.addListener((UpdateListener)this);
            this.template.addStatement(statement);
        } else {
            this.template.setUnmatchedListener((UnmatchedListener)this);
        }
        this.template.initialize();
    }

    public void update(EventBean[] eventBeans, EventBean[] eventBeans1) {
        LOG.debug("Inbound channel adapter receiving an event from esper");
        Assert.notNull((Object)this.channel);
        GenericMessage message = new GenericMessage((Object)eventBeans);
        if (this.timeout != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending message (" + message + ") to channel " + this.channel + " with timeout " + this.timeout);
            }
            this.channel.send((Message)message, this.timeout.longValue());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending message (" + message + ") to channel " + this.channel);
            }
            this.channel.send((Message)message);
        }
        LOG.debug("Inbound channel adapter received an event from esper");
    }

    public void update(EventBean eventBean) {
        LOG.debug("Inbound channel adapter receiving an unmatched listener event from esper");
        Assert.notNull((Object)this.channel);
        GenericMessage message = new GenericMessage((Object)eventBean);
        if (this.timeout != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending message (" + message + ") to channel " + this.channel + " with timeout " + this.timeout);
            }
            this.channel.send((Message)message, this.timeout.longValue());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending message (" + message + ") to channel " + this.channel);
            }
            this.channel.send((Message)message);
        }
        LOG.debug("Inbound channel adapter received an unmatched listener event from esper");
    }

    public void destroy() {
        this.template.cleanup();
    }
}

