/*
 * Decompiled with CFR 0.152.
 */
package org.opencredo.esper.integration;

import org.opencredo.esper.integration.IntegrationOperation;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageContext {
    private final Message<?> message;
    private final MessageChannel channel;
    private final IntegrationOperation operation;
    private final boolean sent;
    private final String messageId;
    private final String sourceId;

    public MessageContext(Message<?> message, MessageChannel channel, IntegrationOperation operation, String sourceId) {
        this.message = message;
        this.channel = channel;
        this.operation = operation;
        this.sourceId = sourceId;
        this.sent = false;
        this.messageId = message.getHeaders().get((Object)"id").toString();
    }

    public MessageContext(Message<?> message, MessageChannel channel, boolean sent, String sourceId) {
        this.message = message;
        this.channel = channel;
        this.sourceId = sourceId;
        this.operation = IntegrationOperation.POST_SEND;
        this.sent = sent;
        this.messageId = message.getHeaders().get((Object)"id").toString();
    }

    public MessageContext(MessageChannel channel, String sourceId) {
        this.sourceId = sourceId;
        this.message = null;
        this.channel = channel;
        this.operation = IntegrationOperation.PRE_RECEIVE;
        this.sent = false;
        this.messageId = null;
    }

    public Message<?> getMessage() {
        return this.message;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public IntegrationOperation getOperation() {
        return this.operation;
    }

    public boolean isSent() {
        return this.sent;
    }

    public String getSourceId() {
        return this.sourceId;
    }
}

