/*
 * Decompiled with CFR 0.152.
 */
package org.opencredo.esper.integration.config.xml;

import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.opencredo.esper.integration.interceptor.EsperWireTap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.ChannelInterceptor;
import org.springframework.util.Assert;

public class EsperWireTapChannelsBeanPostProcessor
implements BeanPostProcessor {
    private final Map channelPatternMappings;

    public EsperWireTapChannelsBeanPostProcessor(Map channelPatternMappings) {
        Assert.notNull((Object)channelPatternMappings, (String)"channelPatternMappings must not be null");
        this.channelPatternMappings = channelPatternMappings;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AbstractMessageChannel) {
            this.addMatchingWireTaps((AbstractMessageChannel)bean);
        }
        return bean;
    }

    private void addMatchingWireTaps(AbstractMessageChannel channel) {
        Assert.notNull((Object)channel.getComponentName(), (String)"channel name must not be null");
        Set patternWireTapEntries = this.channelPatternMappings.entrySet();
        for (Map.Entry patternWireTapEntry : patternWireTapEntries) {
            if (!((Pattern)patternWireTapEntry.getKey()).matcher(channel.getComponentName()).matches()) continue;
            channel.addInterceptor((ChannelInterceptor)((EsperWireTap)patternWireTapEntry.getValue()));
        }
    }
}

