/*
 * Decompiled with CFR 0.152.
 */
package org.opencredo.esper.integration.config.xml;

import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class EsperWireTapChannelsParser
extends AbstractSingleBeanDefinitionParser {
    private static final String BASE_PACKAGE_NAME = "org.opencredo.esper.integration";

    protected String getBeanClassName(Element element) {
        return "org.opencredo.esper.integration.config.xml.EsperWireTapChannelsBeanPostProcessor";
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String defaultWireTapRef = element.getAttribute("default-wire-tap");
        List channelElements = DomUtils.getChildElementsByTagName((Element)element, (String)"channel");
        ManagedMap channelPatternMappings = new ManagedMap();
        for (Element channelElement : channelElements) {
            Pattern pattern = Pattern.compile(channelElement.getAttribute("pattern"));
            String wireTapRef = channelElement.getAttribute("wire-tap");
            if (!StringUtils.hasText((String)wireTapRef) && !StringUtils.hasText((String)defaultWireTapRef)) {
                parserContext.getReaderContext().error("At least one of 'default-wire-tap' or 'wire-tap' must be provided.", (Object)channelElement);
            }
            if (StringUtils.hasText((String)wireTapRef)) {
                channelPatternMappings.put((Object)pattern, (Object)new RuntimeBeanReference(wireTapRef));
                continue;
            }
            channelPatternMappings.put((Object)pattern, (Object)new RuntimeBeanReference(defaultWireTapRef));
        }
        builder.addConstructorArgValue((Object)channelPatternMappings);
    }
}

