/*
 * Decompiled with CFR 0.152.
 */
package org.opencredo.esper.integration.config.xml;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class EsperWireTapParser
extends AbstractBeanDefinitionParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.opencredo.esper.integration.interceptor.EsperWireTap");
        this.initializeEsperTemplate(element, builder);
        this.setSourceId(element, builder);
        this.initialiseSendContextProperty(element, builder);
        this.configureNotificationStrategy(element, builder);
        return builder.getBeanDefinition();
    }

    private void initializeEsperTemplate(Element element, BeanDefinitionBuilder builder) {
        String templateRef = element.getAttribute("template-ref");
        builder.addConstructorArgReference(templateRef);
    }

    private void initialiseSendContextProperty(Element element, BeanDefinitionBuilder builder) {
        String sendContext = element.getAttribute("send-context");
        if (sendContext != null && !"".equals(sendContext)) {
            builder.addPropertyValue("sendContext", (Object)Boolean.parseBoolean(sendContext));
        }
    }

    private void setSourceId(Element element, BeanDefinitionBuilder builder) {
        String sourceId = element.getAttribute("sourceId");
        Assert.hasText((String)sourceId, (String)"sourceId attribute is required");
        builder.addConstructorArgValue((Object)sourceId);
    }

    private void configureNotificationStrategy(Element element, BeanDefinitionBuilder builder) {
        String preSendFlag = element.getAttribute("pre-send");
        String postSendFlag = element.getAttribute("post-send");
        String preReceiveFlag = element.getAttribute("pre-receive");
        String postReceiveFlag = element.getAttribute("post-receive");
        if (StringUtils.hasText((String)preSendFlag) || StringUtils.hasText((String)postSendFlag) || StringUtils.hasText((String)preReceiveFlag) || StringUtils.hasText((String)postReceiveFlag)) {
            if (StringUtils.hasText((String)preSendFlag)) {
                builder.addPropertyValue("preSend", (Object)Boolean.parseBoolean(preSendFlag));
            } else {
                builder.addPropertyValue("preSend", (Object)false);
            }
            if (StringUtils.hasText((String)postSendFlag)) {
                builder.addPropertyValue("postSend", (Object)Boolean.parseBoolean(postSendFlag));
            } else {
                builder.addPropertyValue("postSend", (Object)false);
            }
            if (StringUtils.hasText((String)preReceiveFlag)) {
                builder.addPropertyValue("preReceive", (Object)Boolean.parseBoolean(preReceiveFlag));
            } else {
                builder.addPropertyValue("preReceive", (Object)false);
            }
            if (StringUtils.hasText((String)postReceiveFlag)) {
                builder.addPropertyValue("postReceive", (Object)Boolean.parseBoolean(postReceiveFlag));
            } else {
                builder.addPropertyValue("postReceive", (Object)false);
            }
        }
    }
}

