/*
 * Decompiled with CFR 0.152.
 */
package org.opencredo.esper.integration.interceptor;

import org.opencredo.esper.EsperTemplate;
import org.opencredo.esper.integration.IntegrationOperation;
import org.opencredo.esper.integration.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.channel.ChannelInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsperWireTap
implements ChannelInterceptor {
    private static final String SENT_MESSAGE_PAYLOAD_TO_ESPER_FROM_SOURCE = "Sent message payload to esper from source '";
    private static final String SENT_MESSAGE_CONTEXT_TO_ESPER_FROM_SOURCE = "Sent message context to esper from source '";
    private static final Logger LOG = LoggerFactory.getLogger(EsperWireTap.class);
    private final EsperTemplate template;
    private final String sourceId;
    private volatile boolean sendContext = false;
    private volatile boolean preSend = true;
    private volatile boolean postSend = true;
    private volatile boolean preReceive = true;
    private volatile boolean postReceive = true;

    public EsperWireTap(EsperTemplate template, String sourceId) {
        this.template = template;
        this.sourceId = sourceId;
    }

    public void setSendContext(boolean sendContext) {
        this.sendContext = sendContext;
    }

    public void setPreSend(boolean preSend) {
        this.preSend = preSend;
    }

    public void setPostSend(boolean postSend) {
        this.postSend = postSend;
    }

    public void setPreReceive(boolean preReceive) {
        this.preReceive = preReceive;
    }

    public void setPostReceive(boolean postReceive) {
        this.postReceive = postReceive;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if (this.preSend) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending a pre-send message to esper from source '" + this.sourceId + "'");
            }
            if (this.sendContext) {
                MessageContext context = new MessageContext(message, channel, IntegrationOperation.PRE_SEND, this.sourceId);
                this.template.sendEvent((Object)context);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SENT_MESSAGE_CONTEXT_TO_ESPER_FROM_SOURCE + this.sourceId + "'");
                }
            } else {
                this.template.sendEvent(message.getPayload());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SENT_MESSAGE_PAYLOAD_TO_ESPER_FROM_SOURCE + this.sourceId + "'");
                }
            }
        }
        return message;
    }

    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
        if (message == null) {
            return message;
        }
        if (this.postReceive) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending a post-receive message to esper from source '" + this.sourceId + "'");
            }
            if (this.sendContext) {
                MessageContext context = new MessageContext(message, channel, IntegrationOperation.POST_RECEIVE, this.sourceId);
                this.template.sendEvent((Object)context);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SENT_MESSAGE_CONTEXT_TO_ESPER_FROM_SOURCE + this.sourceId + "'");
                }
            } else {
                this.template.sendEvent(message.getPayload());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SENT_MESSAGE_PAYLOAD_TO_ESPER_FROM_SOURCE + this.sourceId + "'");
                }
            }
        }
        return message;
    }

    public void postSend(Message<?> message, MessageChannel channel, boolean sent) {
        if (this.postSend) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending a post-send message to esper from source '" + this.sourceId + "'");
            }
            if (this.sendContext) {
                MessageContext context = new MessageContext(message, channel, sent, this.sourceId);
                this.template.sendEvent((Object)context);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SENT_MESSAGE_CONTEXT_TO_ESPER_FROM_SOURCE + this.sourceId + "'");
                }
            } else {
                this.template.sendEvent(message.getPayload());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SENT_MESSAGE_PAYLOAD_TO_ESPER_FROM_SOURCE + this.sourceId + "'");
                }
            }
        }
    }

    public boolean preReceive(MessageChannel channel) {
        if (this.preReceive) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending a pre-receive message to esper from source '" + this.sourceId + "'");
            }
            MessageContext context = new MessageContext(channel, this.sourceId);
            this.template.sendEvent((Object)context);
            if (LOG.isDebugEnabled()) {
                LOG.debug(SENT_MESSAGE_CONTEXT_TO_ESPER_FROM_SOURCE + this.sourceId + "'");
            }
        }
        return true;
    }
}

