/*
 * Decompiled with CFR 0.152.
 */
package org.opencredo.esper;

import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EPStatementState;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.client.UpdateListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opencredo.esper.EsperStatementInvalidStateException;
import org.opencredo.esper.EsperStatementOperations;
import org.opencredo.esper.NativeEPStatementCallback;
import org.opencredo.esper.ParameterizedEsperRowMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsperStatement
implements EsperStatementOperations {
    private static final Logger LOG = LoggerFactory.getLogger(EsperStatement.class);
    private String epl;
    private EPStatement epStatement;
    private Set<UpdateListener> listeners = new LinkedHashSet<UpdateListener>();
    private Object subscriber;

    public EsperStatement(String epl) {
        this.epl = epl;
    }

    public String getEPL() {
        return this.epl;
    }

    public EPStatementState getState() {
        return this.epStatement.getState();
    }

    public void start() {
        LOG.info("Esper statement being started");
        this.epStatement.start();
        LOG.info("Esper statement started");
    }

    public void stop() {
        LOG.info("Esper statement being stopped");
        this.epStatement.stop();
        LOG.info("Esper statement stopped");
    }

    public void doWithNativeEPStatement(NativeEPStatementCallback callback) {
        callback.executeWithEPStatement(this.epStatement, this.epl);
    }

    public void setListeners(Set<UpdateListener> listeners) {
        this.listeners = listeners;
        this.refreshEPStatmentListeners();
    }

    public Set<UpdateListener> getListeners() {
        return this.listeners;
    }

    public void setSubscriber(Object subscriber) {
        this.subscriber = subscriber;
    }

    public void addListener(UpdateListener listener) {
        this.listeners.add(listener);
        this.refreshEPStatmentListeners();
        this.addEPStatementListener(listener);
    }

    private void refreshEPStatmentListeners() {
        for (UpdateListener listener : this.listeners) {
            this.addEPStatementListener(listener);
        }
    }

    private void addEPStatementListener(UpdateListener listener) {
        if (this.subscriber == null && this.epStatement != null) {
            this.epStatement.addListener(listener);
        }
    }

    void setEPStatement(EPStatement epStatement) {
        this.epStatement = epStatement;
        if (this.subscriber != null) {
            epStatement.setSubscriber(this.subscriber);
        } else {
            for (UpdateListener listener : this.listeners) {
                epStatement.addListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> concurrentSafeQuery(ParameterizedEsperRowMapper<T> rm) {
        LOG.info("Concurrent safe query being executed");
        if (this.epStatement.isStopped() || this.epStatement.isDestroyed()) {
            LOG.error("Concurrent safe query was attempted when the statement was stopped or destroyed");
            throw new EsperStatementInvalidStateException("Attempted to execute a concurrent safe query when esper statement resource had state of " + this.epStatement.getState());
        }
        SafeIterator safeIter = this.epStatement.safeIterator();
        ArrayList<T> objectList = new ArrayList<T>();
        try {
            while (safeIter.hasNext()) {
                EventBean event = (EventBean)safeIter.next();
                objectList.add(rm.mapRow(event));
            }
        }
        finally {
            safeIter.close();
        }
        LOG.info("Concurrent safe query was completed");
        return objectList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T concurrentSafeQueryForObject(ParameterizedEsperRowMapper<T> rm) {
        LOG.info("Concurrent safe query for object being executed");
        if (this.epStatement.isStopped() || this.epStatement.isDestroyed()) {
            LOG.error("Concurrent safe query for object was attempted when the statement was stopped or destroyed");
            throw new EsperStatementInvalidStateException("Attempted to execute a concurrent safe query for object when esper statement resource had state of " + this.epStatement.getState());
        }
        SafeIterator safeIter = this.epStatement.safeIterator();
        T result = null;
        try {
            while (safeIter.hasNext()) {
                EventBean event = (EventBean)safeIter.next();
                if (safeIter.hasNext()) continue;
                result = rm.mapRow(event);
            }
        }
        finally {
            safeIter.close();
        }
        LOG.info("Concurrent safe query for object was completed");
        return result;
    }

    @Override
    public <T> List<T> concurrentUnsafeQuery(ParameterizedEsperRowMapper<T> rm) {
        LOG.info("Concurrent unsafe query being executed");
        if (this.epStatement.isStopped() || this.epStatement.isDestroyed()) {
            LOG.error("Concurrent unsafe query was attempted when the statement was stopped or destroyed");
            throw new EsperStatementInvalidStateException("Attempted to execute a concurrent unsafe query when esper statement resource had state of " + this.epStatement.getState());
        }
        Iterator safeIter = this.epStatement.iterator();
        ArrayList<T> objectList = new ArrayList<T>();
        while (safeIter.hasNext()) {
            EventBean event = (EventBean)safeIter.next();
            objectList.add(rm.mapRow(event));
        }
        LOG.info("Concurrent unsafe query was completed");
        return objectList;
    }

    @Override
    public <T> T concurrentUnsafeQueryForObject(ParameterizedEsperRowMapper<T> rm) {
        LOG.info("Concurrent unsafe query for object being executed");
        if (this.epStatement.isStopped() || this.epStatement.isDestroyed()) {
            LOG.error("Concurrent unsafe query for object was attempted when the statement was stopped or destroyed");
            throw new EsperStatementInvalidStateException("Attempted to execute a concurrent unsafe query for object when esper statement resource had state of " + this.epStatement.getState());
        }
        Iterator safeIter = this.epStatement.iterator();
        T result = null;
        while (safeIter.hasNext()) {
            EventBean event = (EventBean)safeIter.next();
            if (safeIter.hasNext()) continue;
            result = rm.mapRow(event);
        }
        LOG.info("Concurrent unsafe query for object was completed");
        return result;
    }
}

