/*
 * Decompiled with CFR 0.152.
 */
package org.opencredo.esper;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPRuntime;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.UnmatchedListener;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opencredo.esper.EsperStatement;
import org.opencredo.esper.EsperTemplateOperations;
import org.opencredo.esper.InvalidEsperConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsperTemplate
implements EsperTemplateOperations {
    private static final Logger LOG = LoggerFactory.getLogger(EsperTemplate.class);
    private EPServiceProvider epServiceProvider;
    private EPRuntime epRuntime;
    private String name;
    private Set<EsperStatement> statements = new LinkedHashSet<EsperStatement>();
    private Resource configuration;
    private UnmatchedListener unmatchedListener;
    private volatile boolean initialised = false;

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setStatements(Set<EsperStatement> statements) {
        this.statements = statements;
    }

    @Override
    public void setConfiguration(Resource configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setUnmatchedListener(UnmatchedListener unmatchedListener) {
        this.unmatchedListener = unmatchedListener;
    }

    @Override
    public EPRuntime getEsperNativeRuntime() {
        return this.epRuntime;
    }

    @Override
    public Set<EsperStatement> getStatements() {
        return this.statements;
    }

    @Override
    public synchronized void addStatement(EsperStatement statement) {
        this.statements.add(statement);
        if (this.initialised) {
            EPStatement epStatement = this.epServiceProvider.getEPAdministrator().createEPL(statement.getEPL());
            statement.setEPStatement(epStatement);
        }
    }

    @Override
    public void sendEvent(Object event) throws InvalidEsperConfigurationException {
        LOG.debug("Sending event to Esper");
        if (this.epRuntime == null) {
            LOG.error("Attempted to send message with null Esper Runtime.");
            throw new InvalidEsperConfigurationException("Esper Runtime is null. Have you initialized the template before you attempt to send an event?");
        }
        this.epRuntime.sendEvent(event);
        LOG.debug("Sent event to Esper");
    }

    @Override
    public synchronized void initialize() throws InvalidEsperConfigurationException {
        if (this.initialised) {
            throw new InvalidEsperConfigurationException("EsperTemplate should only be initialised once");
        }
        this.initialised = true;
        LOG.debug("Initializing esper template");
        try {
            this.configureEPServiceProvider();
            this.epRuntime = this.epServiceProvider.getEPRuntime();
            if (this.unmatchedListener != null) {
                this.epRuntime.setUnmatchedListener(this.unmatchedListener);
            }
            this.setupEPStatements();
        }
        catch (Exception e) {
            LOG.error("An exception occured when attempting to initialize the esper template", (Throwable)e);
            throw new InvalidEsperConfigurationException(e.getMessage(), e);
        }
        LOG.debug("Finished initializing esper template");
    }

    @Override
    public void cleanup() {
        this.epServiceProvider.destroy();
    }

    private void setupEPStatements() {
        for (EsperStatement statement : this.statements) {
            EPStatement epStatement = this.epServiceProvider.getEPAdministrator().createEPL(statement.getEPL());
            statement.setEPStatement(epStatement);
        }
    }

    private void configureEPServiceProvider() throws EPException, IOException {
        LOG.debug("Configuring the Esper Service Provider");
        if (this.configuration != null && this.configuration.exists()) {
            Configuration configuration = new Configuration();
            configuration = configuration.configure(this.configuration.getFile());
            this.epServiceProvider = EPServiceProviderManager.getProvider((String)this.name, (Configuration)configuration);
            LOG.info("Esper configured with a user-provided configuration", (Object)configuration);
        } else {
            this.epServiceProvider = EPServiceProviderManager.getProvider((String)this.name);
        }
        LOG.debug("Completed configuring the Esper Service Provider");
    }
}

