/*
 * Decompiled with CFR 0.152.
 */
package org.opencredo.esper.config.xml;

import org.opencredo.esper.config.xml.EsperListenerParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EsperStatementParser
extends AbstractBeanDefinitionParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.opencredo.esper.EsperStatement");
        String query = element.getAttribute("epl");
        builder.addConstructorArgValue((Object)query);
        ManagedSet listeners = null;
        Element listenersElement = DomUtils.getChildElementByTagName((Element)element, (String)"listeners");
        if (listenersElement != null) {
            EsperListenerParser listenerParser = new EsperListenerParser();
            listeners = listenerParser.parseListeners(listenersElement, parserContext);
            if (listeners != null) {
                builder.addPropertyValue("listeners", (Object)listeners);
            } else {
                parserContext.getReaderContext().error("At least one 'listener' should be provided.", (Object)listenersElement);
            }
        } else {
            Element subscriberElement = DomUtils.getChildElementByTagName((Element)element, (String)"subscriber");
            if (subscriberElement != null) {
                String subscriberRef = subscriberElement.getAttribute("ref");
                if (StringUtils.hasText((String)subscriberRef)) {
                    builder.addPropertyReference("subscriber", subscriberRef);
                }
            } else {
                parserContext.getReaderContext().error("At least one of 'listeners' or 'subscriber' should be provided.", (Object)element);
            }
        }
        return builder.getBeanDefinition();
    }

    public ManagedSet parseStatements(Element element, ParserContext parserContext) {
        ManagedSet statements = new ManagedSet();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            Element childElement = (Element)child;
            String localName = child.getLocalName();
            if ("statement".equals(localName)) {
                BeanDefinition definition = parserContext.getDelegate().parseCustomElement(childElement);
                statements.add((Object)definition);
                continue;
            }
            if (!"ref".equals(localName)) continue;
            String ref = childElement.getAttribute("bean");
            statements.add((Object)new RuntimeBeanReference(ref));
        }
        return statements;
    }
}

