/*
 * Decompiled with CFR 0.152.
 */
package org.opencredo.esper.config.xml;

import org.opencredo.esper.config.xml.EsperStatementParser;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class EsperTemplateParser
extends AbstractBeanDefinitionParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.opencredo.esper.spring.EsperTemplateBean");
        this.initialiseStatements(element, parserContext, builder);
        this.initializeConfiguration(element, builder);
        this.initializeUnmatchedListener(element, builder);
        return builder.getBeanDefinition();
    }

    private void initializeUnmatchedListener(Element element, BeanDefinitionBuilder builder) {
        String unmatchedListenerRef = element.getAttribute("unmatched-listener-ref");
        if (StringUtils.hasText((String)unmatchedListenerRef)) {
            builder.addPropertyReference("unmatchedListener", unmatchedListenerRef);
        }
    }

    private void initializeConfiguration(Element element, BeanDefinitionBuilder builder) {
        String configuration = element.getAttribute("configuration");
        if (StringUtils.hasText((String)configuration)) {
            builder.addPropertyValue("configuration", (Object)configuration);
        }
    }

    private void initialiseStatements(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ManagedSet statements = null;
        Element statementsElement = DomUtils.getChildElementByTagName((Element)element, (String)"statements");
        if (statementsElement != null) {
            EsperStatementParser statementParser = new EsperStatementParser();
            statements = statementParser.parseStatements(statementsElement, parserContext);
        }
        if (statements != null) {
            builder.addPropertyValue("statements", statements);
        }
    }
}

