/*
 * ====================================================================
 * Project:     openCRX/Gradle, http://www.opencrx.org/
 * Description: CoreWarTask
 * Owner:       CRIXP AG, Switzerland, http://www.crixp.com
 * ====================================================================
 *
 * This software is published under the BSD license
 * as listed below.
 * 
 * Copyright (c) 2020, CRIXP Corp., Switzerland
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 * 
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in
 * the documentation and/or other materials provided with the
 * distribution.
 * 
 * * Neither the name of CRIXP Corp. nor the names of the contributors
 * to openCRX may be used to endorse or promote products derived
 * from this software without specific prior written permission
 * 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * ------------------
 * 
 * This product includes software developed by the Apache Software
 * Foundation (http://www.apache.org/).
 * 
 * This product includes software developed by contributors to
 * openMDX (http://www.openmdx.org/)
 */
package org.opencrx.gradle

import org.gradle.api.tasks.Input
import org.gradle.api.tasks.InputFiles
import org.gradle.api.file.DuplicatesStrategy
import org.gradle.api.file.FileTree
import java.io.File
import org.gradle.api.JavaVersion

open class CoreWarTask: ArchiveTask() {

	init {
   		destinationDirectory.set(File(deliverDir, "deployment-unit"))
	    archiveFileName.set(getWebAppName("core") + ".war")
		manifest {
	        attributes(
	        	getManifest(
	        		"openCRX/Core " + providerName + " WAR",
	        		"opencrx-core-" + providerName + ".war"
	        	)
	        )
	    }
	    duplicatesStrategy = DuplicatesStrategy.EXCLUDE
	    includeEmptyDirs = false
		var opencrxDataFiles: FileTree = project.zipTree(project.getConfigurations().getByName("opencrxData").singleFile)
	    var openmdxInspectorFiles: FileTree = project.zipTree(project.getConfigurations().getByName("openmdxInspector").singleFile)		
		// WEB-INF
		from(File(dataHome, dataDir + "/WEB-INF")) { into("WEB-INF"); exclude("**/*.java"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("WEB-INF"); include(dataDirGeneric + "/WEB-INF/**"); exclude("**/*.java"); exclude("*/*") }
		// META-INF
		from(File(dataHome, dataDir + "/META-INF")) { into("META-INF"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("META-INF"); include(dataDirGeneric + "/META-INF"); filter { line -> archiveFilter(line) } }
	    // WEB-INF/classes
		from(File(buildDir, "classes/java/main")) { include("org/opencrx/portal/**/*.class"); into("WEB-INF/classes") }
		// WEB-INF/code
		from(File(dataHome, dataDir + "/code")) { into("WEB-INF/config/code"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("WEB-INF/config/code"); include(dataDirGeneric + "/code"); filter { line -> archiveFilter(line) } }
	 	// WEB-INF/bootstrap
		from(File(dataHome, dataDir + "/bootstrap")) { into("WEB-INF/config/bootstrap"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("WEB-INF/config/bootstrap"); include(dataDirGeneric + "/bootstrap"); filter { line -> archiveFilter(line) } }
		// WEB-INF/datapass closures
		from(File(dataHome, dataDir + "/data")) { into("WEB-INF/config/data"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("WEB-INF/config/data"); include(dataDirGeneric + "/data"); filter { line -> archiveFilter(line) } }
		// WEB-INF/filters
		from(File(dataHome, dataDir + "/filters")) { into("WEB-INF/config/filters"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("WEB-INF/config/filters"); include(dataDirGeneric + "/filters"); filter { line -> archiveFilter(line) } }
		// WEB-INF/scripts
		from(File(dataHome, dataDir + "/scripts")) { into("WEB-INF/config/scripts"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("WEB-INF/config/scripts"); include(dataDirGeneric + "/scripts"); filter { line -> archiveFilter(line) } }
		// WEB-INF/texts
		from(File(dataHome, dataDir + "/texts")) { into("WEB-INF/config/texts"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("WEB-INF/config/texts"); include(dataDirGeneric + "/texts"); filter { line -> archiveFilter(line) } }
		// WEB-INF/ui
		from(File(dataHome, dataDir + "/ui")) { into("WEB-INF/config/ui"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("WEB-INF/config/ui"); include(dataDirGeneric + "/ui"); filter { line -> archiveFilter(line) } }
		// WEB-INF/control
		from(File(dataHome, dataDir + "/control")) { into("WEB-INF/config/control"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("WEB-INF/config/control"); include(dataDirGeneric + "/control"); filter { line -> archiveFilter(line) } }
		// _style
		from(File(dataHome, dataDir + "/_style")) { into("_style"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("_style"); include(dataDirGeneric + "/_style"); filter { line -> archiveFilter(line) } }
		// js
		from(File(dataHome, dataDir + "/js")) { into("js"); }
		from(opencrxDataFiles) { into("js"); include(dataDirGeneric + "/js"); }
		// html
		from(File(dataHome, dataDir + "/html")) { filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("/"); include(dataDirGeneric + "/html"); filter { line -> archiveFilter(line) } }
		// jsp, properties
		from(File(dataHome, dataDir)) { include("**/*.jsp", "**/*.properties"); exclude("**/*.texts.properties"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("/"); include(dataDirGeneric + "/**/*.jsp", dataDirGeneric + "/**/*.properties"); exclude("**/*.texts.properties"); filter { line -> archiveFilter(line) } }
		// images
		from(File(dataHome, dataDir + "/images")) { into("images"); include("*.gif", "*.jpg", "*.png", "*.ico") }
		from(opencrxDataFiles) { into("images"); include(dataDirGeneric + "/**/*.gif", dataDirGeneric + "/**/*.jpg", dataDirGeneric + "/**/*.png", dataDirGeneric + "/**/*.ico") }
		// documents
		from(File(dataHome, dataDir + "/documents")) { into("documents") }
		from(opencrxDataFiles) { into("documents"); include(dataDirGeneric + "/documents") }
		// wizards
		from(File(dataHome, dataDir + "/wizards")) { into("wizards"); filter { line -> archiveFilter(line) } }
		from(opencrxDataFiles) { into("wizards"); include(dataDirGeneric + "/wizards"); filter { line -> archiveFilter(line) } }
		// openmdx-inspector
		from(openmdxInspectorFiles) { exclude("**/texts/de_DE/**"); filter { line -> archiveFilter(line) } }		
	}
	
}
