/*
 * ====================================================================
 * Project:     openCRX/Gradle, http://www.opencrx.org/
 * Description: OpencrxPlugin
 * Owner:       CRIXP AG, Switzerland, http://www.crixp.com
 * ====================================================================
 *
 * This software is published under the BSD license
 * as listed below.
 * 
 * Copyright (c) 2020, CRIXP Corp., Switzerland
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 * 
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in
 * the documentation and/or other materials provided with the
 * distribution.
 * 
 * * Neither the name of CRIXP Corp. nor the names of the contributors
 * to openCRX may be used to endorse or promote products derived
 * from this software without specific prior written permission
 * 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * ------------------
 * 
 * This product includes software developed by the Apache Software
 * Foundation (http://www.apache.org/).
 * 
 * This product includes software developed by contributors to
 * openMDX (http://www.openmdx.org/)
 */
package org.opencrx.gradle

import org.gradle.api.Project
import org.gradle.api.Plugin
import java.io.File
import org.gradle.kotlin.dsl.*

open class OpencrxPluginExtension(project: Project) {
	var earlib = project.getConfigurations().getByName("earlib")
}

open class OpencrxPlugin: Plugin<Project> {

	override fun apply(project: Project): Unit = project.run {
		val extension = extensions.create<OpencrxPluginExtension>("opencrx", project)
		// opencrx-resources.jar
		val resourcesJarTask = tasks.register<ResourcesJarTask>("opencrx-resources.jar")
		resourcesJarTask {
			dependsOn("classes")
		}
		// opencrx-core.jar
		val coreJarTask = tasks.register<CoreJarTask>("opencrx-core.jar")
		coreJarTask {
			dependsOn("classes")
		}
		// opencrx-data.jar
		val dataJarTask = tasks.register<DataJarTask>("opencrx-data.jar")
		dataJarTask {
			dependsOn("classes")
		}
		// opencrx-ear.jar
		val earJarTask = tasks.register<EarJarTask>("opencrx-ear.jar")
		earJarTask {
			dependsOn("classes")
		}
		// opencrx-client.jar
		val clientJarTask = tasks.register<ClientJarTask>("opencrx-client.jar")
		clientJarTask {
			dependsOn("classes")
		}
		// opencrx-core.war
		val coreWarTask = tasks.register<CoreWarTask>("opencrx-core.war")
		coreWarTask {
			dependsOn("deliverables")
		}
		// opencrx-ical.war
		val iCalWarTask = tasks.register<ICalWarTask>("opencrx-ical.war")
		iCalWarTask {
			dependsOn("deliverables")
		}
		// opencrx-caldav.war
		val calDavWarTask = tasks.register<CalDavWarTask>("opencrx-caldav.war")
		calDavWarTask {
			dependsOn("deliverables")
		}
		// opencrx-carddav.war
		val cardDavWarTask = tasks.register<CardDavWarTask>("opencrx-carddav.war")
		cardDavWarTask {
			dependsOn("deliverables")
		}
		// opencrx-webdav.war
		val webDavWarTask = tasks.register<WebDavWarTask>("opencrx-webdav.war")
		webDavWarTask {
			dependsOn("deliverables")
		}
		// opencrx-imap.war
		val imapWarTask = tasks.register<ImapWarTask>("opencrx-imap.war")
		imapWarTask {
			dependsOn("deliverables")
		}
		// opencrx-vcard.war
		val vCardWarTask = tasks.register<VCardWarTask>("opencrx-vcard.war")
		vCardWarTask {
			dependsOn("deliverables")
		}
		// opencrx-spaces.war
		val spacesWarTask = tasks.register<SpacesWarTask>("opencrx-spaces.war")
		spacesWarTask {
			dependsOn("deliverables")
		}
		// opencrx-rest.war
		val restWarTask = tasks.register<RestWarTask>("opencrx-rest.war")
		restWarTask {
			dependsOn("deliverables")
		}
		// opencrx-ldap.war
		val ldapWarTask = tasks.register<LdapWarTask>("opencrx-ldap.war")
		ldapWarTask {
			dependsOn("deliverables")
		}
		// opencrx-bpi.war
		val bpiWarTask = tasks.register<BpiWarTask>("opencrx-bpi.war")
		bpiWarTask {
			dependsOn("deliverables")
		}
		// opencrx-calendar.war
		val calendarWarTask = tasks.register<CalendarWarTask>("opencrx-calendar.war")
		calendarWarTask {
			dependsOn("deliverables")
		}
		// opencrx-documents.war
		val documentsWarTask = tasks.register<DocumentsWarTask>("opencrx-documents.war")
		documentsWarTask {
			dependsOn("deliverables")
		}
		// opencrx-contacts.war
		val contactsWarTask = tasks.register<ContactsWarTask>("opencrx-contacts.war")
		contactsWarTask {
			dependsOn("deliverables")
		}
		// opencrx.ear
		val earTask = tasks.register<org.opencrx.gradle.EarTask>("opencrx.ear")
		earTask {
			dependsOn(
				"deliverables",
				"opencrx-core.war",
				"opencrx-ical.war",
				"opencrx-caldav.war",
				"opencrx-carddav.war",
				"opencrx-webdav.war",
				"opencrx-imap.war",
				"opencrx-vcard.war",
				"opencrx-spaces.war",
				"opencrx-rest.war",
				"opencrx-ldap.war",
				"opencrx-bpi.war",
				"opencrx-calendar.war",
				"opencrx-documents.war",
				"opencrx-contacts.war"
			)
			libs = extension.earlib
		}
		// render-diagrams
		val renderDiagramsTask = tasks.register<RenderDiagramsTask>("render-diagrams")
		renderDiagramsTask {
			inputs.dir("src/model/graphviz/diagrams")
			classpath = configurations["tools"]
		}
		// create-schema
		val createSchemaTask = tasks.register<org.opencrx.gradle.CreateSchemaTask>("create-schema")
		createSchemaTask {
			dependsOn("deliverables")
		}
		// create-sql
		val createSqlTask = tasks.register<CreateSqlTask>("create-sql")
		createSqlTask {
			dependsOn("deliverables")
		}
		// generate-model
		val generateModelTask = tasks.register<GenerateModelsTask>("generate-model")
		generateModelTask {
			inputs.dir("${projectDir}/src/model/emf")
			inputs.dir("${projectDir}/src/main/resource")
			outputs.file("${buildDir}/generated/sources/model/opencrx-core-models.zip")
			outputs.file("${buildDir}/generated/sources/model/opencrx-core.openmdx-xmi.zip")
			classpath = configurations["compileClasspath"]
			doFirst {
				project.copy {
					from(project.zipTree(project.getConfigurations().getByName("openmdxBaseModels").singleFile))
					into(File(project.getBuildDir(), "generated/sources/model/openmdx/base"))
				}
				project.copy {
					from(project.zipTree(project.getConfigurations().getByName("openmdxSecurityModels").singleFile))
					into(File(project.getBuildDir(), "generated/sources/model/openmdx/security"))
				}
			}				
			doLast {
				copy {	
					from(
						zipTree("${buildDir}/generated/sources/model/opencrx-core-models.zip")
					)
					into("$buildDir/generated/sources/java/main")
					include(
						"**/*.java"
					)
				}
			}
		}
	}
}
