/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.util.Objects;
import org.opencypher.generator.Choices;
import org.opencypher.generator.Node;
import org.opencypher.grammar.BiasedTerms;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Optional;
import org.opencypher.grammar.Repetition;
import org.opencypher.tools.grammar.ISO14977;
import org.opencypher.tools.io.Output;

public class TracingChoices
implements Choices {
    private final Output output;
    private final Choices choices;

    public TracingChoices(Output output, Choices choices) {
        this.output = Objects.requireNonNull(output, "output");
        this.choices = Objects.requireNonNull(choices, "choices");
    }

    @Override
    public Grammar.Term choose(Node location, BiasedTerms alternatives) {
        Grammar.Term result = this.choices.choose(location, alternatives);
        TracingChoices.location(this.output.append("At "), location).append(" choose: ").append(result.toString()).println();
        return result;
    }

    @Override
    public int repetition(Node location, Repetition repetition) {
        int result = this.choices.repetition(location, repetition);
        TracingChoices.location(this.output.append("At "), location).append(" repeat ").append(repetition.term(), ISO14977::append).append(" ").append(result).println(" times");
        return result;
    }

    @Override
    public boolean includeOptional(Node location, Optional optional) {
        boolean result = this.choices.includeOptional(location, optional);
        TracingChoices.location(this.output.append("At "), location).append(result ? " include optional " : " exclude optional ").append(optional.term(), ISO14977::append).println(".");
        return result;
    }

    @Override
    public int codePoint(Node location, CharacterSet characters) {
        int result = this.choices.codePoint(location, characters);
        TracingChoices.location(this.output.append("At "), location).append(" emit char '").appendCodePoint(result).println("'.");
        return result;
    }

    static Output location(Output output, Node location) {
        Node parent = location.parent();
        if (parent != null) {
            TracingChoices.location(output, parent);
            output.append(" -> ");
        }
        output.append(location.name());
        return output;
    }
}

