/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.railroad;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.opencypher.railroad.Diagram;
import org.opencypher.tools.io.Output;

class PositionedText {
    private final List<Text> text = new ArrayList<Text>();

    PositionedText() {
    }

    public void add(double row, double col, String text) {
        this.text.add(new Text((int)row, (int)col, text));
    }

    public void emit(Output target) {
        Object[] text = this.text.toArray(new Text[0]);
        Arrays.sort(text);
        int row = 0;
        int col = 0;
        for (int i = 0; i < text.length; ++i) {
            Object element = text[i];
            while (row < ((Text)element).row) {
                target.println();
                ++row;
                col = 0;
            }
            while (col < ((Text)element).col) {
                target.append(' ');
                ++col;
            }
            target.append(((Text)element).text);
            col += ((Text)element).text.length();
        }
    }

    private static class Text
    implements Comparable<Text> {
        private final int row;
        private final int col;
        private final String text;

        Text(int row, int col, String text) {
            this.row = row;
            this.col = col;
            this.text = text;
        }

        @Override
        public int compareTo(Text that) {
            int cmp = this.row - that.row;
            if (cmp == 0) {
                cmp = this.col - that.col;
            }
            return cmp;
        }
    }

    static abstract class Renderer
    implements Diagram.Renderer<PositionedText, String, RuntimeException>,
    Diagram.CanvasProvider<PositionedText, RuntimeException>,
    Function<PositionedText, String> {
        Renderer() {
        }

        @Override
        public PositionedText newCanvas(String name, double width, double height) {
            return new PositionedText();
        }

        @Override
        public String apply(PositionedText text) {
            Output.Readable result = Output.stringBuilder();
            text.emit(result);
            return result.toString();
        }

        @Override
        public void renderDiagram(String name, PositionedText text, Diagram.Figure root) {
            root.render(text, 0.0, 0.0, this, true);
        }

        @Override
        public String renderText(String type, String text) {
            return text;
        }
    }
}

