/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.antlr.v4.Tool;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerInterpreter;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserInterpreter;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.junit.Assert;
import org.opencypher.grammar.Fixture;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.grammar.Antlr4;
import org.opencypher.tools.grammar.Antlr4Massager;

public class Antlr4TestUtils {
    private static Grammar g = null;
    private static Grammar legacyGrammar = null;

    public static void parse(String query) {
        Antlr4TestUtils.initGrammar("/cypher.xml");
        Antlr4TestUtils.parse(g, query);
    }

    static void parseLegacy(String query) {
        System.setProperty(Grammar.ParserOption.INCLUDE_LEGACY.name(), "true");
        Antlr4TestUtils.initLegacyGrammar("/cypher.xml");
        Antlr4TestUtils.parse(legacyGrammar, query);
    }

    private static void initLegacyGrammar(String resource) {
        if (legacyGrammar == null) {
            legacyGrammar = Antlr4TestUtils.createGrammar(resource, Grammar.ParserOption.INCLUDE_LEGACY);
        }
    }

    private static void initGrammar(String resource) {
        if (g == null) {
            g = Antlr4TestUtils.createGrammar(resource, new Grammar.ParserOption[0]);
        }
    }

    private static Grammar createGrammar(String resource, Grammar.ParserOption ... options) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String grammarString = null;
        try {
            Antlr4.write((org.opencypher.grammar.Grammar)Fixture.grammarResource(Antlr4.class, resource, options), (OutputStream)out);
            grammarString = Antlr4Massager.postProcess((String)out.toString(StandardCharsets.UTF_8.name()));
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)"Unexpected error while writing antlr grammar");
        }
        Tool tool = new Tool();
        GrammarRootAST ast = tool.parseGrammarFromString(grammarString);
        Grammar grammar = tool.createGrammar(ast);
        tool.process(grammar, false);
        return grammar;
    }

    private static void parse(Grammar grammar, String query) {
        LexerInterpreter lexer = grammar.createLexerInterpreter((CharStream)new ANTLRInputStream(query));
        ParserInterpreter parser = grammar.createParserInterpreter((TokenStream)new CommonTokenStream((TokenSource)lexer));
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new FailingErrorListener(query));
        parser.addErrorListener((ANTLRErrorListener)new FailingErrorListener(query));
        parser.parse(grammar.getRule((String)"cypher").index);
    }

    private static class FailingErrorListener
    implements ANTLRErrorListener {
        private final String query;

        FailingErrorListener(String query) {
            this.query = query;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object o, int i, int i1, String s, RecognitionException e) {
            Assert.fail((String)("syntax error in query: " + this.query));
        }

        public void reportAmbiguity(Parser parser, DFA dfa, int i, int i1, boolean b, BitSet bitSet, ATNConfigSet atnConfigSet) {
            Assert.fail((String)("ambiguity in query: " + this.query));
        }

        public void reportAttemptingFullContext(Parser parser, DFA dfa, int i, int i1, BitSet bitSet, ATNConfigSet atnConfigSet) {
        }

        public void reportContextSensitivity(Parser parser, DFA dfa, int i, int i1, int i2, ATNConfigSet atnConfigSet) {
        }
    }
}

