/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.railroad;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Production;
import org.opencypher.grammar.ProductionTransformation;
import org.opencypher.railroad.FigureBuilder;
import org.opencypher.railroad.Size;
import org.opencypher.tools.Functions;

public final class Diagram {
    private static final ProductionTransformation<BuilderOptions, Optional<Diagram>, RuntimeException> PRODUCTION = (options, production) -> (production.skip() || production.inline()) && !options.skipNone() ? Optional.empty() : Optional.of(Diagram.build(production, options));
    private final String name;
    private final Figure root;

    public static List<Diagram> build(Grammar grammar, BuilderOptions options) {
        return grammar.transform(PRODUCTION, options, Functions.flatList());
    }

    public static Diagram build(Production production, BuilderOptions options) {
        return new Diagram(production.name(), FigureBuilder.build(production.definition(), options));
    }

    public <Canvas, EX extends Exception, R extends Renderer<Canvas, ?, EX> & CanvasProvider<? extends Canvas, ? extends EX>> void render(R renderer) throws EX {
        this.render(renderer, renderer);
    }

    public <Canvas, EX extends Exception> void render(Renderer<Canvas, ?, EX> renderer, CanvasProvider<? extends Canvas, ? extends EX> provider) throws EX {
        this.convert(renderer, provider, canvas -> null);
    }

    public <Result, Canvas, EX extends Exception, R extends Renderer<? super Canvas, ?, EX> & CanvasProvider<? extends Canvas, ? extends EX>> Result convert(R renderer) throws EX {
        return this.convert(renderer, renderer, (Function)renderer);
    }

    public <Result, Canvas, EX extends Exception, P extends CanvasProvider<? extends Canvas, ? extends EX> & Function<Canvas, Result>> Result convert(Renderer<? super Canvas, ?, EX> renderer, P provider) throws EX {
        return this.convert(renderer, provider, provider);
    }

    public <Result, Canvas, EX extends Exception, R extends Renderer<? super Canvas, ?, EX> & CanvasProvider<? extends Canvas, ? extends EX>> Result convert(R renderer, Function<Canvas, Result> finish) throws EX {
        return this.convert(renderer, renderer, finish);
    }

    public <Result, Canvas, EX extends Exception> Result convert(Renderer<? super Canvas, ?, EX> renderer, CanvasProvider<? extends Canvas, ? extends EX> provider, Function<Canvas, Result> finish) throws EX {
        Size size = renderer.diagramSize(this.root.size(renderer));
        Canvas canvas = provider.newCanvas(this.name, size.width, size.height);
        renderer.renderDiagram(this.name, canvas, this.root);
        return finish.apply(canvas);
    }

    public String name() {
        return this.name;
    }

    private Diagram(String name, Figure root) {
        this.name = name;
        this.root = root;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Diagram that = (Diagram)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.root, that.root);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("Diagram{'").append(this.name).append("': ");
        this.root.toString(result);
        return result.append("}").toString();
    }

    public static Diagram diagram(String name, Figure figure) {
        return new Diagram(Objects.requireNonNull(name, "name"), FigureBuilder.root(Objects.requireNonNull(figure, "figure")));
    }

    public static Figure nothing() {
        return FigureBuilder.nothing();
    }

    public static Figure text(String text) {
        return FigureBuilder.text(text);
    }

    public static Figure anyCase(String text) {
        return FigureBuilder.anyCase(text);
    }

    public static Figure reference(String name) {
        return FigureBuilder.reference(name, name);
    }

    public static Figure charset(String set) {
        return FigureBuilder.charset(set);
    }

    public static Figure line(Figure ... content) {
        return FigureBuilder.line(content);
    }

    public static Figure branch(Figure ... branches) {
        return FigureBuilder.branch(branches);
    }

    public static Figure loop(Figure forward, Figure backwards, int minTimes, Integer maxTimes) {
        return FigureBuilder.loop(forward, backwards, minTimes, maxTimes);
    }

    public static abstract class Figure {
        private FigureBuilder.Conditional<Size> size = FigureBuilder.Conditional.none();

        Figure() {
        }

        abstract <T> Size computeSize(Renderer<?, T, ?> var1);

        public abstract <O, T, EX extends Exception> void render(O var1, double var2, double var4, Renderer<O, T, EX> var6, boolean var7) throws EX;

        public boolean isNothing() {
            return false;
        }

        public Size size(Renderer<?, ?, ?> renderer) {
            this.size = this.size.compute(this, renderer, Figure::computeSize);
            return (Size)this.size.get();
        }

        public final String toString() {
            StringBuilder result = new StringBuilder();
            this.toString(result);
            return result.toString();
        }

        abstract void toString(StringBuilder var1);
    }

    public static interface CanvasProvider<Canvas, EX extends Exception> {
        public Canvas newCanvas(String var1, double var2, double var4) throws EX;
    }

    public static interface Renderer<Canvas, Text, EX extends Exception> {
        default public Size diagramSize(Size rootSize) {
            return rootSize;
        }

        public void renderDiagram(String var1, Canvas var2, Figure var3) throws EX;

        public Text renderText(String var1, String var2);

        public Size sizeOfBullet();

        public void renderBullet(Canvas var1, double var2, double var4) throws EX;

        public Size sizeOfNothing();

        public void renderNothing(Canvas var1, double var2, double var4, boolean var6) throws EX;

        public Size sizeOfText(Text var1);

        public void renderText(Canvas var1, double var2, double var4, Text var6) throws EX;

        public Size sizeOfAnyCase(Text var1);

        public void renderAnyCase(Canvas var1, double var2, double var4, Text var6) throws EX;

        public Size sizeOfReference(Text var1);

        public void renderReference(Canvas var1, double var2, double var4, String var6, Text var7) throws EX;

        public Size sizeOfCharset(Text var1);

        public void renderCharset(Canvas var1, double var2, double var4, Text var6) throws EX;

        public Size sizeOfLine(Collection<Figure> var1);

        public void renderLine(Canvas var1, double var2, double var4, Size var6, List<Figure> var7, boolean var8) throws EX;

        public Size sizeOfBranch(Collection<Figure> var1);

        public void renderBranch(Canvas var1, double var2, double var4, Size var6, Collection<Figure> var7, boolean var8) throws EX;

        public Size sizeOfLoop(Figure var1, Figure var2, Text var3);

        public void renderLoop(Canvas var1, double var2, double var4, Size var6, Figure var7, Figure var8, Text var9, boolean var10) throws EX;
    }

    public static interface BuilderOptions {
        default public boolean expandAnyCase() {
            return false;
        }

        default public boolean skipNone() {
            return false;
        }

        default public boolean inlineNone() {
            return false;
        }

        default public boolean optimizeDiagram() {
            return true;
        }
    }
}

