/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.railroad;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.opencypher.grammar.Alternatives;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Literal;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Optional;
import org.opencypher.grammar.Repetition;
import org.opencypher.grammar.Sequence;
import org.opencypher.grammar.TermTransformation;
import org.opencypher.grammar.Terms;
import org.opencypher.railroad.Diagram;
import org.opencypher.railroad.Size;

class FigureBuilder
implements TermTransformation<Group, Void, RuntimeException> {
    private final boolean expandAnyCase;
    private final boolean skipNone;
    private final boolean inlineNone;
    private final boolean optimizeDiagram;
    private static final Diagram.Figure BULLET = new Diagram.Figure(){

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public Size size(Diagram.Renderer<?, ?, ?> renderer) {
            return this.computeSize(renderer);
        }

        @Override
        <T> Size computeSize(Diagram.Renderer<?, T, ?> renderer) {
            return renderer.sizeOfBullet();
        }

        @Override
        public <O, T, EX extends Exception> void render(O target, double x, double y, Diagram.Renderer<O, T, EX> renderer, boolean forward) throws EX {
            renderer.renderBullet(target, x, y);
        }

        @Override
        void toString(StringBuilder result) {
            result.append("\u25e6");
        }
    };
    private static final Diagram.Figure NOTHING = new Diagram.Figure(){

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public Size size(Diagram.Renderer<?, ?, ?> renderer) {
            return this.computeSize(renderer);
        }

        @Override
        <T> Size computeSize(Diagram.Renderer<?, T, ?> renderer) {
            return renderer.sizeOfNothing();
        }

        @Override
        public <O, T, EX extends Exception> void render(O target, double x, double y, Diagram.Renderer<O, T, EX> renderer, boolean forward) throws EX {
            renderer.renderNothing(target, x, y, forward);
        }

        @Override
        public boolean isNothing() {
            return true;
        }

        @Override
        void toString(StringBuilder result) {
            result.append("nothing()");
        }
    };

    static Diagram.Figure nothing() {
        return NOTHING;
    }

    static Diagram.Figure text(String text) {
        return new Text(text);
    }

    static Diagram.Figure anyCase(String text) {
        return new AnyCase(text);
    }

    static Diagram.Figure reference(String target, String text) {
        return new Reference(target, text);
    }

    static Diagram.Figure charset(String set) {
        return new Charset(set);
    }

    static Diagram.Figure line(Diagram.Figure ... content) {
        Line line = new Line();
        Collections.addAll(line.seq, content);
        return line;
    }

    static Diagram.Figure branch(Diagram.Figure ... branches) {
        Branch branch = new Branch();
        Collections.addAll(branch.alt, branches);
        return branch;
    }

    static Diagram.Figure loop(Diagram.Figure forward, Diagram.Figure backwards, int minTimes, Integer maxTimes) {
        if (minTimes < 0 || maxTimes != null && maxTimes < minTimes) {
            throw new IllegalArgumentException("Invalid bounds, min=" + minTimes + ", max=" + maxTimes);
        }
        return new Loop(forward, backwards, minTimes, maxTimes, false);
    }

    static Diagram.Figure root(Diagram.Figure figure) {
        Line line = new Line();
        line.add(BULLET);
        if (figure instanceof Line) {
            line.seq.addAll(((Line)figure).seq);
        } else {
            line.add(figure);
        }
        line.add(BULLET);
        return line;
    }

    static Diagram.Figure build(Grammar.Term term, Diagram.BuilderOptions options) {
        Line line = new Line();
        line.add(BULLET);
        term.transform(new FigureBuilder(options), line);
        line.add(BULLET);
        return line;
    }

    private FigureBuilder(Diagram.BuilderOptions options) {
        this.expandAnyCase = options.expandAnyCase();
        this.skipNone = options.skipNone();
        this.inlineNone = options.inlineNone();
        this.optimizeDiagram = options.optimizeDiagram();
    }

    @Override
    public Void transformAlternatives(Group group, Alternatives alternatives) {
        group.branch(this, alternatives);
        return null;
    }

    @Override
    public Void transformSequence(Group group, Sequence sequence) {
        group.line(this, sequence);
        return null;
    }

    @Override
    public Void transformLiteral(Group group, Literal literal) {
        if (literal.caseSensitive()) {
            FigureBuilder.literal(group, literal.toString(), FigureBuilder::text);
        } else if (this.expandAnyCase) {
            final Line line = group instanceof Line ? (Line)group : new Line();
            literal.accept(new Literal.Visitor<RuntimeException>(){

                @Override
                public void visitLiteral(String literal) {
                    line.add(FigureBuilder.text(literal));
                }

                @Override
                public void visitAnyCase(int cp) {
                    Branch branch = new Branch();
                    StringBuilder chr = new StringBuilder(2);
                    chr.appendCodePoint(Character.toUpperCase(cp));
                    branch.add(FigureBuilder.text(chr.toString()));
                    chr.setLength(0);
                    chr.appendCodePoint(Character.toLowerCase(cp));
                    branch.add(FigureBuilder.text(chr.toString()));
                    line.add(branch);
                }
            });
            if (group != line && !line.seq.isEmpty()) {
                group.add(FigureBuilder.lineFigures(line));
            }
        } else {
            FigureBuilder.literal(group, literal.toString(), FigureBuilder::anyCase);
        }
        return null;
    }

    private static void literal(Group group, String text, Function<String, Diagram.Figure> figure) {
        int cp;
        int start = 0;
        Line line = null;
        for (int i = 0; i < text.length(); i += Character.charCount(cp)) {
            cp = text.codePointAt(i);
            if (Character.isLetterOrDigit(cp) || cp >= 32 && cp < 255) continue;
            if (line == null) {
                Line line2 = line = group instanceof Line ? (Line)group : new Line();
            }
            if (i > start) {
                line.add(figure.apply(text.substring(start, i)));
            }
            line.add(FigureBuilder.charset('[' + CharacterSet.escapeCodePoint(cp) + ']'));
            start = i + Character.charCount(cp);
        }
        if (line == null) {
            group.add(figure.apply(text));
        } else if (group != line) {
            group.add(FigureBuilder.lineFigures(line));
        }
    }

    @Override
    public Void transformNonTerminal(Group group, NonTerminal nonTerminal) {
        if (this.skipNone || !nonTerminal.skip()) {
            if (!this.inlineNone && nonTerminal.inline()) {
                nonTerminal.productionDefinition().transform(this, group);
            } else {
                group.add(FigureBuilder.reference(nonTerminal.productionName(), nonTerminal.title()));
            }
        }
        return null;
    }

    @Override
    public Void transformOptional(Group group, Optional optional) {
        Branch branch = new Branch();
        branch.add(NOTHING);
        optional.term().transform(this, branch);
        if (!branch.containsNothing()) {
            group.add(branch);
        }
        return null;
    }

    @Override
    public Void transformRepetition(Group group, Repetition repetition) {
        Line repeated = new Line();
        repetition.term().transform(this, repeated);
        group.repetition(this, repeated, repetition.minTimes(), repetition.limited() ? Integer.valueOf(repetition.maxTimes()) : null);
        return null;
    }

    @Override
    public Void transformEpsilon(Group group) {
        group.add(NOTHING);
        return null;
    }

    @Override
    public Void transformCharacters(Group group, CharacterSet characters) {
        group.add(new Charset(CharacterSet.Unicode.toSetString(characters)));
        return null;
    }

    private void addAll(Terms terms, Group group) {
        terms.forEach((Consumer<? super Grammar.Term>)((Consumer<Grammar.Term>)term -> term.transform(this, group)));
    }

    private Diagram.Figure combineAlternatives(Branch branch) {
        if (!this.optimizeDiagram) {
            return branch;
        }
        List<Line> lines = FigureBuilder.lines(branch.alt);
        Line one = lines.remove(lines.size() - 1);
        int prefix = 0;
        int suffix = 0;
        int oneSize = one.seq.size();
        boolean pre = true;
        boolean post = true;
        while (pre || post) {
            for (Line line : lines) {
                int lineSize = line.seq.size();
                if (pre && lineSize > prefix && oneSize > prefix && !line.seq.get(prefix).equals(one.seq.get(prefix))) {
                    pre = false;
                }
                if (post && (lineSize <= suffix || oneSize <= suffix || !line.seq.get(lineSize - suffix - 1).equals(one.seq.get(oneSize - suffix - 1)))) {
                    post = false;
                }
                if (prefix + suffix < Math.min(oneSize, lineSize)) continue;
                if (prefix + suffix > Math.min(oneSize, lineSize)) {
                    --suffix;
                }
                post = false;
                pre = false;
            }
            if (pre) {
                ++prefix;
            }
            if (!post) continue;
            ++suffix;
        }
        if (prefix > 0 || suffix > 0) {
            int i;
            Line common = new Line();
            ArrayList<Diagram.Figure> after = new ArrayList<Diagram.Figure>();
            for (i = 0; i < prefix; ++i) {
                common.add(one.seq.get(i));
            }
            for (i = suffix; i > 0; --i) {
                after.add(one.seq.get(one.seq.size() - i));
            }
            branch = new Branch();
            lines.add(one);
            for (Line line : lines) {
                int i2;
                for (i2 = 0; i2 < suffix; ++i2) {
                    line.seq.remove(line.seq.size() - 1);
                }
                for (i2 = 0; i2 < prefix; ++i2) {
                    line.seq.remove(0);
                }
                branch.add(FigureBuilder.lineFigures(line));
            }
            common.add(branch);
            for (Diagram.Figure figure : after) {
                common.add(figure);
            }
            return common;
        }
        return branch;
    }

    private static List<Line> lines(Collection<Diagram.Figure> figures) {
        ArrayList<Line> lines = new ArrayList<Line>(figures.size());
        for (Diagram.Figure figure : figures) {
            if (figure instanceof Line) {
                lines.add((Line)figure);
                continue;
            }
            Line line = new Line();
            line.add(figure);
            lines.add(line);
        }
        return lines;
    }

    private static Diagram.Figure lineFigures(Line line) {
        switch (line.seq.size()) {
            case 0: {
                return NOTHING;
            }
            case 1: {
                return line.seq.get(0);
            }
        }
        return line;
    }

    private Diagram.Figure loop(Diagram.Figure forwards, Diagram.Figure backwards, int min, Integer max, boolean top) {
        if (this.optimizeDiagram && forwards instanceof Loop) {
            Loop loop = (Loop)forwards;
            forwards = loop.forward;
            Branch branch = new Branch();
            branch.add(loop.backward);
            branch.add(backwards);
            backwards = branch;
        }
        if (forwards == NOTHING && backwards instanceof Branch) {
            Branch branch = new Branch();
            branch.add(NOTHING);
            branch.add(new Loop(backwards, forwards, min, max, top));
            return branch;
        }
        if (min == 1 && max == null) {
            Line line = new Line();
            line.add(forwards);
            line.add(new Loop(backwards, forwards, 0, null, top));
            return line;
        }
        return new Loop(forwards, backwards, min, max, top);
    }

    private static void string(StringBuilder result, String type, Collection<Diagram.Figure> children) {
        result.append(type).append('(');
        String sep = " ";
        for (Diagram.Figure item : children) {
            result.append(sep);
            item.toString(result);
            sep = ", ";
        }
        if (!children.isEmpty()) {
            result.append(' ');
        }
        result.append(')');
    }

    static final class Conditional<STATE> {
        private static final Conditional NONE = new Conditional<Object>(null, null);
        private final STATE state;
        private final Diagram.Renderer renderer;

        static <STATE> Conditional<STATE> none() {
            return NONE;
        }

        private Conditional(STATE state, Diagram.Renderer renderer) {
            this.state = state;
            this.renderer = renderer;
        }

        <OWNER> Conditional<STATE> compute(OWNER owner, Diagram.Renderer<?, ?, ?> renderer, BiFunction<OWNER, Diagram.Renderer<?, ?, ?>, STATE> compute) {
            if (this.renderer == renderer) {
                return this;
            }
            return new Conditional<STATE>(compute.apply(owner, renderer), renderer);
        }

        <X extends STATE> X get() {
            return (X)this.state;
        }

        static interface Computation<OWNER, STATE> {
            public <EX extends Exception> STATE compute(OWNER var1, Diagram.Renderer<?, ?, EX> var2);
        }
    }

    private static class Loop
    extends Diagram.Figure {
        private final Diagram.Figure forward;
        private final Diagram.Figure backward;
        private final boolean top;
        private final int min;
        private final Integer max;
        private Conditional<Object> text = Conditional.none();

        Loop(Diagram.Figure forward, Diagram.Figure backward, int min, Integer max, boolean top) {
            this.forward = forward;
            this.backward = backward;
            this.top = top;
            this.min = min;
            this.max = max;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Loop loop = (Loop)o;
            return this.top == loop.top && this.min == loop.min && Objects.equals(this.forward, loop.forward) && Objects.equals(this.backward, loop.backward) && Objects.equals(this.max, loop.max);
        }

        public int hashCode() {
            return Objects.hash(this.forward, this.backward, this.top, this.min, this.max);
        }

        @Override
        void toString(StringBuilder result) {
            result.append("loop( ");
            this.forward.toString(result);
            result.append(", ");
            this.backward.toString(result);
            result.append(", min=").append(this.min);
            result.append(", max=").append(this.max);
            result.append(" )");
        }

        @Override
        <T> Size computeSize(Diagram.Renderer<?, T, ?> renderer) {
            return renderer.sizeOfLoop(this.forward, this.backward, this.text(renderer));
        }

        final <T> T text(Diagram.Renderer<?, T, ?> renderer) {
            this.text = this.text.compute(this, renderer, Loop::renderText);
            return (T)this.text.get();
        }

        <T> T renderText(Diagram.Renderer<?, T, ?> renderer) {
            if (this.min > 0 || this.max != null) {
                StringBuilder text = new StringBuilder();
                text.append(this.min);
                if (this.max == null) {
                    text.append("..N");
                } else if (this.min != this.max) {
                    text.append("..").append(this.max);
                }
                return renderer.renderText(this.getClass().getSimpleName().toLowerCase(), text.toString());
            }
            return null;
        }

        @Override
        public <O, T, EX extends Exception> void render(O target, double x, double y, Diagram.Renderer<O, T, EX> renderer, boolean forward) throws EX {
            renderer.renderLoop(target, x, y, this.size(renderer), this.forward, this.backward, this.text(renderer), forward);
        }
    }

    private static class Branch
    extends Group {
        final Set<Diagram.Figure> alt = Collections.newSetFromMap(new LinkedHashMap());

        private Branch() {
        }

        @Override
        void add(Diagram.Figure child) {
            if (child instanceof Branch) {
                Branch branch = (Branch)child;
                this.alt.addAll(branch.alt);
            } else {
                this.alt.add(child);
            }
        }

        @Override
        void branch(FigureBuilder builder, Alternatives alternatives) {
            builder.addAll(alternatives, this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Branch branch = (Branch)o;
            return this.alt.equals(branch.alt);
        }

        public int hashCode() {
            return this.alt.hashCode();
        }

        @Override
        public void toString(StringBuilder result) {
            FigureBuilder.string(result, "branch", this.alt);
        }

        @Override
        <T> Size computeSize(Diagram.Renderer<?, T, ?> renderer) {
            return renderer.sizeOfBranch(Collections.unmodifiableCollection(this.alt));
        }

        @Override
        public <O, T, EX extends Exception> void render(O target, double x, double y, Diagram.Renderer<O, T, EX> renderer, boolean forward) throws EX {
            renderer.renderBranch(target, x, y, this.size(renderer), Collections.unmodifiableCollection(this.alt), forward);
        }

        boolean containsNothing() {
            if (this.alt.isEmpty()) {
                return true;
            }
            for (Diagram.Figure f : this.alt) {
                if (f.isNothing()) continue;
                return false;
            }
            return true;
        }
    }

    private static class Line
    extends Group {
        final List<Diagram.Figure> seq = new ArrayList<Diagram.Figure>();

        private Line() {
        }

        @Override
        void add(Diagram.Figure child) {
            if (child instanceof Line) {
                Line line = (Line)child;
                this.seq.addAll(line.seq);
            } else if (child != NOTHING) {
                this.seq.add(child);
            }
        }

        @Override
        void line(FigureBuilder builder, Sequence sequence) {
            builder.addAll(sequence, this);
        }

        @Override
        void repetition(FigureBuilder builder, Line repeated, int minTimes, Integer maxTimes) {
            Diagram.Figure forward;
            LinkedList<Diagram.Figure> common = new LinkedList<Diagram.Figure>();
            int these = this.seq.size();
            int those = repeated.seq.size();
            while (these-- > 0 && those-- > 0) {
                Diagram.Figure your;
                Diagram.Figure mine = this.seq.get(these);
                if (!mine.equals(your = repeated.seq.get(those))) continue;
                common.addFirst(mine);
                this.seq.remove(these);
                repeated.seq.remove(those);
            }
            if (common.isEmpty()) {
                super.repetition(builder, repeated, minTimes, maxTimes);
                return;
            }
            if (common.size() == 1) {
                forward = (Diagram.Figure)common.getFirst();
            } else {
                forward = new Line();
                ((Line)forward).seq.addAll(common);
            }
            Diagram.Figure backward = FigureBuilder.lineFigures(repeated);
            this.add(builder.loop(forward, backward, minTimes, maxTimes, false));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Line line = (Line)o;
            return this.seq.equals(line.seq);
        }

        public int hashCode() {
            return this.seq.hashCode();
        }

        @Override
        public void toString(StringBuilder result) {
            FigureBuilder.string(result, "line", this.seq);
        }

        @Override
        <T> Size computeSize(Diagram.Renderer<?, T, ?> renderer) {
            return renderer.sizeOfLine(Collections.unmodifiableList(this.seq));
        }

        @Override
        public <O, T, EX extends Exception> void render(O target, double x, double y, Diagram.Renderer<O, T, EX> renderer, boolean forward) throws EX {
            renderer.renderLine(target, x, y, this.size(renderer), Collections.unmodifiableList(this.seq), forward);
        }
    }

    private static class Charset
    extends Node {
        Charset(String set) {
            super(set);
        }

        @Override
        <T> Size computeSize(Diagram.Renderer<?, T, ?> renderer, T text) {
            return renderer.sizeOfCharset(text);
        }

        @Override
        <O, T, EX extends Exception> void render(O target, double x, double y, Diagram.Renderer<O, T, EX> renderer, T text) throws EX {
            renderer.renderCharset(target, x, y, text);
        }
    }

    private static class Reference
    extends Node {
        private final String target;

        Reference(String target, String title) {
            super(title);
            this.target = target;
        }

        @Override
        <T> Size computeSize(Diagram.Renderer<?, T, ?> renderer, T name) {
            return renderer.sizeOfReference(name);
        }

        @Override
        <O, T, EX extends Exception> void render(O target, double x, double y, Diagram.Renderer<O, T, EX> renderer, T text) throws EX {
            renderer.renderReference(target, x, y, this.target, text);
        }
    }

    private static class AnyCase
    extends Node {
        AnyCase(String text) {
            super(text);
        }

        @Override
        <T> Size computeSize(Diagram.Renderer<?, T, ?> renderer, T text) {
            return renderer.sizeOfAnyCase(text);
        }

        @Override
        <O, T, EX extends Exception> void render(O target, double x, double y, Diagram.Renderer<O, T, EX> renderer, T text) throws EX {
            renderer.renderAnyCase(target, x, y, text);
        }

        @Override
        public int hashCode() {
            return this.def.toUpperCase().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AnyCase that = (AnyCase)obj;
            return this.def.equalsIgnoreCase(that.def);
        }
    }

    private static class Text
    extends Node {
        Text(String text) {
            super(text);
        }

        @Override
        <T> Size computeSize(Diagram.Renderer<?, T, ?> renderer, T text) {
            return renderer.sizeOfText(text);
        }

        @Override
        <O, T, EX extends Exception> void render(O target, double x, double y, Diagram.Renderer<O, T, EX> renderer, T text) throws EX {
            renderer.renderText(target, x, y, text);
        }
    }

    static abstract class Group
    extends Diagram.Figure {
        Group() {
        }

        void branch(FigureBuilder builder, Alternatives alternatives) {
            Branch branch = new Branch();
            builder.addAll(alternatives, branch);
            if (!branch.alt.isEmpty()) {
                if (branch.alt.size() == 1) {
                    Diagram.Figure alt = branch.alt.iterator().next();
                    this.add(alt);
                } else {
                    this.add(builder.combineAlternatives(branch));
                }
            }
        }

        void line(FigureBuilder builder, Sequence sequence) {
            Line line = new Line();
            builder.addAll(sequence, line);
            if (!line.seq.isEmpty()) {
                this.add(FigureBuilder.lineFigures(line));
            }
        }

        void repetition(FigureBuilder builder, Line repeated, int minTimes, Integer maxTimes) {
            Diagram.Figure backwards;
            Diagram.Figure forwards;
            if (minTimes == 0) {
                forwards = NOTHING;
                backwards = FigureBuilder.lineFigures(repeated);
            } else {
                forwards = FigureBuilder.lineFigures(repeated);
                backwards = NOTHING;
                --minTimes;
                if (maxTimes != null) {
                    maxTimes = maxTimes - 1;
                }
            }
            this.add(builder.loop(forwards, backwards, minTimes, maxTimes, false));
        }

        abstract void add(Diagram.Figure var1);
    }

    static abstract class Node
    extends Diagram.Figure {
        final String def;
        private Conditional<Object> text = Conditional.none();

        Node(String def) {
            this.def = def;
        }

        final <T> T text(Diagram.Renderer<?, T, ?> renderer) {
            this.text = this.text.compute(this, renderer, Node::renderText);
            return (T)this.text.get();
        }

        @Override
        <T> Size computeSize(Diagram.Renderer<?, T, ?> renderer) {
            return this.computeSize(renderer, this.text(renderer));
        }

        @Override
        public <O, T, EX extends Exception> void render(O target, double x, double y, Diagram.Renderer<O, T, EX> renderer, boolean forward) throws EX {
            this.render(target, x, y, renderer, this.text(renderer));
        }

        abstract <T> Size computeSize(Diagram.Renderer<?, T, ?> var1, T var2);

        abstract <O, T, EX extends Exception> void render(O var1, double var2, double var4, Diagram.Renderer<O, T, EX> var6, T var7) throws EX;

        <T> T renderText(Diagram.Renderer<?, T, ?> renderer) {
            return renderer.renderText(this.getClass().getSimpleName().toLowerCase(), this.def);
        }

        public int hashCode() {
            return this.def.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Node that = (Node)obj;
            return this.def.equals(that.def);
        }

        @Override
        void toString(StringBuilder result) {
            result.append(this.getClass().getSimpleName().toLowerCase()).append("('").append(this.def).append("')");
        }
    }
}

