/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.util.HashSet;
import java.util.Set;
import org.opencypher.grammar.Alternatives;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Literal;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Optional;
import org.opencypher.grammar.Production;
import org.opencypher.grammar.ProductionVisitor;
import org.opencypher.grammar.Repetition;
import org.opencypher.grammar.Sequence;
import org.opencypher.grammar.TermVisitor;
import org.opencypher.tools.Functions;
import org.opencypher.tools.io.Output;

abstract class BnfWriter
implements ProductionVisitor<RuntimeException>,
TermVisitor<RuntimeException>,
AutoCloseable {
    private int altPrefix;
    private boolean group;
    protected final Output output;
    private final Set<Integer> caseChars = new HashSet<Integer>();

    BnfWriter(Output output) {
        this.output = Functions.requireNonNull(Output.class, output);
    }

    protected abstract void productionCommentPrefix();

    protected abstract void productionCommentLinePrefix();

    protected abstract void productionCommentSuffix();

    protected abstract void productionStart(Production var1);

    protected abstract void productionEnd();

    protected abstract void alternativesLinePrefix(int var1);

    protected abstract void alternativesSeparator();

    protected abstract void sequenceSeparator();

    protected abstract void groupPrefix();

    protected abstract void groupSuffix();

    protected abstract boolean optionalPrefix();

    protected abstract void optionalSuffix();

    protected abstract void repeat(int var1, Integer var2, Runnable var3);

    protected abstract void characterSet(CharacterSet var1);

    protected abstract void nonTerminal(NonTerminal var1);

    protected abstract void literal(String var1);

    protected abstract void caseInsensitive(String var1);

    protected abstract void caseInsensitiveProductionStart(String var1);

    protected abstract void epsilon();

    @Override
    public final void visitProduction(Production production) throws RuntimeException {
        String description = production.description();
        if (description != null) {
            this.productionCommentPrefix();
            int pos = 0;
            while (pos < description.length()) {
                int line = description.indexOf(10, pos);
                line = line == -1 ? description.length() : ++line;
                if (pos > 0) {
                    this.productionCommentLinePrefix();
                }
                this.output.append(description, pos, line);
                pos = line;
            }
            this.productionCommentSuffix();
        }
        this.altPrefix = production.name().length();
        this.group = false;
        this.productionStart(production);
        production.definition().accept(this);
        this.productionEnd();
        this.altPrefix = 0;
    }

    @Override
    public final void visitAlternatives(Alternatives alternatives) {
        this.group(() -> {
            boolean prefix = false;
            for (Grammar.Term term : alternatives) {
                if (prefix) {
                    if (this.altPrefix > 0) {
                        this.alternativesLinePrefix(this.altPrefix);
                    }
                    this.alternativesSeparator();
                }
                term.accept(this);
                prefix = true;
            }
            if (alternatives.terms() > 1 && this.altPrefix > 0) {
                this.alternativesLinePrefix(this.altPrefix);
            }
        });
    }

    @Override
    public final void visitSequence(Sequence sequence) {
        int altPrefix = this.altPrefix;
        this.altPrefix = 0;
        this.group(() -> {
            boolean sep = false;
            for (Grammar.Term term : sequence) {
                if (sep) {
                    this.sequenceSeparator();
                }
                term.accept(this);
                sep = true;
            }
        });
        this.altPrefix = altPrefix;
    }

    @Override
    public final void visitLiteral(Literal literal) {
        if (literal.caseSensitive() || Character.charCount(literal.codePointAt(0)) == literal.length() && !Character.isLetter(literal.codePointAt(0)) || !this.hasCaseAlternatives(literal.toString())) {
            this.literal(literal.toString());
        } else if (literal.length() == 0) {
            this.visitEpsilon();
        } else {
            this.caseInsensitive(literal.toString());
        }
    }

    private boolean hasCaseAlternatives(String string) {
        for (int i = 0; i < string.length(); ++i) {
            int lower;
            int upper = Character.toUpperCase(string.codePointAt(i));
            if (upper == (lower = Character.toLowerCase(string.codePointAt(i)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void visitCharacters(CharacterSet characters) {
        this.characterSet(characters);
    }

    @Override
    public final void visitNonTerminal(NonTerminal nonTerminal) {
        this.nonTerminal(nonTerminal);
    }

    @Override
    public final void visitOptional(Optional optional) {
        int altPrefix = this.altPrefix;
        this.altPrefix = 0;
        boolean group = this.group;
        this.group = !this.optionalPrefix();
        optional.term().accept(this);
        this.group = group;
        this.optionalSuffix();
        this.altPrefix = altPrefix;
    }

    @Override
    public final void visitRepetition(Repetition repetition) {
        int altPrefix = this.altPrefix;
        this.altPrefix = 0;
        try {
            this.repeat(repetition.minTimes(), this.maxTimes(repetition), () -> repetition.term().accept(this));
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException(repetition.toString(), e);
        }
        this.altPrefix = altPrefix;
    }

    private Integer maxTimes(Repetition repetition) {
        return repetition.limited() ? Integer.valueOf(repetition.maxTimes()) : null;
    }

    @Override
    public final void visitEpsilon() throws RuntimeException {
        this.epsilon();
    }

    @Override
    public void close() {
        for (int chr : this.caseChars) {
            int upper = Character.toUpperCase(chr);
            int lower = Character.toLowerCase(chr);
            int title = Character.toTitleCase(chr);
            this.caseInsensitiveProductionStart(String.valueOf((char)upper));
            this.literal(String.valueOf((char)upper));
            this.alternativesSeparator();
            this.literal(String.valueOf((char)lower));
            if (title != upper) {
                this.alternativesSeparator();
                this.literal(String.valueOf((char)title));
            }
            this.productionEnd();
        }
    }

    final void group(Runnable action) {
        boolean group = this.group;
        this.group = true;
        if (group) {
            this.groupPrefix();
        }
        action.run();
        if (group) {
            this.groupSuffix();
        }
        this.group = group;
    }

    final void groupWith(char prefix, Runnable action, char suffix) {
        boolean group = this.group;
        this.group = false;
        this.output.append(prefix).append(" ");
        action.run();
        this.output.append(" ").append(suffix);
        this.group = group;
    }

    final void groupWithoutPrefix(Runnable action) {
        boolean group = this.group;
        this.group = true;
        action.run();
        this.group = group;
    }

    final void addCaseChar(int codePoint) {
        this.caseChars.add(codePoint);
    }
}

