/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Production;
import org.opencypher.railroad.Diagram;
import org.opencypher.railroad.SVGShapes;
import org.opencypher.railroad.ShapeRenderer;
import org.opencypher.tools.Option;
import org.opencypher.tools.grammar.RailRoadDiagrams;
import org.opencypher.tools.grammar.Tool;
import org.opencypher.tools.io.HtmlTag;
import org.opencypher.tools.io.Output;

public final class RailRoadDiagramPages
extends Tool
implements ShapeRenderer.Linker {
    public static void main(String ... args) throws Exception {
        RailRoadDiagramPages.main(RailRoadDiagramPages::new, RailRoadDiagramPages::generate, args);
    }

    private RailRoadDiagramPages(Map<?, ?> properties) {
        super(properties);
    }

    private void generate(Grammar grammar, Output output) throws IOException, XMLStreamException {
        Path outputDir = this.outputDir();
        ShapeRenderer renderer = RailRoadDiagrams.renderer(this);
        Diagram.CanvasProvider<SVGShapes, XMLStreamException> canvas = RailRoadDiagrams.canvas(output, outputDir);
        int diagrams = 0;
        for (Diagram diagram : Diagram.build(grammar, this.options(Diagram.BuilderOptions.class, new Option[0]))) {
            grammar.transform(diagram.name(), (param, production) -> {
                this.writeHtml((Path)param, production);
                return null;
            }, outputDir);
            diagram.render(renderer, canvas);
            ++diagrams;
        }
        output.append("Rendered ").append(diagrams).println(" diagrams.");
    }

    @Override
    public String referenceLink(String reference) {
        return reference + ".html";
    }

    @Override
    public String charsetLink(String charset) {
        return RailRoadDiagrams.unicodesetLink(charset);
    }

    private void writeHtml(Path dir, Production production) {
        block48: {
            String svg = production.name() + ".svg";
            try (HtmlTag.Html html = HtmlTag.html(dir.resolve(production.name() + ".html"));){
                html.head(title -> production.name());
                try (HtmlTag body = html.body();){
                    Collection<Production> references;
                    body.tag("h1", new HtmlTag.Attribute[0]).text(production.name()).close();
                    body.tag("object", data -> svg, type -> "image/svg+xml").close();
                    String description = production.description();
                    if (description != null) {
                        body.p();
                        body.text(description);
                    }
                    if ((references = production.referencedFrom()).isEmpty()) break block48;
                    body.tag("h2", new HtmlTag.Attribute[0]).text("Referenced from").close();
                    try (HtmlTag ul = body.tag("ul", new HtmlTag.Attribute[0]);){
                        for (Production reference : references) {
                            HtmlTag li = ul.tag("li", new HtmlTag.Attribute[0]);
                            Throwable throwable = null;
                            try {
                                String name = reference.name();
                                li.tag("a", href -> this.referenceLink(name)).text(name).close();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (li == null) continue;
                                if (throwable != null) {
                                    try {
                                        li.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                li.close();
                            }
                        }
                    }
                }
            }
        }
    }
}

