/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.antlr.v4.Tool;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerInterpreter;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.junit.Test;
import org.opencypher.tools.grammar.Antlr4TestUtils;

public class Antlr4ParserTest {
    @Test
    public void shouldParseValidCypher() throws FileNotFoundException, URISyntaxException {
        this.getQueries("/cypher.txt").forEach(Antlr4TestUtils::parse);
    }

    @Test
    public void shouldParseLegacyCypher() throws FileNotFoundException, URISyntaxException {
        this.getQueries("/cypher-legacy.txt").forEach(Antlr4TestUtils::parseLegacy);
    }

    public void investigateTokenStream() throws IOException {
        String query = "CREATE (a)";
        Tool tool = new Tool();
        GrammarRootAST ast = tool.parseGrammarFromString(new String(Files.readAllBytes(Paths.get("/Users/mats/gitRoots/openCypher/grammar/generated/Cypher.g4", new String[0]))));
        Grammar g = tool.createGrammar(ast);
        tool.process(g, false);
        LexerInterpreter lexer = g.createLexerInterpreter((CharStream)new ANTLRInputStream(query));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
    }

    private List<String> getQueries(String queryFile) throws FileNotFoundException, URISyntaxException {
        URL resource = this.getClass().getResource(queryFile);
        Scanner scanner = new Scanner(new FileReader(Paths.get(resource.toURI()).toFile()));
        scanner.useDelimiter("\u00a7\n");
        ArrayList<String> queries = new ArrayList<String>();
        while (scanner.hasNext()) {
            queries.add(scanner.next());
        }
        return queries;
    }
}

