/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.opencypher.grammar.CharacterSet;

abstract class CodePointSet
implements Comparable<CodePointSet> {
    private static final CodePointSet[] EMPTY = new CodePointSet[0];
    static final CodePointSet ANY = new CodePointSet(){

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public String toString() {
            return "ANY";
        }

        @Override
        boolean contains(int cp) {
            return Character.isValidCodePoint(cp);
        }

        @Override
        int firstCodePoint() {
            return 0;
        }
    };
    String name;
    private volatile transient int[] encoded;

    CodePointSet() {
    }

    public static CodePointSet single(int codePoint) {
        return new SingleCodePoint(codePoint);
    }

    public static CodePointSet codePoints(int ... codePoints) {
        if (codePoints == null || codePoints.length == 0) {
            throw new IllegalArgumentException("No code points!");
        }
        if (codePoints.length == 1) {
            return CodePointSet.single(codePoints[0]);
        }
        Arrays.sort(codePoints);
        return new CodePointList(codePoints);
    }

    public static CodePointSet union(CodePointSet ... union) {
        if (union == null || union.length == 0) {
            throw new IllegalArgumentException("Union of nothing!");
        }
        if (union.length == 1) {
            return union[0];
        }
        for (CodePointSet set : union) {
            if (!(set instanceof Union)) continue;
            return Union.flatten(union);
        }
        Arrays.sort(union);
        return new Union(union);
    }

    public static Range range(int start, int end) {
        if (start >= end) {
            throw new IllegalArgumentException(new StringBuilder().append("Invalid range: [").appendCodePoint(start).append("-").appendCodePoint(end).append("]").toString());
        }
        return new Range(start, end);
    }

    public static CodePointSet generalCategory(byte characterType) {
        return new GeneralCategory(characterType);
    }

    public static CodePointSet parse(String set) {
        int cp;
        if (set.charAt(0) != '[' || set.charAt(set.length() - 1) != ']') {
            throw new IllegalArgumentException("Invalid set notation, must be enclosed in '[...]': " + set);
        }
        class Parser {
            int last = -1;
            boolean escape = false;
            boolean range = false;
            List<Integer> single = new ArrayList<Integer>();
            List<Range> ranges = new ArrayList<Range>();
            final /* synthetic */ String val$set;

            Parser(String string) {
                this.val$set = string;
            }

            CodePointSet complete() {
                if (this.range || this.escape) {
                    throw new IllegalArgumentException("Invalid set notation, cannot end in '-' or '\\': " + this.val$set);
                }
                if (this.last != -1) {
                    this.single.add(this.last);
                }
                if (this.single.isEmpty()) {
                    return CodePointSet.union(this.ranges.toArray(EMPTY));
                }
                CodePointSet[] result = this.ranges.toArray(new CodePointSet[this.ranges.size() + 1]);
                if (this.single.size() == 1) {
                    result[result.length - 1] = CodePointSet.single(this.single.get(0));
                } else {
                    int[] codePoints = new int[this.single.size()];
                    for (int i = 0; i < codePoints.length; ++i) {
                        codePoints[i] = this.single.get(i);
                    }
                    result[result.length - 1] = CodePointSet.codePoints(codePoints);
                }
                return CodePointSet.union(result);
            }

            void next(int cp) {
                if (this.range) {
                    this.ranges.add(CodePointSet.range(this.last, cp));
                    this.last = -1;
                } else {
                    if (this.last != -1) {
                        this.single.add(this.last);
                    }
                    this.last = cp;
                }
                this.escape = false;
                this.range = false;
            }
        }
        Parser parser = new Parser(set);
        int end = set.length() - 1;
        block5: for (int i = 1; i < end; i += Character.charCount(cp)) {
            cp = set.codePointAt(i);
            switch (cp) {
                case 92: {
                    if (parser.escape) {
                        parser.next(cp);
                        continue block5;
                    }
                    parser.escape = true;
                    continue block5;
                }
                case 45: {
                    if (parser.escape) {
                        parser.next(cp);
                        continue block5;
                    }
                    if (parser.range) {
                        throw new IllegalArgumentException("Invalid set notation, '-' may not follow '-': " + set);
                    }
                    if (parser.last == -1) {
                        throw new IllegalArgumentException("Invalid set notation, '-' must be preceded by single char: " + set);
                    }
                    parser.range = true;
                    continue block5;
                }
                case 97: 
                case 98: 
                case 101: 
                case 102: 
                case 110: 
                case 114: 
                case 116: 
                case 118: {
                    if (parser.escape) {
                        parser.next(CodePointSet.escape(cp));
                        continue block5;
                    }
                }
                default: {
                    if (parser.escape) {
                        throw new IllegalArgumentException(new StringBuilder().append("Invalid escape character: ").appendCodePoint(cp).toString());
                    }
                    parser.next(cp);
                }
            }
        }
        return parser.complete();
    }

    private static int escape(int cp) {
        switch (cp) {
            case 97: {
                return 7;
            }
            case 98: {
                return 8;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 118: {
                return 11;
            }
        }
        throw new IllegalArgumentException(new StringBuilder(2).appendCodePoint(cp).toString());
    }

    public CodePointSet except(CodePointSet excepted) {
        return new Disjunction(this, excepted);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    abstract boolean contains(int var1);

    @Override
    public int compareTo(CodePointSet that) {
        return this.firstCodePoint() - that.firstCodePoint();
    }

    abstract int firstCodePoint();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <EX extends Exception> void accept(CharacterSet.DefinitionVisitor<EX> visitor) throws EX {
        if (this.name != null && visitor instanceof CharacterSet.DefinitionVisitor.NamedSetVisitor) {
            ((CharacterSet.DefinitionVisitor.NamedSetVisitor)visitor).visitSet(this.name).close();
            return;
        }
        int[] encoded = this.encoded;
        if (encoded == null) {
            CodePointSet codePointSet = this;
            synchronized (codePointSet) {
                encoded = this.encoded;
                if (this.encoded == null) {
                    this.encoded = encoded = this.encode();
                }
            }
        }
        this.decode(encoded, visitor);
    }

    private <EX extends Exception> void visit(CharacterSet.DefinitionVisitor<EX> visitor) throws EX {
        int cp;
        boolean include = false;
        int first = -1;
        for (cp = 0; cp <= 0x10FFFF; ++cp) {
            if (this.contains(cp)) {
                if (!include) {
                    first = cp;
                }
                include = true;
                continue;
            }
            if (!include) continue;
            CodePointSet.visit(visitor, first, cp);
            include = false;
        }
        if (include) {
            CodePointSet.visit(visitor, first, cp);
        }
    }

    private <EX extends Exception> void decode(int[] encoded, CharacterSet.DefinitionVisitor<EX> visitor) throws EX {
        int rangeBound = encoded[0] * 2;
        int single = rangeBound + 1;
        for (int range = 1; range < rangeBound; range += 2) {
            int start = encoded[range];
            int end = encoded[range + 1];
            while (single < encoded.length && encoded[single] < start) {
                visitor.visitCodePoint(encoded[single++]);
            }
            visitor.visitRange(start, end);
        }
        while (single < encoded.length) {
            visitor.visitCodePoint(encoded[single++]);
        }
    }

    private int[] encode() {
        final ArrayList<Integer> single = new ArrayList<Integer>();
        final ArrayList<Range> ranges = new ArrayList<Range>();
        this.visit(new CharacterSet.DefinitionVisitor<RuntimeException>(){

            @Override
            public void visitCodePoint(int cp) {
                single.add(cp);
            }

            @Override
            public void visitRange(int start, int end) {
                ranges.add(CodePointSet.range(start, end));
            }
        });
        return this.encode(ranges, single);
    }

    private int[] encode(List<Range> ranges, List<Integer> single) {
        int[] encoded = new int[1 + ranges.size() * 2 + single.size()];
        int i = 0;
        encoded[0] = ranges.size();
        for (Range range : ranges) {
            encoded[++i] = range.start;
            encoded[++i] = range.end;
        }
        Iterator<Comparable<CodePointSet>> iterator = single.iterator();
        while (iterator.hasNext()) {
            int codePoint = (Integer)iterator.next();
            encoded[++i] = codePoint;
        }
        return encoded;
    }

    private static <EX extends Exception> void visit(CharacterSet.DefinitionVisitor<EX> visitor, int first, int next) throws EX {
        if (next == first + 1) {
            visitor.visitCodePoint(first);
        } else {
            visitor.visitRange(first, next - 1);
        }
    }

    public int randomCodePoint(Random random) {
        int cp;
        while (!this.contains(cp = random.nextInt(0x10FFFF))) {
        }
        return cp;
    }

    private static final class GeneralCategory
    extends CodePointSet {
        private final byte characterType;

        GeneralCategory(byte characterType) {
            this.characterType = characterType;
        }

        @Override
        boolean contains(int cp) {
            return Character.getType(cp) == this.characterType;
        }

        @Override
        int firstCodePoint() {
            for (int cp = 0; cp < 0x10FFFF; ++cp) {
                if (!this.contains(cp)) continue;
                return cp;
            }
            throw new IllegalStateException("should contain at least one code point");
        }

        @Override
        public int hashCode() {
            return 0x10FFFF + this.characterType;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj.getClass() != GeneralCategory.class) {
                return false;
            }
            GeneralCategory that = (GeneralCategory)obj;
            return this.characterType == that.characterType;
        }

        @Override
        public String toString() {
            return "[:" + CharacterSet.Unicode.fromCharacterType(this.characterType).name() + ":]";
        }
    }

    private static final class CodePointList
    extends CodePointSet {
        private final int[] codePoints;

        CodePointList(int ... codePoints) {
            this.codePoints = codePoints;
        }

        @Override
        boolean contains(int cp) {
            for (int codePoint : this.codePoints) {
                if (cp != codePoint) continue;
                return true;
            }
            return false;
        }

        @Override
        int firstCodePoint() {
            return this.codePoints[0];
        }

        @Override
        <EX extends Exception> void accept(CharacterSet.DefinitionVisitor<EX> visitor) throws EX {
            for (int cp : this.codePoints) {
                visitor.visitCodePoint(cp);
            }
        }

        @Override
        public int randomCodePoint(Random random) {
            return this.codePoints[random.nextInt(this.codePoints.length)];
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.codePoints);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj.getClass() != CodePointList.class) {
                return false;
            }
            CodePointList that = (CodePointList)obj;
            return Arrays.equals(this.codePoints, that.codePoints);
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder();
            int sep = 91;
            for (int cp : this.codePoints) {
                result.append((char)sep).append(String.format("\\u%04X", cp));
                sep = 44;
            }
            return result.append(']').toString();
        }
    }

    private static final class SingleCodePoint
    extends CodePointSet {
        private final int codePoint;

        SingleCodePoint(int codePoint) {
            this.codePoint = codePoint;
        }

        @Override
        public int hashCode() {
            return this.codePoint;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj.getClass() != SingleCodePoint.class) {
                return false;
            }
            SingleCodePoint that = (SingleCodePoint)obj;
            return this.codePoint == that.codePoint;
        }

        @Override
        public String toString() {
            return String.format("[\\u%04X]", this.codePoint);
        }

        @Override
        boolean contains(int cp) {
            return cp == this.codePoint;
        }

        @Override
        int firstCodePoint() {
            return this.codePoint;
        }

        @Override
        public int randomCodePoint(Random random) {
            return this.codePoint;
        }
    }

    private static final class Range
    extends CodePointSet {
        private final int start;
        private final int end;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        boolean contains(int cp) {
            return this.start <= cp && cp <= this.end;
        }

        @Override
        int firstCodePoint() {
            return this.start;
        }

        @Override
        <EX extends Exception> void accept(CharacterSet.DefinitionVisitor<EX> visitor) throws EX {
            visitor.visitRange(this.start, this.end);
        }

        @Override
        public int randomCodePoint(Random random) {
            return this.start + random.nextInt(this.end - this.start + 1);
        }

        @Override
        public int hashCode() {
            return this.start;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj.getClass() != Range.class) {
                return false;
            }
            Range that = (Range)obj;
            return this.start == that.start && this.end == that.end;
        }

        @Override
        public String toString() {
            return String.format("[\\u%04X-\\u%04X]", this.start, this.end);
        }
    }

    private static final class Union
    extends CodePointSet {
        private final CodePointSet[] union;

        Union(CodePointSet[] union) {
            this.union = union;
        }

        @Override
        boolean contains(int cp) {
            for (CodePointSet set : this.union) {
                if (!set.contains(cp)) continue;
                return true;
            }
            return false;
        }

        @Override
        int firstCodePoint() {
            return this.union[0].firstCodePoint();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.union);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj.getClass() != Union.class) {
                return false;
            }
            Union that = (Union)obj;
            return Arrays.equals(this.union, that.union);
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder().append("[");
            for (CodePointSet set : this.union) {
                result.append(set);
            }
            return result.append("]").toString();
        }

        static CodePointSet flatten(CodePointSet[] union) {
            ArrayList<CodePointSet> flat = new ArrayList<CodePointSet>();
            for (CodePointSet set : union) {
                if (set instanceof Union) {
                    Collections.addAll(flat, ((Union)set).union);
                    continue;
                }
                flat.add(set);
            }
            return new Union(flat.toArray(EMPTY));
        }

        <EX extends Exception> boolean excludeFrom(CharacterSet.ExclusionVisitor<EX> visitor) throws EX {
            for (CodePointSet set : this.union) {
                if (set.name != null) continue;
                return false;
            }
            for (CodePointSet set : this.union) {
                visitor.excludeSet(set.name);
            }
            return true;
        }
    }

    private static final class Disjunction
    extends CodePointSet {
        private final CodePointSet excluded;
        private final CodePointSet included;

        Disjunction(CodePointSet included, CodePointSet excluded) {
            this.excluded = excluded;
            this.included = included;
        }

        @Override
        public CodePointSet except(CodePointSet more) {
            return this.included.except(Disjunction.union(this.excluded, more));
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.included, this.excluded);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj.getClass() != Disjunction.class) {
                return false;
            }
            Disjunction that = (Disjunction)obj;
            return this.included.equals(that.included) && this.excluded.equals(that.excluded);
        }

        @Override
        boolean contains(int cp) {
            return this.included.contains(cp) && !this.excluded.contains(cp);
        }

        @Override
        int firstCodePoint() {
            return this.included.firstCodePoint();
        }

        @Override
        <EX extends Exception> void accept(CharacterSet.DefinitionVisitor<EX> visitor) throws EX {
            if (this.name == null && this.included.name != null && visitor instanceof CharacterSet.DefinitionVisitor.NamedSetVisitor) {
                Disjunction.visit(this.included.name, this.excluded, (CharacterSet.DefinitionVisitor.NamedSetVisitor)visitor);
            } else {
                super.accept(visitor);
            }
        }

        private static <EX extends Exception> void visit(String base, CodePointSet excluded, CharacterSet.DefinitionVisitor.NamedSetVisitor<EX> x) throws EX {
            try (final CharacterSet.ExclusionVisitor<EX> ex = x.visitSet(base);){
                if (excluded.name != null) {
                    ex.excludeSet(excluded.name);
                    return;
                }
                if (excluded instanceof Union && ((Union)excluded).excludeFrom(ex)) {
                    return;
                }
                excluded.accept(new CharacterSet.DefinitionVisitor<EX>(){

                    @Override
                    public void visitCodePoint(int cp) throws Exception {
                        ex.excludeCodePoint(cp);
                    }

                    @Override
                    public void visitRange(int start, int end) throws Exception {
                        ex.excludeRange(start, end);
                    }
                });
            }
        }

        @Override
        public String toString() {
            return this.included + "--" + this.excluded;
        }
    }
}

