/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import org.opencypher.tools.xml.Child;
import org.opencypher.tools.xml.Element;

@Element(uri="http://opencypher.org/grammar", name="description")
class Description {
    private final StringBuilder text = new StringBuilder();

    Description() {
    }

    @Child
    final void text(char[] buffer, int start, int length) {
        Description.extract(this.text, buffer, start, length);
    }

    static void extract(StringBuilder target, char[] buffer, int origin, int length) {
        int ln;
        int cp;
        int end = origin + length;
        int start = Description.findStart(buffer, origin, end);
        if (start >= end) {
            return;
        }
        while (end > start && (Character.isLowSurrogate(buffer[end - 1]) ? Character.isWhitespace(cp = Character.codePointAt(buffer, end - 2)) : Character.isWhitespace(cp = buffer[end - 1]))) {
            end -= Character.charCount(cp);
        }
        if (start == origin && !Character.isWhitespace(Character.codePointAt(buffer, start))) {
            int cp2;
            if (target.length() > 0 && target.charAt(target.length() - 1) != '\n') {
                target.append('\n');
            }
            if ((start = Description.emitLine(target, buffer, start, end, 0)) >= end) {
                return;
            }
            target.append('\n');
            for (int pos = start; pos < end; pos += Character.charCount(cp2)) {
                cp2 = Character.codePointAt(buffer, pos);
                if (cp2 == 10) {
                    target.append('\n');
                    start = pos + 1;
                    continue;
                }
                if (!Character.isWhitespace(cp2)) break;
            }
        }
        int indentation = Description.shortestIndentation(buffer, start, end);
        if (target.length() > 0 && target.charAt(target.length() - 1) != '\n') {
            target.append('\n');
        }
        int n = ln = target.length() > 0 ? 2 : 0;
        while (start < end) {
            if (ln == 1) {
                target.append('\n');
            }
            start = Description.emitLine(target, buffer, start, end, indentation);
            if (ln > 0) {
                target.append('\n');
            }
            ++ln;
        }
    }

    public String toString() {
        return this.text.toString();
    }

    String appendTo(String text) {
        if (this.text.length() == 0) {
            return text;
        }
        if (text.length() > 0) {
            this.text.insert(0, text).insert(text.length(), '\n');
        }
        return this.toString();
    }

    private static int emitLine(StringBuilder target, char[] buffer, int start, int end, int indentation) {
        int cp;
        int last = start;
        for (int pos = start; pos < end; pos += Character.charCount(cp)) {
            cp = Character.codePointAt(buffer, pos);
            if (cp == 10) {
                end = pos + 1;
            }
            if (indentation > 0) {
                if (--indentation == 0) {
                    start = pos + 1;
                }
                last = pos;
                continue;
            }
            if (Character.isWhitespace(cp)) continue;
            last = pos + 1;
        }
        target.append(buffer, start, last - start);
        return end;
    }

    private static int shortestIndentation(char[] buffer, int start, int end) {
        int cp;
        int indentCP = Character.codePointAt(buffer, start);
        if (indentCP != 32 && indentCP != 9) {
            return 0;
        }
        int indentation = Integer.MAX_VALUE;
        int cur = 0;
        for (int pos = start; pos < end; pos += Character.charCount(cp)) {
            cp = Character.codePointAt(buffer, pos);
            if (cp == indentCP) {
                ++cur;
                continue;
            }
            if (cp == 10) {
                cur = 0;
                continue;
            }
            indentation = Math.min(indentation, cur);
            cur = 0;
            while (pos < end && (cp = Character.codePointAt(buffer, pos)) != 10) {
                pos += Character.charCount(cp);
            }
        }
        return indentation;
    }

    private static int findStart(char[] buffer, int start, int end) {
        int pos;
        int cp;
        for (pos = start; pos < end && Character.isWhitespace(cp = Character.codePointAt(buffer, pos)); pos += Character.charCount(cp)) {
            if (cp != 10) continue;
            start = pos + 1;
        }
        return pos >= end ? end : start;
    }
}

