/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.io;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.opencypher.tools.Reflection;
import org.opencypher.tools.io.Output;

public final class HtmlTag
implements AutoCloseable {
    private final Output output;
    private final String tag;

    public static Html html(Path file) {
        return HtmlTag.html(Output.output(file));
    }

    public static Html html(Output output) {
        return new Html(output);
    }

    @SafeVarargs
    public final HtmlTag tag(String tag, Attribute<Void> ... attributes) {
        this.output.append('<').append(tag);
        for (Attribute<Void> attribute : attributes) {
            String value = attribute.value(null);
            if (value == null) continue;
            this.output.append(' ').append(attribute.name()).append("=\"").append(value).append('\"');
        }
        this.output.append('>');
        return new HtmlTag(this.output, tag);
    }

    public HtmlTag text(String text) {
        this.output.escape(text, c -> c == 60 ? "&lt;" : null);
        return this;
    }

    public void p() {
        this.output.println("<p>");
    }

    public void br() {
        this.output.append("<br>");
    }

    public static Attribute<Void> attr(final String attribute, final String value) {
        return new Attribute<Void>(){

            @Override
            public String name() {
                return attribute;
            }

            @Override
            public String value(Void target) {
                return value;
            }
        };
    }

    public static Attribute<HtmlTag> head(final String tag, final Consumer<HtmlTag> content) {
        return new Attribute<HtmlTag>(){

            @Override
            public String name() {
                return tag;
            }

            @Override
            public String value(HtmlTag target) {
                content.accept(target);
                return null;
            }
        };
    }

    private HtmlTag(Output output, String tag) {
        this.output = output;
        this.tag = tag;
    }

    @Override
    public void close() {
        this.output.format("</%s>", this.tag);
    }

    public static final class Html
    implements AutoCloseable {
        private State state = State.EMIT_HEAD;
        private final HtmlTag html;

        @SafeVarargs
        public final void head(Attribute<HtmlTag> ... tags) {
            this.state = this.state.head();
            try (HtmlTag head = this.html.tag("head", new Attribute[0]);){
                for (Attribute<HtmlTag> tag : tags) {
                    try (HtmlTag headTag = head.tag(tag.name(), new Attribute[0]);){
                        String text = tag.value(headTag);
                        if (text == null) continue;
                        headTag.text(text);
                    }
                }
            }
        }

        public HtmlTag body() {
            this.state = this.state.body();
            return this.html.tag("body", new Attribute[0]);
        }

        private Html(Output output) {
            output.append("<html>");
            this.html = new HtmlTag(output, "html");
        }

        @Override
        public void close() {
            this.state = this.state.close();
            this.html.close();
            this.html.output.close();
        }

        private static enum State {
            EMIT_HEAD{

                @Override
                State head() {
                    return EMIT_BODY;
                }

                @Override
                State body() {
                    return SHOULD_CLOSE;
                }

                @Override
                State close() {
                    return CLOSED;
                }
            }
            ,
            EMIT_BODY{

                @Override
                State head() {
                    return this.illegal("<head> has already been emitted.");
                }

                @Override
                State body() {
                    return SHOULD_CLOSE;
                }

                @Override
                State close() {
                    return CLOSED;
                }
            }
            ,
            SHOULD_CLOSE{

                @Override
                State head() {
                    return this.illegal("<head> and <body> have already been emitted.");
                }

                @Override
                State body() {
                    return this.illegal("<body> has already been emitted.");
                }

                @Override
                State close() {
                    return CLOSED;
                }
            }
            ,
            CLOSED{

                @Override
                State head() {
                    return this.illegal("Already closed");
                }

                @Override
                State body() {
                    return this.illegal("Already closed");
                }

                @Override
                State close() {
                    return this.illegal("Already closed");
                }
            };


            abstract State head();

            abstract State body();

            abstract State close();

            State illegal(String message) {
                throw new IllegalStateException(message);
            }
        }
    }

    @FunctionalInterface
    public static interface Attribute<T>
    extends Serializable {
        public String value(T var1);

        default public String name() {
            return Reflection.lambdaParameterName(this);
        }
    }
}

