/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.opencypher.grammar.AlternativesNode;
import org.opencypher.grammar.CharacterSetNode;
import org.opencypher.grammar.Container;
import org.opencypher.grammar.LiteralNode;
import org.opencypher.grammar.Node;
import org.opencypher.grammar.NonTerminalNode;
import org.opencypher.grammar.OptionalNode;
import org.opencypher.grammar.Production;
import org.opencypher.grammar.ProductionNode;
import org.opencypher.grammar.ProductionTransformation;
import org.opencypher.grammar.ProductionVisitor;
import org.opencypher.grammar.RepetitionNode;
import org.opencypher.grammar.Root;
import org.opencypher.grammar.SequenceNode;
import org.opencypher.grammar.Sequenced;
import org.opencypher.grammar.TermTransformation;
import org.opencypher.grammar.TermVisitor;
import org.opencypher.tools.xml.XmlParser;
import org.xml.sax.SAXException;

public interface Grammar {
    public static final String XML_NAMESPACE = "http://opencypher.org/grammar";
    public static final String SCOPE_XML_NAMESPACE = "http://opencypher.org/scope";
    public static final String GENERATOR_XML_NAMESPACE = "http://opencypher.org/stringgeneration";
    public static final String RAILROAD_XML_NAMESPACE = "http://opencypher.org/railroad";
    public static final String OPENCYPHER_XML_NAMESPACE = "http://opencypher.org/opencypher";

    public static Grammar parseXML(Path input, ParserOption ... options) throws ParserConfigurationException, SAXException, IOException {
        return Root.XML.parse(input, ParserOption.xml(options)).resolve(ParserOption.resolve(options));
    }

    public static Grammar parseXML(Reader input, ParserOption ... options) throws ParserConfigurationException, SAXException, IOException {
        return Root.XML.parse(input, ParserOption.xml(options)).resolve(ParserOption.resolve(options));
    }

    public static Grammar parseXML(InputStream input, ParserOption ... options) throws ParserConfigurationException, SAXException, IOException {
        return Root.XML.parse(input, ParserOption.xml(options)).resolve(ParserOption.resolve(options));
    }

    public String language();

    public String header();

    public <EX extends Exception> void accept(ProductionVisitor<EX> var1) throws EX;

    public boolean hasProduction(String var1);

    public <P, R, EX extends Exception> R transform(String var1, ProductionTransformation<P, R, EX> var2, P var3) throws EX;

    default public <P, EX extends Exception> void transform(ProductionTransformation<P, Void, EX> transformation, P param) throws EX {
        this.transform(transformation, param, Collector.of(() -> null, (a, b) -> {}, (a, b) -> null, new Collector.Characteristics[0]));
    }

    public <P, A, R, T, EX extends Exception> T transform(ProductionTransformation<P, R, EX> var1, P var2, Collector<R, A, T> var3) throws EX;

    default public Production production(String name) {
        return this.transform(name, (param, production) -> production, null);
    }

    public static Builder grammar(String language, Option ... options) {
        Builder builder = new Builder(language);
        if (options != null) {
            for (Option option : options) {
                option.apply(builder);
            }
        }
        return builder;
    }

    public static Term epsilon() {
        return Node.epsilon();
    }

    public static Term caseInsensitive(String value) {
        LiteralNode literal = new LiteralNode();
        literal.value = Objects.requireNonNull(value, "literal value");
        literal.caseSensitive = false;
        return literal;
    }

    public static Term literal(String value) {
        LiteralNode literal = new LiteralNode();
        literal.value = Objects.requireNonNull(value, "literal value");
        literal.caseSensitive = true;
        return literal;
    }

    public static CharacterSet charactersOfSet(String name) {
        return new CharacterSet(Objects.requireNonNull(name, "character set name"));
    }

    public static CharacterSet anyCharacter() {
        return new CharacterSet(CharacterSetNode.DEFAULT_SET);
    }

    public static Term nonTerminal(String production) {
        NonTerminalNode nonTerminal = new NonTerminalNode();
        nonTerminal.ref = production;
        return nonTerminal;
    }

    public static Term optional(Term first, Term ... more) {
        return Grammar.sequence(first, more).addTo(new OptionalNode());
    }

    public static Term oneOf(Term first, Term ... alternatives) {
        if (alternatives == null || alternatives.length == 0) {
            return first;
        }
        return new AlternativesNode().addAll(first, alternatives);
    }

    public static Term zeroOrMore(Term first, Term ... more) {
        return Grammar.sequence(first, more).addTo(new RepetitionNode());
    }

    public static Term oneOrMore(Term first, Term ... more) {
        return Grammar.atLeast(1, first, more);
    }

    public static Term atLeast(int times, Term first, Term ... more) {
        RepetitionNode repetition = new RepetitionNode();
        repetition.min = times;
        return Grammar.sequence(first, more).addTo(repetition);
    }

    public static Term repeat(int times, Term first, Term ... more) {
        RepetitionNode repetition = new RepetitionNode();
        repetition.max = times;
        repetition.min = repetition.max;
        return Grammar.sequence(first, more).addTo(repetition);
    }

    public static Term repeat(int min, int max, Term first, Term ... more) {
        RepetitionNode repetition = new RepetitionNode();
        repetition.min = min;
        repetition.max = max;
        return Grammar.sequence(first, more).addTo(repetition);
    }

    public static Term sequence(Term first, Term ... more) {
        if (more == null || more.length == 0) {
            return first;
        }
        return new SequenceNode().addAll(first, more);
    }

    public static enum ParserOption {
        FAIL_ON_UNKNOWN_XML_ATTRIBUTE(XmlParser.Option.FAIL_ON_UNKNOWN_ATTRIBUTE),
        SKIP_UNUSED_PRODUCTIONS(Root.ResolutionOption.SKIP_UNUSED_PRODUCTIONS),
        ALLOW_ROOTLESS_GRAMMAR(Root.ResolutionOption.ALLOW_ROOTLESS),
        INCLUDE_LEGACY(Root.ResolutionOption.INCLUDE_LEGACY);

        private final Object option;

        private ParserOption(Root.ResolutionOption option) {
            this.option = option;
        }

        private ParserOption(XmlParser.Option option) {
            this.option = option;
        }

        public static ParserOption[] from(Properties properties) {
            EnumSet<ParserOption> result = EnumSet.noneOf(ParserOption.class);
            for (ParserOption option : ParserOption.values()) {
                if (!Boolean.parseBoolean(properties.getProperty(option.name()))) continue;
                result.add(option);
            }
            return result.toArray(new ParserOption[result.size()]);
        }

        private static XmlParser.Option[] xml(ParserOption[] options) {
            return ParserOption.options(XmlParser.Option.class, options);
        }

        private static Root.ResolutionOption[] resolve(ParserOption[] options) {
            return ParserOption.options(Root.ResolutionOption.class, options);
        }

        private static <T> T[] options(Class<T> type, ParserOption ... options) {
            if (options == null || options.length == 0) {
                return null;
            }
            List<Object> collected = Stream.of(options).flatMap(the -> type.isInstance(the.option) ? Stream.of(type.cast(the.option)) : Stream.empty()).collect(Collectors.toList());
            Object[] result = (Object[])Array.newInstance(type, collected.size());
            return collected.toArray(result);
        }
    }

    public static abstract class Option {
        abstract void apply(Root var1);
    }

    public static abstract class Term {
        public final <EX extends Exception> void accept(TermVisitor<EX> visitor) throws EX {
            this.transform(Node.visit(), visitor);
        }

        public abstract <P, T, EX extends Exception> T transform(TermTransformation<P, T, EX> var1, P var2) throws EX;

        abstract Container addTo(Container var1);

        abstract Sequenced addTo(Sequenced var1);

        abstract ProductionNode addTo(ProductionNode var1);
    }

    public static class Builder
    extends Root {
        private Builder(String language) {
            this.language = Objects.requireNonNull(language, "language name");
        }

        public Builder production(String name, Term first, Term ... alternatives) {
            ProductionNode production = new ProductionNode(this);
            production.name = Objects.requireNonNull(name, "name");
            Grammar.oneOf(first, alternatives).addTo(production);
            this.add(production);
            return this;
        }

        public Grammar build(Option ... options) {
            return this.resolve((Root.ResolutionOption[])(options == null ? Stream.empty() : Stream.of(options)).map(x -> ((Option)x).option).toArray(Root.ResolutionOption[]::new));
        }

        public static enum Option {
            IGNORE_UNUSED_PRODUCTIONS(Root.ResolutionOption.IGNORE_UNUSED_PRODUCTIONS),
            ALLOW_ROOTLESS(Root.ResolutionOption.ALLOW_ROOTLESS);

            private final Root.ResolutionOption option;

            private Option(Root.ResolutionOption option) {
                this.option = option;
            }
        }
    }

    public static final class CharacterSet
    extends CharacterSetNode {
        private CharacterSet(String set) {
            this.set(set);
        }

        public CharacterSet except(int ... codePoints) {
            for (int codePoint : codePoints) {
                this.exclude(codePoint);
            }
            return this;
        }
    }
}

