/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.Map;
import java.util.Set;
import org.opencypher.grammar.Dependencies;
import org.opencypher.grammar.ProductionNode;
import org.opencypher.grammar.Root;

class ProductionResolver {
    private final Map<String, ProductionNode> productions;
    private final Dependencies dependencies;
    private final Set<String> unused;
    private final Set<Root.ResolutionOption> options;
    private final Set<String> legacyProductions;
    private int nonTerminalIndex;

    public ProductionResolver(Map<String, ProductionNode> productions, Dependencies dependencies, Set<String> unused, Set<Root.ResolutionOption> options, Set<String> legacyProductions) {
        this.productions = productions;
        this.dependencies = dependencies;
        this.unused = unused;
        this.options = options;
        this.legacyProductions = legacyProductions;
    }

    public ProductionNode resolveProduction(ProductionNode origin, String name) {
        ProductionNode production = this.productions.get(name.toLowerCase());
        if (production == null && !this.options.contains((Object)Root.ResolutionOption.INCLUDE_LEGACY) && !this.legacyProductions.contains(name.toLowerCase())) {
            this.dependencies.missingProduction(name, origin);
        } else if (production != null && production.name.equals(name)) {
            this.unused.remove(name);
            this.dependencies.usedFrom(name, origin);
        } else {
            production = null;
        }
        return production;
    }

    public int nextNonTerminalIndex() {
        return this.nonTerminalIndex++;
    }
}

