/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.opencypher.generator.Choices;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Repetition;

public class ChoicesDistributionTest {
    @Ignore
    @Test
    public void printHistogram() throws Exception {
        this.printHistograms(ChoicesDistributionTest.repetitionHistogram(0, 0), ChoicesDistributionTest.repetitionHistogram(0, 0, 0), ChoicesDistributionTest.repetitionHistogram(0, 1), ChoicesDistributionTest.repetitionHistogram(0, 1, 1), ChoicesDistributionTest.repetitionHistogram(1, 1), ChoicesDistributionTest.repetitionHistogram(1, 1, 1), ChoicesDistributionTest.repetitionHistogram(0, 7, 7));
    }

    @Test
    public void shouldNotGenerateValuesOutsideOfRange() throws Exception {
        ChoicesDistributionTest.repetitionHistogram(1, 1, 1).assertOrderIs((Integer[])new Integer[]{1});
    }

    @Test
    public void oneShouldBeTheMostCommonForRepetitionsWithMinZero() throws Exception {
        ChoicesDistributionTest.repetitionHistogram(0, 1).assertOrderStartsWith((Integer[])new Integer[]{1, 2, 0, 3, 4}).assertRatio(1, 2, 0.73, 0.76).assertRatio(2, 0, 0.85, 0.92).assertRatio(2, 3, 0.45, 0.52).assertRatio(3, 4, 0.35, 0.4);
    }

    @Test
    public void oneShouldBeTheMostCommonForRepetitionsWithMinOne() throws Exception {
        ChoicesDistributionTest.repetitionHistogram(1, 1).assertOrderStartsWith((Integer[])new Integer[]{1, 2, 3, 4, 5}).assertRatio(1, 2, 0.45, 0.52).assertRatio(2, 3, 0.22, 0.28).assertRatio(3, 4, 0.14, 0.18).assertRatio(4, 5, 0.11, 0.14);
    }

    @Test
    public void twoShouldBeTheMostCommonForRepetitionsWithMinTwo() throws Exception {
        ChoicesDistributionTest.repetitionHistogram(2, 2).assertOrderStartsWith((Integer[])new Integer[]{2, 3, 4, 5, 6}).assertRatio(2, 3, 0.45, 0.52).assertRatio(3, 4, 0.22, 0.28).assertRatio(4, 5, 0.15, 0.18).assertRatio(5, 6, 0.11, 0.14);
    }

    static <T extends Comparable<T>> Map<T, Long> histogram(int samples, Supplier<T> sampler) {
        HashMap<Comparable, Long> histogram = new HashMap<Comparable, Long>();
        for (int i = 0; i < samples; ++i) {
            Comparable value = (Comparable)sampler.get();
            histogram.compute(value, (k, v) -> v == null ? 1L : v + 1L);
        }
        return histogram;
    }

    private static <T> T[] sortedArray(Class<T> type, Collection<T> values, Comparator<T> cmp) {
        Object[] array = values.toArray((Object[])Array.newInstance(type, values.size()));
        Arrays.sort(array, cmp);
        return array;
    }

    @SafeVarargs
    private final void printHistograms(Histogram<Integer> ... histograms) {
        int max = 0;
        System.out.print("key");
        for (Histogram<Integer> histogram : histograms) {
            for (Integer key : histogram.keys()) {
                max = Math.max(max, key);
            }
            System.out.print('\t');
            System.out.print(histogram.name);
        }
        System.out.println();
        for (int i = 0; i <= max; ++i) {
            System.out.print(i);
            for (Histogram<Integer> histogram : histograms) {
                System.out.print('\t');
                System.out.print(histogram.get(i));
            }
            System.out.println();
        }
    }

    static <T> void assertSamePrefix(IntFunction<String> message, T[] expected, T[] actual) {
        for (int i = 0; i < expected.length && i < actual.length; ++i) {
            org.opencypher.tools.Assert.assertEquals(ChoicesDistributionTest.message(message, i), expected[i], actual[i]);
        }
    }

    private static Supplier<String> message(IntFunction<String> message, int i) {
        return () -> (String)message.apply(i);
    }

    static Histogram<Integer> repetitionHistogram(int min, int norm) {
        return ChoicesDistributionTest.repetitionHistogram(new RepetitionStub(min, norm, null));
    }

    static Histogram<Integer> repetitionHistogram(int min, int norm, int max) {
        return ChoicesDistributionTest.repetitionHistogram(new RepetitionStub(min, norm, max));
    }

    private static Histogram<Integer> repetitionHistogram(Repetition repetition) {
        return new Histogram<Integer>(repetition.limited() ? String.format("[%d|%d|%d]", repetition.minTimes(), repetition.norm(), repetition.maxTimes()) : String.format("[%d|%d...", repetition.minTimes(), repetition.norm()), ChoicesDistributionTest.histogram(1000000, () -> Choices.times((Repetition)repetition)));
    }

    private static class RepetitionStub
    implements Repetition {
        private final int min;
        private final int norm;
        private final Integer max;

        private RepetitionStub(int min, int norm, Integer max) {
            assert (min <= norm);
            assert (max == null || norm <= max);
            this.min = min;
            this.norm = norm;
            this.max = max;
        }

        public int minTimes() {
            return this.min;
        }

        public int norm() {
            return this.norm;
        }

        public boolean limited() {
            return this.max != null;
        }

        public int maxTimes() {
            if (this.max != null) {
                return this.max;
            }
            throw new UnsupportedOperationException();
        }

        public Grammar.Term term() {
            throw new UnsupportedOperationException();
        }
    }

    static class Histogram<T> {
        final String name;
        final Map<T, Long> histogram;

        Histogram(String name, Map<T, Long> histogram) {
            this.name = name;
            this.histogram = histogram;
        }

        public Iterable<? extends T> keys() {
            return this.histogram.keySet();
        }

        public long get(T key) {
            return this.histogram.getOrDefault(key, 0L);
        }

        @SafeVarargs
        public final Histogram<T> assertOrderStartsWith(T ... prefix) {
            return this.assertOrder(len -> prefix.length <= len, prefix);
        }

        @SafeVarargs
        public final Histogram<T> assertOrderIs(T ... order) {
            return this.assertOrder(len -> order.length == len, order);
        }

        @SafeVarargs
        private final Histogram<T> assertOrder(IntPredicate length, T ... order) {
            Class<?> type = order.getClass().getComponentType();
            ?[] actual = this.order(type);
            Assert.assertTrue((String)("length was: " + actual.length), (boolean)length.test(actual.length));
            ChoicesDistributionTest.assertSamePrefix(i -> this.message(order, i), order, actual);
            return this;
        }

        private T[] order(Class<T> type) {
            return ChoicesDistributionTest.sortedArray(type, this.histogram.keySet(), Collections.reverseOrder(Comparator.comparingLong(this.histogram::get)));
        }

        private String message(T[] order, int offset) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < order.length; ++i) {
                result.append(i == 0 ? "{" : ", ");
                if (i == offset) {
                    result.append("**");
                }
                result.append(order[i]);
                if (i == offset) {
                    result.append("**");
                }
                result.append(':').append(this.get(order[i]));
            }
            return result.append('}').toString();
        }

        public Histogram<T> assertRatio(T key1, T key2, double minRatio, double maxRatio) {
            long value1 = this.get(key1);
            long value2 = this.get(key2);
            double ratio = (double)value2 / (double)value1;
            Assert.assertThat((String)String.format("Ratio between %s (%d) and %s (%d)", key1, value1, key2, value2), (Object)ratio, (Matcher)CoreMatchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(minRatio)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(maxRatio))));
            return this;
        }
    }
}

