/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import org.junit.Assert;
import org.junit.Test;
import org.opencypher.grammar.Description;
import org.opencypher.tools.io.Output;

public class DescriptionExtractionTest {
    @Test
    public void shouldTrimWhitespace() throws Exception {
        Assert.assertEquals((Object)"hello   world", (Object)DescriptionExtractionTest.extract("   hello   world       "));
    }

    @Test
    public void shouldSkipAllWhitespace() throws Exception {
        Assert.assertEquals((Object)"", (Object)DescriptionExtractionTest.extract("         \t\n  \n\t"));
    }

    @Test
    public void shouldAlignLines() throws Exception {
        Assert.assertEquals((Object)Output.lines((String[])new String[]{"Hello,", "", "This is a message.", "    (the content is not important)", "The important part is the indentation."}), (Object)DescriptionExtractionTest.extract(Output.lines((String[])new String[]{"", "              ", "    Hello,    ", "", "    This is a message.", "        (the content is not important)", "    The important part is the indentation.", "", "    "})));
    }

    @Test
    public void shouldAlignToSecondLineIfFirstIsWithoutWhitespace() throws Exception {
        Assert.assertEquals((Object)Output.lines((String[])new String[]{"Hello,", "", "This is a message.", "    (the content is not important)", "The important part is the indentation."}), (Object)DescriptionExtractionTest.extract(Output.lines((String[])new String[]{"Hello,    ", "", "    This is a message.                    ", "        (the content is not important)    ", "    The important part is the indentation."})));
    }

    @Test
    public void shouldAlignToFirstLineIfPrecededByBlankLines() throws Exception {
        Assert.assertEquals((Object)Output.lines((String[])new String[]{"Hello,", "", "    This is a message.", "        (the content is not important)", "    The important part is the indentation."}), (Object)DescriptionExtractionTest.extract(Output.lines((String[])new String[]{"          ", "Hello,    ", "", "    This is a message.                    ", "        (the content is not important)    ", "    The important part is the indentation."})));
    }

    static String extract(String ... strings) {
        int length = 0;
        for (String string : strings) {
            length = Math.max(length, string.length());
        }
        char[] buffer = new char[length];
        StringBuilder result = new StringBuilder();
        for (String string : strings) {
            int start = (length - string.length()) / 2;
            string.getChars(0, string.length(), buffer, start);
            Description.extract((StringBuilder)result, (char[])buffer, (int)start, (int)string.length());
        }
        return result.toString();
    }
}

