/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.railroad;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.swing.JSVGCanvas;
import org.opencypher.grammar.Grammar;
import org.opencypher.railroad.AwtShapes;
import org.opencypher.railroad.Diagram;
import org.opencypher.railroad.SVGShapes;
import org.opencypher.railroad.ShapeRenderer;
import org.opencypher.tools.Interactive;
import org.opencypher.tools.Option;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class RailRoadViewer
implements Interactive.Test<Context, Map<String, Document>> {
    RailRoadViewer() {
    }

    @Override
    public Map<String, Document> suite(String className, String methodName, Context ctx) throws XMLStreamException {
        ShapeRenderer shapes = new ShapeRenderer(ctx.options);
        HashMap<String, Document> result = new HashMap<String, Document>();
        for (Diagram diagram : Diagram.build((Grammar)ctx.grammar, (Diagram.BuilderOptions)((Diagram.BuilderOptions)Option.options(Diagram.BuilderOptions.class, (Option[])ctx.options)))) {
            result.put(diagram.name(), (Document)diagram.convert((Diagram.Renderer)shapes, (Diagram.CanvasProvider)SVGShapes.SVG_DOM));
        }
        return result;
    }

    @Override
    public Map<String, Document> singleClass(String className, String methodName, Context test) throws XMLStreamException, IOException, TransformerException {
        Map<String, Document> documents = this.suite(className, methodName, test);
        for (Map.Entry<String, Document> entry : documents.entrySet()) {
            RailRoadViewer.printDocument(entry.getValue(), System.out);
        }
        return documents;
    }

    @Override
    public Map<String, Document> singleMethod(String className, String methodName, Context grammar) throws InterruptedException, XMLStreamException, IOException, TransformerException {
        Map<String, Document> documents = this.singleClass(className, methodName, grammar);
        CountDownLatch latch = new CountDownLatch(1);
        JFrame[] frames = new JFrame[documents.size()];
        SwingUtilities.invokeLater(() -> {
            try {
                int i = 0;
                for (Map.Entry entry : documents.entrySet()) {
                    frames[i++] = RailRoadViewer.frame(latch, String.format("%s - %s#%s()", entry.getKey(), className, methodName), (Document)entry.getValue());
                }
                for (JFrame frame : frames) {
                    frame.setVisible(true);
                }
            }
            catch (Throwable e) {
                latch.countDown();
                throw e;
            }
        });
        latch.await();
        SwingUtilities.invokeLater(() -> {
            for (JFrame frame : frames) {
                if (frame == null) continue;
                frame.setVisible(false);
                frame.dispose();
            }
        });
        return documents;
    }

    static JFrame frame(CountDownLatch latch, String title, Document document) {
        return RailRoadViewer.frame(latch, title, () -> RailRoadViewer.canvas(document));
    }

    static JFrame frame(CountDownLatch latch, String title, final AwtShapes shapes) {
        return RailRoadViewer.frame(latch, title, () -> new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension((int)shapes.getWidth(), (int)shapes.getHeight());
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                shapes.render(g2d);
            }
        });
    }

    private static JFrame frame(final CountDownLatch latch, String title, Supplier<JComponent> canvas) {
        JFrame frame = new JFrame(title);
        frame.add((Component)canvas.get(), "Center");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                latch.countDown();
            }
        });
        frame.add((Component)RailRoadViewer.button("Done", e -> latch.countDown()), "Last");
        frame.pack();
        return frame;
    }

    private static JButton button(String title, ActionListener listener) {
        JButton button = new JButton(title);
        button.addActionListener(listener);
        return button;
    }

    private static JComponent canvas(Document document) {
        JSVGCanvas canvas = new JSVGCanvas();
        canvas.setDocument(document);
        Element root = document.getDocumentElement();
        if (root != null) {
            String width = root.getAttribute("width");
            String height = root.getAttribute("height");
            if (width != null && !width.isEmpty() && height != null && !height.isEmpty()) {
                try {
                    canvas.setPreferredSize(new Dimension((int)Double.parseDouble(width), (int)Double.parseDouble(height)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return canvas;
    }

    static void printDocument(Document doc, OutputStream out) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    static final class Context {
        private final Grammar grammar;
        private final Option<Object>[] options;

        @SafeVarargs
        Context(Grammar grammar, Option<Object> ... options) {
            this.grammar = grammar;
            this.options = options;
        }
    }
}

