/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools;

import java.util.function.Consumer;
import org.opencypher.tools.Interactive;
import org.opencypher.tools.io.Output;

public class VerboseUnit
extends Interactive<Consumer<Output>, Void> {
    public VerboseUnit(final int repetitions) {
        super(new Interactive.Test<Consumer<Output>, Void>(){

            @Override
            public Void suite(String className, String methodName, Consumer<Output> test) {
                test.accept((Output)Output.nowhere());
                return null;
            }

            @Override
            public Void singleClass(String className, String methodName, Consumer<Output> test) {
                VerboseUnit.execute(methodName, test, 0);
                return null;
            }

            @Override
            public Void singleMethod(String className, String methodName, Consumer<Output> test) {
                VerboseUnit.execute(methodName, test, repetitions);
                return null;
            }
        });
    }

    private static void execute(String methodName, Consumer<Output> test, int times) {
        Output out = Output.stdOut();
        out.append(methodName).append(": '");
        test.accept(out);
        out.println("'");
        if (times > 0) {
            long time = System.nanoTime();
            for (int i = 0; i < times; ++i) {
                test.accept((Output)Output.nowhere());
            }
            time = System.nanoTime() - time;
            out.format("%s: %.3fus/invocation%n", new Object[]{methodName, (double)time / 1000.0 / (double)times});
        }
    }
}

