/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import javax.xml.transform.TransformerException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.grammar.Antlr4;
import org.opencypher.tools.grammar.Antlr4ToolFacade;
import org.opencypher.tools.io.Output;

public class Antlr4Test {
    @Test
    public void shouldGroupRepetitionCorrectly() throws TransformerException {
        Antlr4Test.assertGenerates(Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("thing1", Grammar.literal((String)"1"), new Grammar.Term[0]).production("thing2", Grammar.literal((String)"2"), new Grammar.Term[0]).production("bar", Grammar.zeroOrMore((Grammar.Term)Grammar.nonTerminal((String)"thing1"), (Grammar.Term[])new Grammar.Term[]{Grammar.nonTerminal((String)"thing2")}), new Grammar.Term[0]).build(new Grammar.Builder.Option[]{Grammar.Builder.Option.ALLOW_ROOTLESS}), "grammar foo;", "", "thing1 : '1' ;", "", "thing2 : '2' ;", "", "bar : ( thing1 thing2 )* ;", "");
    }

    @Test
    public void shouldProduceLiteral() throws TransformerException {
        Antlr4Test.assertGenerates(Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("bar", Grammar.literal((String)"LIteR@L"), new Grammar.Term[0]).build(new Grammar.Builder.Option[]{Grammar.Builder.Option.ALLOW_ROOTLESS}), "grammar foo;", "", "bar : 'LIteR@L' ;", "");
    }

    @Test
    public void shouldNotMakeRulesForLiteralsWithoutCaseAlternatives() throws TransformerException {
        Antlr4Test.assertGenerates(Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("other", Grammar.literal((String)"abc"), new Grammar.Term[0]).production("bar", Grammar.nonTerminal((String)"other"), new Grammar.Term[]{Grammar.caseInsensitive((String)"=>~`$&@"), Grammar.nonTerminal((String)"other")}).build(new Grammar.Builder.Option[]{Grammar.Builder.Option.ALLOW_ROOTLESS}), "grammar foo;", "", "other : 'abc' ;", "", "bar : other", "    | '=>~`$&@'", "    | other", "    ;", "");
    }

    @Test
    public void shouldProduceCaseInsensitive() throws TransformerException {
        Antlr4Test.assertGenerates(Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("bar", Grammar.caseInsensitive((String)"LIteR@L"), new Grammar.Term[0]).build(new Grammar.Builder.Option[]{Grammar.Builder.Option.ALLOW_ROOTLESS}), "grammar foo;", "", "bar : LITER@L ;", "", "LITER@L : ( 'L' | 'l' ) ( 'I' | 'i' ) ( 'T' | 't' ) ( 'E' | 'e' ) ( 'R' | 'r' ) ( '@' | '@' ) ( 'L' | 'l' )  ;", "");
    }

    @Test
    public void shouldProduceSimpleParserGrammar() throws Exception {
        Antlr4Test.assertGenerates(Grammar.grammar((String)"MyLanguage", (Grammar.Option[])new Grammar.Option[0]).production("MyLanguage", Grammar.nonTerminal((String)"value"), new Grammar.Term[0]).production("value", Grammar.nonTerminal((String)"alpha"), new Grammar.Term[]{Grammar.nonTerminal((String)"beta")}).production("alpha", Grammar.literal((String)"a"), new Grammar.Term[0]).production("beta", Grammar.literal((String)"b"), new Grammar.Term[0]), "grammar MyLanguage;", "", "myLanguage : value ;", "", "value : alpha", "      | beta", "      ;", "", "alpha : 'a' ;", "", "beta : 'b' ;", "");
    }

    @Test
    public void shouldEncloseOptionalSequence() throws Exception {
        Antlr4Test.assertGenerates(Grammar.grammar((String)"FooBar", (Grammar.Option[])new Grammar.Option[0]).production("FooBar", Grammar.optional((Grammar.Term)Grammar.literal((String)"foo"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"bar")}), new Grammar.Term[0]), "grammar FooBar;", "", "fooBar : ( 'foo' 'bar' )? ;", "");
    }

    @Test
    public void shouldGenerateCharacterSet() throws Exception {
        Antlr4Test.assertCharset("White_Space", "[\\t\\n\\u000B\\f\\r \\u0085\\u00A0\\u1680\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]");
    }

    @Test
    public void shouldGenerateCharacterSetWithExceptions() throws Exception {
        Antlr4Test.assertGenerates(Grammar.grammar((String)"test", (Grammar.Option[])new Grammar.Option[0]).production("test", (Grammar.Term)Grammar.charactersOfSet((String)"Sc").except(new int[]{1423, 1547, 2546, 2547, 2555, 2801, 3065, 3647, 6107, 43064, 65020, 65129, 65284, 65504, 65505, 65509, 65510}), new Grammar.Term[0]), "grammar test;", "", "test : TEST_0 ;", "", "fragment TEST_0 : [$\\u00A2-\\u00A5\\u20A0-\\u20BA] ;", "");
    }

    static void assertCharset(String name, String def) {
        Antlr4Test.assertGenerates(Grammar.grammar((String)"test", (Grammar.Option[])new Grammar.Option[0]).production("test", (Grammar.Term)Grammar.charactersOfSet((String)name), new Grammar.Term[0]), "grammar test;", "", "test : " + name + " ;", "", "fragment " + name + " : " + def + " ;", "");
    }

    @Test
    public void shouldGenerateCypherGrammar() throws Exception {
        Antlr4ToolFacade.assertGeneratesValidParser("/cypher.xml");
    }

    static void assertGenerates(Grammar.Builder grammar, String ... lines) {
        Antlr4Test.assertGenerates(grammar.build(new Grammar.Builder.Option[0]), lines);
    }

    static void assertGenerates(Grammar grammar, String ... lines) {
        Output.Readable result = Output.stringBuilder();
        Antlr4.write((Grammar)grammar, (Output)result);
        Assert.assertThat((Object)result, Antlr4Test.contentsEquals(lines));
    }

    static Matcher<Output.Readable> contentsEquals(String ... lines) {
        final String expected = Output.lines((String[])lines);
        return new TypeSafeMatcher<Output.Readable>(){

            protected boolean matchesSafely(Output.Readable item) {
                return item.contentEquals((CharSequence)expected);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)expected);
            }
        };
    }
}

