/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.railroad;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.opencypher.railroad.Diagram;
import org.opencypher.railroad.Size;
import org.opencypher.railroad.TextGlyphs;
import org.opencypher.tools.Option;

public final class ShapeRenderer<EX extends Exception>
implements Diagram.Renderer<Shapes<? extends EX>, TextGlyphs, EX> {
    private final Linker linker;
    private final FontRenderContext frc;
    private final Font productionFont;
    private final Font textFont;
    private final Font anyCaseFont;
    private final Font charsetFont;
    private final Font loopDescriptionFont;
    private final double diagramMargin;
    private final double bulletRadius;
    private final double arrowWidth;
    private final double arrowHeight;
    private final double arrowIndent;
    private final double arrowBefore;
    private final double arrowAfter;
    private final double tokenPadding;
    private final double tokenMargin;
    private final double nonTerminalPadding;
    private final double branchSpacing;
    private final double branchRadius;
    private final double branchBefore;
    private final double branchAfter;
    private final double loopSpacing;
    private final double loopRadius;
    private final double loopBefore;
    private final double loopAfter;
    private final double loopDescriptionMargin;
    private final Size bulletSize;
    private final Size arrowSize;

    private static Shapes.Point point(double x, double y) {
        return new Shapes.Point(x, y);
    }

    @SafeVarargs
    ShapeRenderer(Option<? super Options> ... options) {
        this((String link) -> null, new FontRenderContext(new AffineTransform(), true, true), Option.options(Options.class, options));
    }

    public ShapeRenderer(Linker linker, FontRenderContext frc, Options options) {
        this.linker = linker;
        this.frc = frc;
        this.diagramMargin = options.diagramMargin();
        this.productionFont = options.productionFont();
        this.textFont = options.textFont();
        this.anyCaseFont = options.anyCaseFont();
        this.charsetFont = options.charsetFont();
        this.loopDescriptionFont = options.loopDescriptionFont();
        this.bulletRadius = options.bulletRadius();
        this.bulletSize = new Size(this.bulletRadius * 2.0, this.bulletRadius * 2.0, this.bulletRadius);
        this.arrowWidth = options.arrowWidth();
        this.arrowHeight = options.arrowHeight();
        this.arrowSize = new Size(this.arrowWidth, this.arrowHeight, this.arrowHeight / 2.0);
        this.arrowIndent = options.arrowIndent();
        this.arrowBefore = options.arrowBefore();
        this.arrowAfter = options.arrowAfter();
        this.tokenPadding = options.tokenPadding();
        this.tokenMargin = options.tokenMargin();
        this.nonTerminalPadding = options.nonTerminalPadding();
        this.branchSpacing = options.branchSpacing();
        this.branchRadius = options.branchRadius();
        this.branchBefore = options.branchBefore();
        this.branchAfter = options.branchAfter();
        this.loopSpacing = options.loopSpacing();
        this.loopRadius = options.loopRadius();
        this.loopBefore = options.loopBefore();
        this.loopAfter = options.loopAfter();
        this.loopDescriptionMargin = options.loopDescriptionMargin();
    }

    @Override
    public Size diagramSize(Size root) {
        return new Size(root.width + 2.0 * this.diagramMargin, root.height + 2.0 * this.diagramMargin, root.linePosition + this.diagramMargin);
    }

    @Override
    public void renderDiagram(String name, Shapes<? extends EX> shapes, Diagram.Figure root) throws EX {
        shapes.begin();
        root.render(shapes, this.diagramMargin, this.diagramMargin, this, true);
        shapes.end();
    }

    @Override
    public TextGlyphs renderText(String type, String text) {
        return new TextGlyphs(text, this.font(type), this.frc);
    }

    private Font font(String type) {
        switch (type) {
            case "anycase": {
                return this.anyCaseFont;
            }
            case "charset": {
                return this.charsetFont;
            }
            case "reference": {
                return this.productionFont;
            }
            case "text": {
                return this.textFont;
            }
            case "loop": {
                return this.loopDescriptionFont;
            }
        }
        throw new IllegalArgumentException("Unknown text type: " + type);
    }

    @Override
    public Size sizeOfBullet() {
        return this.bulletSize;
    }

    @Override
    public void renderBullet(Shapes<? extends EX> shapes, double x, double y) throws EX {
        shapes.arc(Shapes.Style.OUTLINE, x + this.bulletRadius, y + this.bulletRadius, this.bulletRadius, 0.0, 360.0);
    }

    @Override
    public Size sizeOfNothing() {
        return this.arrowSize;
    }

    @Override
    public void renderNothing(Shapes<? extends EX> shapes, double x, double y, boolean forward) throws EX {
        this.arrow(shapes, x, y, forward);
    }

    private void arrow(Shapes<? extends EX> shapes, double x, double y, boolean forward) throws EX {
        double width = this.arrowWidth;
        double height = this.arrowHeight;
        double linePos = height / 2.0;
        double indent = this.arrowIndent * width;
        if (forward) {
            shapes.polygon(Shapes.Style.FILL, ShapeRenderer.point(x + indent, y + linePos), ShapeRenderer.point(x, y), ShapeRenderer.point(x + width, y + linePos), ShapeRenderer.point(x, y + height), ShapeRenderer.point(x + indent, y + linePos));
        } else {
            shapes.polygon(Shapes.Style.FILL, ShapeRenderer.point(x + width - indent, y + linePos), ShapeRenderer.point(x + width, y), ShapeRenderer.point(x, y + linePos), ShapeRenderer.point(x + width, y + height), ShapeRenderer.point(x + width - indent, y + linePos));
        }
    }

    private void line(Shapes<? extends EX> shapes, double x1, double y1, double x2, double y2) throws EX {
        if (x1 != x2 || y1 != y2) {
            shapes.line(Shapes.Style.OUTLINE, x1, y1, x2, y2);
        }
    }

    @Override
    public Size sizeOfText(TextGlyphs text) {
        double margin = this.tokenMargin;
        double hPadding = this.tokenPadding;
        double vPadding = this.tokenPadding;
        double diameter = text.getHeight() + vPadding * 2.0;
        double height = text.getHeight() + vPadding * 2.0 + margin * 2.0;
        double width = text.getWidth() + hPadding * 2.0 + margin * 2.0 + diameter;
        return new Size(width, height, height / 2.0);
    }

    @Override
    public void renderText(Shapes<? extends EX> shapes, double x, double y, TextGlyphs text) throws EX {
        double margin = this.tokenMargin;
        double hPadding = this.tokenPadding;
        double vPadding = this.tokenPadding;
        double width = text.getWidth();
        double height = text.getHeight();
        double diameter = vPadding + height + vPadding;
        shapes.text(text, x + margin + diameter / 2.0 + hPadding, y + margin + vPadding);
        shapes.roundRect(Shapes.Style.OUTLINE, x + margin, y + margin, width + diameter + hPadding * 2.0, height + vPadding * 2.0, diameter);
    }

    @Override
    public Size sizeOfAnyCase(TextGlyphs textGlyphs) {
        return this.sizeOfText(textGlyphs);
    }

    @Override
    public void renderAnyCase(Shapes<? extends EX> shapes, double x, double y, TextGlyphs textGlyphs) throws EX {
        this.renderText(shapes, x, y, textGlyphs);
    }

    @Override
    public Size sizeOfReference(TextGlyphs name) {
        double margin = this.tokenMargin;
        double hPadding = this.tokenPadding + this.nonTerminalPadding;
        double vPadding = this.tokenPadding;
        double height = name.getHeight() + vPadding * 2.0 + margin * 2.0;
        double width = name.getWidth() + hPadding * 2.0 + margin * 2.0;
        return new Size(width, height, height / 2.0);
    }

    @Override
    public void renderReference(Shapes<? extends EX> shapes, double x, double y, String target, TextGlyphs name) throws EX {
        double margin = this.tokenMargin;
        double hPadding = this.tokenPadding + this.nonTerminalPadding;
        double vPadding = this.tokenPadding;
        double width = name.getWidth();
        double height = name.getHeight();
        Shapes.Group<EX> group = shapes.group(this.linker.referenceLink(target));
        group.text(name, x + margin + hPadding, y + margin + vPadding);
        group.rect(Shapes.Style.OUTLINE, x + margin, y + margin, width + hPadding * 2.0, height + vPadding * 2.0);
        group.close();
    }

    @Override
    public Size sizeOfCharset(TextGlyphs textGlyphs) {
        return this.sizeOfText(textGlyphs);
    }

    @Override
    public void renderCharset(Shapes<? extends EX> shapes, double x, double y, TextGlyphs text, String set) throws EX {
        double margin = this.tokenMargin;
        double hPadding = this.tokenPadding;
        double vPadding = this.tokenPadding;
        double width = text.getWidth();
        double height = text.getHeight();
        double radius = (vPadding + height + vPadding) / 2.0;
        Shapes.Group<EX> group = shapes.group(this.linker.charsetLink(set));
        group.text(text, x + margin + radius + hPadding, y + margin + vPadding);
        this.hexagon(group, x + margin, y + margin, radius, width + hPadding * 2.0);
        group.close();
    }

    private void hexagon(Shapes.Group<? extends EX> shapes, double x, double y, double r, double w) throws EX {
        shapes.polygon(Shapes.Style.OUTLINE, ShapeRenderer.point(x, y + r), ShapeRenderer.point(x + r, y), ShapeRenderer.point(x + r + w, y), ShapeRenderer.point(x + r + w + r, y + r), ShapeRenderer.point(x + r + w, y + 2.0 * r), ShapeRenderer.point(x + r, y + 2.0 * r), ShapeRenderer.point(x, y + r));
    }

    @Override
    public Size sizeOfLine(Collection<Diagram.Figure> sequence) {
        double arrowWidth = this.arrowBefore + this.arrowWidth + this.arrowAfter;
        LineSize size = sequence.stream().map(figure -> new LineSize(figure.size(this))).reduce(LineSize::new).orElseThrow(() -> new IllegalStateException("Empty sequence!"));
        return new Size(size.width + (double)(sequence.size() - 1) * arrowWidth, size.hBefore + size.hAfter, size.hBefore);
    }

    @Override
    public void renderLine(Shapes<? extends EX> shapes, double x, double y, Size size, List<Diagram.Figure> sequence, boolean forward) throws EX {
        double arrowBefore = this.arrowBefore;
        double arrowAfter = this.arrowAfter;
        Iterator<Diagram.Figure> figures = sequence.iterator();
        if (!forward) {
            figures = ShapeRenderer.reversed(sequence);
            arrowBefore = arrowAfter;
            arrowAfter = this.arrowBefore;
        }
        double currentX = x;
        while (figures.hasNext()) {
            Diagram.Figure figure = figures.next();
            Size fSize = figure.size(this);
            figure.render(shapes, currentX, y + size.linePosition - fSize.linePosition, this, forward);
            currentX += fSize.width;
            if (!figures.hasNext()) continue;
            this.line(shapes, currentX, y + size.linePosition, currentX + arrowBefore + this.arrowIndent * this.arrowWidth, y + size.linePosition);
            this.arrow(shapes, currentX += arrowBefore, y + size.linePosition - this.arrowHeight / 2.0, forward);
            this.line(shapes, currentX += this.arrowWidth, y + size.linePosition, currentX + arrowAfter, y + size.linePosition);
            currentX += arrowAfter;
        }
    }

    private static Iterator<Diagram.Figure> reversed(final List<Diagram.Figure> sequence) {
        return new Iterator<Diagram.Figure>(){
            int i;
            {
                this.i = sequence.size();
            }

            @Override
            public boolean hasNext() {
                return this.i > 0;
            }

            @Override
            public Diagram.Figure next() {
                return (Diagram.Figure)sequence.get(--this.i);
            }
        };
    }

    @Override
    public Size sizeOfBranch(Collection<Diagram.Figure> branches) {
        Size size = branches.stream().map(figure -> figure.size(this)).reduce((l, r) -> new Size(Math.max(l.width, r.width), l.height + r.height + this.branchSpacing, l.linePosition)).orElseThrow(() -> new IllegalStateException("Empty branch"));
        return new Size(this.branchRadius * 4.0 + this.branchBefore + size.width + this.branchAfter + this.arrowWidth * 2.0, size.height, size.linePosition);
    }

    @Override
    public void renderBranch(Shapes<? extends EX> shapes, double x, double y, Size size, Collection<Diagram.Figure> branches, boolean forward) throws EX {
        double maxWidth = size.width - (this.branchRadius * 4.0 + this.branchBefore + this.branchAfter + this.arrowWidth * 2.0);
        double centerX = x + maxWidth / 2.0;
        double before = this.branchBefore;
        double after = this.branchAfter;
        double radius = this.branchRadius;
        double spacing = this.branchSpacing;
        if (!forward) {
            before = after;
            after = this.branchBefore;
        }
        double currentY = y;
        double lineEndY = y;
        boolean first = true;
        Iterator<Diagram.Figure> figures = branches.iterator();
        while (figures.hasNext()) {
            boolean drawArrows;
            Diagram.Figure figure = figures.next();
            Size fSize = figure.size(this);
            boolean bl = drawArrows = !figure.isNothing();
            if (!first) {
                shapes.arc(Shapes.Style.OUTLINE, x + 2.0 * radius, currentY + fSize.linePosition - radius, radius, 180.0, 90.0);
            }
            if (drawArrows) {
                this.arrow(shapes, x + radius * 2.0, currentY + fSize.linePosition - this.arrowHeight / 2.0, forward);
            } else {
                this.line(shapes, x + radius * 2.0, currentY + fSize.linePosition, x + radius * 2.0 + this.arrowWidth, currentY + fSize.linePosition);
            }
            this.line(shapes, x + radius * 2.0 + this.arrowWidth, currentY + fSize.linePosition, x + radius * 2.0 + this.arrowWidth + before, currentY + fSize.linePosition);
            double left = x + radius * 2.0 + this.arrowWidth + before;
            double figureX = centerX - fSize.width / 2.0 + radius * 2.0 + this.arrowWidth + before;
            this.line(shapes, left, currentY + fSize.linePosition, figureX, currentY + fSize.linePosition);
            figure.render(shapes, figureX, currentY, this, forward);
            this.line(shapes, figureX + fSize.width, currentY + fSize.linePosition, left + maxWidth + after, currentY + fSize.linePosition);
            if (drawArrows) {
                this.arrow(shapes, left + maxWidth + after, currentY + fSize.linePosition - this.arrowHeight / 2.0, forward);
            } else {
                this.line(shapes, left + maxWidth + after, currentY + fSize.linePosition, left + maxWidth + after + this.arrowWidth, currentY + fSize.linePosition);
            }
            if (!first) {
                shapes.arc(Shapes.Style.OUTLINE, left + maxWidth + after + this.arrowWidth, currentY + fSize.linePosition - radius, radius, 270.0, 90.0);
            }
            if (!figures.hasNext()) {
                lineEndY = currentY + fSize.linePosition - radius;
            }
            currentY += spacing + fSize.height;
            first = false;
        }
        shapes.arc(Shapes.Style.OUTLINE, x, y + size.linePosition + radius, radius, 0.0, 90.0);
        this.line(shapes, x + radius, y + size.linePosition + radius, x + radius, lineEndY);
        this.line(shapes, x, y + size.linePosition, x + radius * 2.0, y + size.linePosition);
        double endX = x + radius * 2.0 + this.arrowWidth + before + maxWidth + after + this.arrowWidth;
        this.line(shapes, endX, y + size.linePosition, endX + radius * 2.0, y + size.linePosition);
        shapes.arc(Shapes.Style.OUTLINE, endX + 2.0 * radius, y + size.linePosition + radius, radius, 90.0, 90.0);
        this.line(shapes, endX + radius, y + size.linePosition + radius, endX + radius, lineEndY);
    }

    @Override
    public Size sizeOfLoop(Diagram.Figure forward, Diagram.Figure backward, TextGlyphs description) {
        Size fSize = forward.size(this);
        Size bSize = backward.size(this);
        double width = Math.max(fSize.width, bSize.width);
        double height = fSize.height + this.loopSpacing + bSize.height;
        if (description != null) {
            width = Math.max(width, description.getWidth() + this.loopDescriptionMargin);
            height += description.getHeight() + this.loopSpacing;
        }
        width = this.loopRadius * 2.0 + this.arrowWidth + this.loopBefore + width + this.loopAfter + this.arrowWidth + this.loopRadius * 2.0;
        double linePos = fSize.linePosition;
        return new Size(width, height, linePos);
    }

    @Override
    public void renderLoop(Shapes<? extends EX> shapes, double x, double y, Size size, Diagram.Figure forward, Diagram.Figure backward, TextGlyphs description, boolean fwd) throws EX {
        Size fSize = forward.size(this);
        Size bSize = backward.size(this);
        boolean fArrow = !forward.isNothing();
        boolean bArrow = !backward.isNothing();
        double spacing = this.loopSpacing;
        double radius = this.loopRadius;
        double before = this.loopBefore;
        double dY = y + fSize.height + spacing;
        double width = size.width;
        double linePos = size.linePosition;
        double maxWidth = Math.max(fSize.width, bSize.width);
        if (description != null) {
            dY += description.getHeight() + spacing;
            maxWidth = Math.max(maxWidth, description.getWidth() + this.loopDescriptionMargin);
        }
        double centerX = x + radius * 2.0 + this.arrowWidth + before + maxWidth / 2.0;
        this.line(shapes, x, y + linePos, x + radius * 2.0, y + linePos);
        this.arrowOrLine(shapes, x + radius * 2.0, y + linePos - this.arrowHeight / 2.0, this.arrowWidth, this.arrowHeight, fwd, fArrow);
        this.line(shapes, x + radius * 2.0 + this.arrowWidth, y + linePos, centerX - fSize.width / 2.0, y + linePos);
        forward.render(shapes, centerX - fSize.width / 2.0, y, this, fwd);
        this.line(shapes, centerX + fSize.width / 2.0, y + linePos, x + width - radius * 2.0 - this.arrowWidth, y + linePos);
        this.arrowOrLine(shapes, x + width - radius * 2.0 - this.arrowWidth, y + linePos - this.arrowHeight / 2.0, this.arrowWidth, this.arrowHeight, fwd, fArrow);
        this.line(shapes, x + width - radius * 2.0, y + linePos, x + width, y + linePos);
        shapes.arc(Shapes.Style.OUTLINE, x + 2.0 * radius, y + linePos + radius, radius, 90.0, 90.0);
        this.line(shapes, x + radius, y + linePos + radius, x + radius, dY + bSize.linePosition - radius);
        shapes.arc(Shapes.Style.OUTLINE, x + 2.0 * radius, dY + bSize.linePosition - radius, radius, 180.0, 90.0);
        this.arrowOrLine(shapes, x + radius * 2.0, dY + bSize.linePosition - this.arrowHeight / 2.0, this.arrowWidth, this.arrowHeight, !fwd, bArrow);
        this.line(shapes, x + radius * 2.0 + this.arrowWidth, dY + bSize.linePosition, centerX - bSize.width / 2.0, dY + bSize.linePosition);
        backward.render(shapes, centerX - bSize.width / 2.0, dY, this, !fwd);
        this.line(shapes, centerX + bSize.width / 2.0, dY + bSize.linePosition, x + width - radius * 2.0 - this.arrowWidth, dY + bSize.linePosition);
        this.arrowOrLine(shapes, x + width - radius * 2.0 - this.arrowWidth, dY + bSize.linePosition - this.arrowHeight / 2.0, this.arrowWidth, this.arrowHeight, !fwd, bArrow);
        shapes.arc(Shapes.Style.OUTLINE, x + width - radius * 2.0, dY + bSize.linePosition - radius, radius, 270.0, 90.0);
        this.line(shapes, x + width - radius, dY + bSize.linePosition - radius, x + width - radius, y + linePos + radius);
        shapes.arc(Shapes.Style.OUTLINE, x + width - radius * 2.0, y + linePos + radius, radius, 0.0, 90.0);
        if (description != null) {
            shapes.text(description, x + width - description.getWidth() - radius - this.loopDescriptionMargin, y + fSize.height + spacing);
        }
    }

    private void arrowOrLine(Shapes<? extends EX> shapes, double x, double y, double width, double height, boolean forward, boolean arrow) throws EX {
        if (arrow) {
            this.arrow(shapes, x, y, forward);
        } else {
            this.line(shapes, x, y + height / 2.0, x + width, y + height / 2.0);
        }
    }

    private static class LineSize {
        double width;
        double hBefore;
        double hAfter;

        LineSize(Size size) {
            this.width = size.width;
            this.hBefore = size.linePosition;
            this.hAfter = size.height - size.linePosition;
        }

        LineSize(LineSize l, LineSize r) {
            this.width = l.width + r.width;
            this.hBefore = Math.max(l.hBefore, r.hBefore);
            this.hAfter = Math.max(l.hAfter, r.hAfter);
        }
    }

    public static interface Shapes<EX extends Exception> {
        default public void begin() throws EX {
        }

        public void roundRect(Style var1, double var2, double var4, double var6, double var8, double var10) throws EX;

        public void rect(Style var1, double var2, double var4, double var6, double var8) throws EX;

        public void arc(Style var1, double var2, double var4, double var6, double var8, double var10) throws EX;

        default public void line(Style style, double x1, double y1, double x2, double y2) throws EX {
            try (Path<EX> path = this.path(style);){
                path.moveTo(x1, y1);
                path.lineTo(x2, y2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        default public void polygon(Style style, Point ... points) throws EX {
            Path<EX> path;
            block16: {
                switch (points.length) {
                    case 0: 
                    case 1: {
                        return;
                    }
                    case 2: {
                        this.line(style, points[0].x, points[0].y, points[1].x, points[1].y);
                        return;
                    }
                }
                path = this.path(style);
                Throwable throwable = null;
                try {
                    for (int i = 0; i < points.length; ++i) {
                        Point point = points[i];
                        if (i == 0) {
                            path.moveTo(point.x, point.y);
                            continue;
                        }
                        if (i == points.length - 1 && points[0].equals(point)) {
                            path.closePath();
                            continue;
                        }
                        path.lineTo(point.x, point.y);
                    }
                    if (path == null) return;
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (path == null) throw throwable3;
                        if (throwable == null) {
                            path.close();
                            throw throwable3;
                        }
                        try {
                            path.close();
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                            throw throwable3;
                        }
                    }
                }
                try {
                    path.close();
                    return;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    return;
                }
            }
            path.close();
        }

        public void text(TextGlyphs var1, double var2, double var4) throws EX;

        public Path<EX> path(Style var1);

        default public void end() throws EX {
        }

        default public Group<EX> group(String link) throws EX {
            return new Group<EX>(){

                @Override
                public void roundRect(Style style, double x, double y, double width, double height, double diameter) throws Exception {
                    this.roundRect(style, x, y, width, height, diameter);
                }

                @Override
                public void rect(Style style, double x, double y, double width, double height) throws Exception {
                    this.rect(style, x, y, width, height);
                }

                @Override
                public void arc(Style style, double cx, double cy, double radius, double start, double extent) throws Exception {
                    this.arc(style, cx, cy, radius, start, extent);
                }

                @Override
                public void text(TextGlyphs text, double x, double y) throws Exception {
                    this.text(text, x, y);
                }

                @Override
                public Path<EX> path(Style style) {
                    return this.path(style);
                }

                @Override
                public void close() {
                }
            };
        }

        public static final class Style {
            public static final Style FILL = new Style(true, false);
            public static final Style OUTLINE = new Style(false, true);
            final boolean fill;
            final boolean stroke;

            private Style(boolean fill, boolean stroke) {
                this.fill = fill;
                this.stroke = stroke;
            }
        }

        public static final class Point {
            public final double x;
            public final double y;

            private Point(double x, double y) {
                this.x = x;
                this.y = y;
            }

            public String toString() {
                return String.format("Point{x=%s, y=%s}", this.x, this.y);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Point point = (Point)o;
                return Double.compare(point.x, this.x) == 0 && Double.compare(point.y, this.y) == 0;
            }

            public int hashCode() {
                return Objects.hash(this.x, this.y);
            }
        }

        public static interface Path<EX extends Exception>
        extends AutoCloseable {
            public void arc(double var1, double var3, double var5, boolean var7, boolean var8, double var9, double var11);

            public void closePath();

            public void moveTo(double var1, double var3);

            public void lineTo(double var1, double var3);

            public void quadTo(double var1, double var3, double var5, double var7);

            public void cubicTo(double var1, double var3, double var5, double var7, double var9, double var11);

            @Override
            public void close() throws EX;
        }

        public static interface Group<EX extends Exception>
        extends AutoCloseable {
            public void roundRect(Style var1, double var2, double var4, double var6, double var8, double var10) throws EX;

            public void rect(Style var1, double var2, double var4, double var6, double var8) throws EX;

            public void arc(Style var1, double var2, double var4, double var6, double var8, double var10) throws EX;

            default public void line(Style style, double x1, double y1, double x2, double y2) throws EX {
                try (Path<EX> path = this.path(style);){
                    path.moveTo(x1, y1);
                    path.lineTo(x2, y2);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            default public void polygon(Style style, Point ... points) throws EX {
                Path<EX> path;
                block16: {
                    switch (points.length) {
                        case 0: 
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.line(style, points[0].x, points[0].y, points[1].x, points[1].y);
                            return;
                        }
                    }
                    path = this.path(style);
                    Throwable throwable = null;
                    try {
                        for (int i = 0; i < points.length; ++i) {
                            Point point = points[i];
                            if (i == 0) {
                                path.moveTo(point.x, point.y);
                                continue;
                            }
                            if (i == points.length - 1 && points[0].equals(point)) {
                                path.closePath();
                                continue;
                            }
                            path.lineTo(point.x, point.y);
                        }
                        if (path == null) return;
                        if (throwable == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (path == null) throw throwable3;
                            if (throwable == null) {
                                path.close();
                                throw throwable3;
                            }
                            try {
                                path.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        path.close();
                        return;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        return;
                    }
                }
                path.close();
            }

            public void text(TextGlyphs var1, double var2, double var4) throws EX;

            public Path<EX> path(Style var1);

            @Override
            public void close() throws EX;
        }
    }

    public static interface Linker {
        public String referenceLink(String var1);

        default public String charsetLink(String charset) {
            return null;
        }
    }

    public static interface Options {
        default public Font productionFont() {
            return this.plainFont();
        }

        default public Font textFont() {
            return this.boldFont();
        }

        default public Font anyCaseFont() {
            return this.plainFont();
        }

        default public Font charsetFont() {
            return this.plainFont();
        }

        default public Font loopDescriptionFont() {
            return this.italicFont();
        }

        default public Font plainFont() {
            return new Font("Verdana", 0, 10);
        }

        default public Font boldFont() {
            return new Font("Verdana", 1, 10);
        }

        default public Font italicFont() {
            return new Font("Verdana", 2, 10);
        }

        default public double diagramMargin() {
            return 8.0;
        }

        default public double bulletRadius() {
            return 2.5;
        }

        default public double arrowWidth() {
            return 9.0;
        }

        default public double arrowHeight() {
            return 7.0;
        }

        default public double arrowIndent() {
            return 0.3333333333333333;
        }

        default public double arrowBefore() {
            return 8.0;
        }

        default public double arrowAfter() {
            return 0.0;
        }

        default public double tokenMargin() {
            return 1.0;
        }

        default public double tokenPadding() {
            return 1.0;
        }

        default public double nonTerminalPadding() {
            return 12.0;
        }

        default public double branchSpacing() {
            return 8.0;
        }

        default public double branchRadius() {
            return 7.0;
        }

        default public double branchBefore() {
            return 0.0;
        }

        default public double branchAfter() {
            return 4.0;
        }

        default public double loopSpacing() {
            return 8.0;
        }

        default public double loopRadius() {
            return 7.0;
        }

        default public double loopBefore() {
            return 6.0;
        }

        default public double loopAfter() {
            return 6.0;
        }

        default public double loopDescriptionMargin() {
            return 2.0;
        }
    }
}

