/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.BiFunction;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.Reflection;

interface Main
extends Serializable {
    public static void main(String ... args) throws Throwable {
        if (args == null || args.length < 1) {
            String path = Reflection.pathOf(Main.class);
            if (new File(path).isFile() && path.endsWith(".jar")) {
                System.err.printf("USAGE: java -jar %s <tool> ...%n", path);
            } else {
                System.err.printf("USAGE: java -cp %s %s <tool> ...%n", path, Main.class.getName());
            }
            System.exit(1);
        } else {
            Method main;
            try {
                Class<?> cls = Class.forName(Main.class.getPackage().getName() + '.' + args[0]);
                main = cls.getDeclaredMethod("main", String[].class);
                if (!Modifier.isStatic(main.getModifiers()) || "Main".equals(args[0])) {
                    throw new IllegalArgumentException(args[0]);
                }
            }
            catch (Exception e) {
                System.err.println("Unknown formatter: " + args[0]);
                throw e;
            }
            try {
                main.invoke(null, new Object[]{Arrays.copyOfRange(args, 1, args.length)});
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    public void write(Grammar var1, OutputStream var2) throws Exception;

    public static void execute(Main program, OutputStream out, String ... args) throws Exception {
        if (args.length == 1) {
            URL resource;
            Grammar.ParserOption[] options = Grammar.ParserOption.from(System.getProperties());
            Grammar grammar = null;
            String path = args[0];
            if (path.indexOf(47) == -1 && (resource = program.getClass().getResource("/" + path)) != null) {
                URI uri = resource.toURI();
                try (FileSystem ignored = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                    grammar = Grammar.parseXML(Paths.get(uri), options);
                }
            }
            if (grammar == null) {
                grammar = Grammar.parseXML(Paths.get(path, new String[0]), options);
            }
            program.write(grammar, out);
        } else {
            System.err.println(program.usage((cp, cls) -> String.format("USAGE: java -cp %s %s <grammar.xml>%n", cp, cls)));
            System.exit(1);
        }
    }

    public static void execute(Main program, String ... args) throws Exception {
        Main.execute(program, System.out, args);
    }

    default public String usage(BiFunction<String, String, String> usage) {
        Class<?> implClass = Reflection.lambdaClass(this);
        return usage.apply(Reflection.pathOf(implClass), implClass.getName());
    }
}

