/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.opencypher.generator.Choices;
import org.opencypher.generator.Node;
import org.opencypher.generator.ProductionReplacement;
import org.opencypher.grammar.Alternatives;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Literal;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Optional;
import org.opencypher.grammar.Production;
import org.opencypher.grammar.ProductionTransformation;
import org.opencypher.grammar.Repetition;
import org.opencypher.grammar.Sequence;
import org.opencypher.grammar.TermTransformation;

class TreeBuilder<T>
implements TermTransformation<State<T>, State<T>, RuntimeException>,
ProductionTransformation<Void, State<T>, RuntimeException> {
    private final Choices choice;
    private final Supplier<T> context;
    private final Map<String, ProductionReplacement<T>> replacements;

    TreeBuilder(Choices choice, Supplier<T> context, Map<String, ProductionReplacement<T>> replacements) {
        this.choice = choice;
        this.context = context;
        this.replacements = replacements;
    }

    Node buildTree(State<T> root) {
        for (State<T> state = root; state != null; state = state.generate(this)) {
        }
        return ((State)root).node;
    }

    @Override
    public State<T> transformProduction(Void param, Production production) {
        return TreeBuilder.state(production.definition(), Node.root(production.name()), this.context.get());
    }

    static <T> State<T> state(Grammar.Term term, Node.Tree root, T context) {
        return new State(root, term, context, null);
    }

    @Override
    public State<T> transformAlternatives(State<T> current, Alternatives alternatives) {
        return new State(((State)current).node, this.choice.choose(((State)current).node, alternatives.eligibleForGeneration()), ((State)current).context, ((State)current).next());
    }

    @Override
    public State<T> transformSequence(State<T> current, Sequence sequence) {
        return TreeBuilder.sequence(((State)current).node, sequence.iterator(), ((State)current).context, ((State)current).next());
    }

    @Override
    public State<T> transformLiteral(State<T> current, Literal value) {
        ((State)current).node.literal(value);
        return ((State)current).next();
    }

    @Override
    public State<T> transformNonTerminal(State<T> current, NonTerminal nonTerminal) {
        ProductionReplacement<T> replacement = this.replacements.get(nonTerminal.productionName());
        if (replacement != null) {
            ((State)current).node.production(nonTerminal.productionName(), replacement, ((State)current).context, node -> this.buildTree(new State((Node.Tree)node, nonTerminal.productionDefinition(), ((State)current).context, null)));
            return ((State)current).next();
        }
        return new State(((State)current).node.child(nonTerminal.productionName()), nonTerminal.productionDefinition(), ((State)current).context, ((State)current).next());
    }

    @Override
    public State<T> transformOptional(State<T> current, Optional optional) {
        int times = this.choice.includeOptional(((State)current).node, optional) ? 1 : 0;
        return TreeBuilder.repeat(((State)current).node, times, optional.term(), ((State)current).context, ((State)current).next());
    }

    @Override
    public State<T> transformRepetition(State<T> current, Repetition repetition) {
        return TreeBuilder.repeat(((State)current).node, this.choice.repetition(((State)current).node, repetition), repetition.term(), ((State)current).context, ((State)current).next());
    }

    @Override
    public State<T> transformEpsilon(State<T> current) {
        return ((State)current).next();
    }

    @Override
    public State<T> transformCharacters(State<T> current, CharacterSet characters) {
        return this.codePoint(current, this.choice.codePoint(((State)current).node, characters));
    }

    private State<T> codePoint(State<T> current, int cp) {
        ((State)current).node.codePoint(cp);
        return ((State)current).next();
    }

    private static <T> State<T> sequence(Node.Tree node, Iterator<Grammar.Term> sequence, T context, State<T> next) {
        return new StateSequence<T>(sequence, node, context, next).get();
    }

    private static <T> State<T> repeat(Node.Tree node, int times, Grammar.Term term, T context, State<T> next) {
        return new StateRepetition<T>(node, times, term, context, next).get();
    }

    private static class StateRepetition<T>
    implements Supplier<State<T>> {
        private final Node.Tree node;
        private final Grammar.Term term;
        private final T context;
        private final State next;
        private int count;

        StateRepetition(Node.Tree node, int times, Grammar.Term term, T context, State<T> next) {
            this.node = node;
            this.count = times;
            this.term = term;
            this.context = context;
            this.next = next;
        }

        @Override
        public State<T> get() {
            return this.count-- > 0 ? new State(this.node, this.term, this.context, this) : this.next;
        }
    }

    private static class StateSequence<T>
    implements Supplier<State<T>> {
        private final Iterator<Grammar.Term> sequence;
        private final Node.Tree node;
        private final T context;
        private final State next;

        StateSequence(Iterator<Grammar.Term> sequence, Node.Tree node, T context, State<T> next) {
            this.sequence = sequence;
            this.node = node;
            this.context = context;
            this.next = next;
        }

        @Override
        public State<T> get() {
            return this.sequence.hasNext() ? new State(this.node, this.sequence.next(), this.context, this) : this.next;
        }
    }

    static final class State<T>
    implements Supplier<State<T>> {
        private final Node.Tree node;
        private final Grammar.Term term;
        private final T context;
        private final Supplier<State<T>> next;

        private State(Node.Tree node, Grammar.Term term, T context, Supplier<State<T>> next) {
            this.node = node;
            this.term = term;
            this.context = context;
            this.next = next == null ? () -> null : next;
        }

        public String toString() {
            return "TreeBuilder.State{" + this.node + " @ " + this.term + "}";
        }

        private State<T> next() {
            return this.next.get();
        }

        State<T> generate(TreeBuilder<T> builder) {
            return (State)this.term.transform(builder, this);
        }

        @Override
        public State<T> get() {
            return this;
        }
    }
}

