/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.xml;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.opencypher.tools.xml.Reference;
import org.opencypher.tools.xml.Resolver;

final class AttributeHandler {
    final String uri;
    final String name;
    final boolean optional;
    private final MethodHandle setter;
    private static final Map<Class<?>, Function<MethodHandle, MethodHandle>> CONVERSION = new ConcurrentHashMap();
    private static final MethodHandle ENUM_VALUE_OF = Reference.biFunction(Enum::valueOf).mh();
    private static final MethodHandle UPPER_STRING = Reference.function(String::toUpperCase).mh();

    AttributeHandler(String uri, String name, boolean optional, MethodHandle setter) {
        this.uri = uri;
        this.name = name;
        this.optional = optional;
        this.setter = setter;
    }

    public String toString() {
        return String.format("%sAttribute{uri='%s', name='%s'}", this.optional ? "Optional" : "", this.uri, this.name);
    }

    public boolean matches(String uri, String name) {
        return this.uri.equalsIgnoreCase(uri) && this.name.equalsIgnoreCase(name);
    }

    public void apply(Object target, Resolver resolver, String value) {
        try {
            this.setter.invokeWithArguments(target, resolver, value);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static MethodHandle conversion(Class<?> type, MethodHandle setter) {
        return (MethodHandle)CONVERSION.computeIfAbsent(type, AttributeHandler::conversion).apply(setter);
    }

    private static Function<MethodHandle, MethodHandle> conversion(Reference reference) {
        MethodHandle filter = reference.mh();
        return AttributeHandler.conversion(filter);
    }

    private static Function<MethodHandle, MethodHandle> conversion(Class<?> type) {
        if (type.isEnum()) {
            return AttributeHandler.enumConversion(type);
        }
        throw new IllegalArgumentException("Unsupported field type: " + type);
    }

    private static Function<MethodHandle, MethodHandle> enumConversion(Class<?> enumType) {
        return AttributeHandler.conversion(MethodHandles.explicitCastArguments(MethodHandles.filterArguments(ENUM_VALUE_OF.bindTo(enumType), 0, UPPER_STRING), MethodType.methodType(enumType, String.class)));
    }

    private static Function<MethodHandle, MethodHandle> conversion(MethodHandle filter) {
        return mh -> MethodHandles.dropArguments(MethodHandles.filterArguments(mh, 1, filter), 1, new Class[]{Resolver.class});
    }

    static {
        CONVERSION.put(String.class, mh -> MethodHandles.dropArguments(mh, 1, new Class[]{Resolver.class}));
        CONVERSION.put(Integer.TYPE, AttributeHandler.conversion(Reference.toInt(Integer::parseInt)));
        CONVERSION.put(Integer.class, AttributeHandler.conversion(Reference.function(Integer::valueOf)));
        CONVERSION.put(Boolean.TYPE, AttributeHandler.conversion(Reference.toBool(Boolean::parseBoolean)));
        CONVERSION.put(Boolean.class, AttributeHandler.conversion(Reference.function(Boolean::valueOf)));
        CONVERSION.put(Long.TYPE, AttributeHandler.conversion(Reference.toLong(Long::parseLong)));
        CONVERSION.put(Long.class, AttributeHandler.conversion(Reference.function(Long::valueOf)));
        CONVERSION.put(Double.TYPE, AttributeHandler.conversion(Reference.toDouble(Double::parseDouble)));
        CONVERSION.put(Double.class, AttributeHandler.conversion(Reference.function(Double::valueOf)));
        Resolver.initialize(CONVERSION::put);
    }
}

