/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opencypher.tools.xml.LocationAware;
import org.opencypher.tools.xml.NodeBuilder;
import org.opencypher.tools.xml.Resolver;
import org.opencypher.tools.xml.XmlParser;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

class ParserStateMachine
extends DefaultHandler2 {
    private final Resolver resolver;
    private final Set<XmlParser.Option> options;
    private Node node;
    private Map<String, String> prefixToUri;
    private Map<String, String> uriToPrefix;
    private Locator locator;

    ParserStateMachine(Resolver resolver, NodeBuilder builder, Set<XmlParser.Option> options) {
        this.resolver = resolver;
        this.options = options;
        this.node = new BaseNode(builder);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Object produceRoot() {
        return this.node.value;
    }

    @Override
    public void startDocument() throws SAXException {
        this.prefixToUri = new HashMap<String, String>();
        this.uriToPrefix = new HashMap<String, String>();
    }

    @Override
    public void endDocument() throws SAXException {
        this.uriToPrefix = null;
        this.prefixToUri = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixToUri.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        String uri = this.prefixToUri.remove(prefix);
        if (uri == null) {
            throw new SAXParseException("prefix not mapped: " + prefix, this.locator);
        }
        String removed = this.uriToPrefix.remove(uri);
        if (!prefix.equals(removed)) {
            throw new SAXParseException("uri not mapped: " + uri, this.locator);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            this.node = this.node.child(uri, localName, this.locator);
            BitSet required = this.node.builder.requiredAttributes();
            int len = attributes.getLength();
            for (int i = 0; i < len; ++i) {
                this.attribute(required, attributes.getURI(i), attributes.getLocalName(i), attributes.getType(i), attributes.getValue(i));
            }
            this.node.builder.verifyRequiredAttributes(required);
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.locator, e);
        }
    }

    private void attribute(BitSet required, String uri, String name, String type, String value) throws SAXException {
        if (uri.isEmpty()) {
            uri = this.prefixToUri.get("");
        }
        if (!this.node.builder.attribute(required, this.node.value, this.resolver, uri, name, type, value) && this.options.contains((Object)XmlParser.Option.FAIL_ON_UNKNOWN_ATTRIBUTE)) {
            throw new SAXException("Unknown attribute: " + name + " in namespace " + uri);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.node = this.node.pop();
        }
        catch (Exception e2) {
            SAXException e2;
            if (e2.getClass() == RuntimeException.class && e2.getCause() instanceof SAXException) {
                e2 = (SAXException)e2.getCause();
            }
            throw new SAXParseException(((Throwable)e2).getMessage(), this.locator, e2);
        }
    }

    @Override
    public void characters(char[] buffer, int start, int length) throws SAXException {
        try {
            this.node.builder.characters(this.node.value, buffer, start, length);
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.locator, e);
        }
    }

    @Override
    public void comment(char[] buffer, int start, int length) throws SAXException {
        this.node.comment(buffer, start, length);
    }

    private static class RootNode
    extends Node {
        RootNode(NodeBuilder builder, Object value) {
            super(null, builder, value);
        }

        @Override
        Node pop() {
            return this;
        }
    }

    private static class BaseNode
    extends Node {
        private Object headers;

        BaseNode(NodeBuilder builder) {
            super(null, builder, null);
        }

        @Override
        Node child(String uri, String name, Locator locator) throws SAXException {
            if (!this.builder.uri.equalsIgnoreCase(uri) || !this.builder.name.equalsIgnoreCase(name)) {
                throw new SAXException("Root element must be '" + this.builder.name + "' in namespace '" + this.builder.uri + "', but was '" + name + "' in namespace '" + uri + "'");
            }
            Object value = this.builder.create(null);
            if (this.headers instanceof char[]) {
                this.builder.header(value, (char[])this.headers);
            } else if (this.headers instanceof List) {
                List comments = (List)this.headers;
                for (char[] comment : comments) {
                    this.builder.header(value, comment);
                }
            }
            return new RootNode(this.builder, value);
        }

        @Override
        void comment(char[] buffer, int start, int length) {
            if (this.headers == null) {
                this.headers = Arrays.copyOfRange(buffer, start, start + length);
            } else if (this.headers instanceof char[]) {
                ArrayList<char[]> list = new ArrayList<char[]>(2);
                list.add((char[])this.headers);
                list.add(Arrays.copyOfRange(buffer, start, start + length));
                this.headers = list;
            } else {
                List list = (List)this.headers;
                list.add(Arrays.copyOfRange(buffer, start, start + length));
            }
        }

        @Override
        Node pop() {
            throw new UnsupportedOperationException("should never be called");
        }
    }

    private static class Node {
        final Node parent;
        final NodeBuilder builder;
        final Object value;

        Node(Node parent, NodeBuilder builder, Object value) {
            this.parent = parent;
            this.builder = builder;
            this.value = value;
        }

        Node child(String uri, String name, Locator locator) throws SAXException {
            NodeBuilder child = this.builder.child(uri, name);
            if (child == null) {
                throw new SAXException("element '" + name + "' in namespace '" + uri + "' is not a valid child of element '" + this.builder.name + "' in namespace '" + this.builder.uri + "'");
            }
            Object value = child.create(this.value);
            if (value instanceof LocationAware) {
                ((LocationAware)value).location(locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber());
            }
            return new Node(this, child, value);
        }

        void add(Node child) {
            child.builder.child(this.value, child.value);
        }

        Node pop() {
            if (this.parent != null) {
                this.parent.add(this);
            }
            return this.parent;
        }

        void comment(char[] buffer, int start, int length) {
            this.builder.comment(this.value, buffer, start, length);
        }
    }
}

