/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.Reader;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.opencypher.grammar.Fixture;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.ProductionVisitor;
import org.opencypher.tools.grammar.Xml;
import org.opencypher.tools.io.Output;

public class XmlTest {
    @Rule
    public final Fixture fixture = new Fixture();

    @Test
    public void shouldProduceSameGrammarWhenParsingOutput() throws Exception {
        this.testRoundTrip(this.fixture.grammarResource("/somegrammar.xml", new Grammar.ParserOption[0]));
    }

    @Test
    public void shouldProduceLiteral() throws TransformerException {
        StringBuilder builder = new StringBuilder();
        Output.Readable output = Output.output((StringBuilder)builder);
        Grammar build = Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("bar", Grammar.literal((String)"literal"), new Grammar.Term[0]).build(new Grammar.Builder.Option[]{Grammar.Builder.Option.ALLOW_ROOTLESS});
        Xml.write((Grammar)build, (Output)output);
        MatcherAssert.assertThat((Object)builder.toString(), (Matcher)Matchers.containsString((String)"case-sensitive=\"true\""));
    }

    @Test
    public void shouldProduceCaseInsensitive() throws TransformerException {
        StringBuilder builder = new StringBuilder();
        Output.Readable output = Output.output((StringBuilder)builder);
        Grammar build = Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("bar", Grammar.caseInsensitive((String)"literal"), new Grammar.Term[0]).build(new Grammar.Builder.Option[]{Grammar.Builder.Option.ALLOW_ROOTLESS});
        Xml.write((Grammar)build, (Output)output);
        MatcherAssert.assertThat((Object)builder.toString(), (Matcher)Matchers.containsString((String)"case-sensitive=\"false\""));
    }

    @Test
    public void shouldGenerateCypher() throws Exception {
        Output.Readable out = Output.stringBuilder();
        Grammar first = this.fixture.grammarResource("/cypher.xml", new Grammar.ParserOption[0]);
        Xml.write((Grammar)first, (Output)out);
        this.testRoundTrip(Grammar.parseXML((Reader)out.reader(), (Grammar.ParserOption[])new Grammar.ParserOption[0]));
    }

    private void testRoundTrip(Grammar grammar) throws Exception {
        Output.Readable out = Output.stringBuilder();
        Xml.write((Grammar)grammar, (Output)out);
        try {
            Grammar second = Grammar.parseXML((Reader)out.reader(), (Grammar.ParserOption[])new Grammar.ParserOption[0]);
            XmlTest.assertGrammarEquals(grammar, second);
        }
        catch (Throwable e) {
            Output.lineNumbers((Output)Output.stdOut()).append((CharSequence)out);
            throw e;
        }
    }

    static void assertGrammarEquals(Grammar expected, Grammar actual) {
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (Throwable e) {
            HashMap before = new HashMap();
            expected.accept(ProductionVisitor.production(before::put));
            actual.accept(ProductionVisitor.production((name, def) -> {
                try {
                    Assert.assertEquals(before.get(name), (Object)def);
                }
                catch (Throwable x) {
                    e.addSuppressed(x);
                }
            }));
            throw e;
        }
    }
}

