/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools;

import java.util.Objects;

public final class TypedArgument {
    private final Class<?> type;
    private final Object value;

    public static TypedArgument typed(Class<?> type, Object value) {
        type = Objects.requireNonNull(type, "type");
        if (value != null && !type.isInstance(value)) {
            throw new IllegalArgumentException(value + " (a " + value.getClass().getName() + ") is not an instance of " + type.getName());
        }
        return new TypedArgument(type, value);
    }

    private TypedArgument(Class<?> type, Object value) {
        this.type = type;
        this.value = value;
    }

    public static Class<?>[] types(TypedArgument ... arguments) {
        Class[] types = new Class[arguments.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = arguments[i].type;
        }
        return types;
    }

    public static Object[] values(TypedArgument ... arguments) {
        Object[] values = new Object[arguments.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = arguments[i].value;
        }
        return values;
    }
}

