/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.util.function.Function;
import org.junit.Assert;
import org.opencypher.generator.Choices;
import org.opencypher.generator.ChoicesFixture;
import org.opencypher.generator.Generator;
import org.opencypher.generator.ProductionReplacement;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.io.Output;

public class GeneratorFixture {
    private Object state = new ChoicesFixture();

    public static void assertGenerates(Grammar.Builder grammar, String expected) {
        GeneratorFixture.assertGenerates(grammar.build(new Grammar.Builder.Option[0]), expected);
    }

    public static void assertGenerates(Grammar grammar, String expected) {
        GeneratorFixture.assertGenerates(grammar, x -> expected);
    }

    @SafeVarargs
    public static void assertGenerates(Grammar.Builder grammar, Function<GeneratorFixture, String> ... conditions) {
        GeneratorFixture.assertGenerates(grammar.build(new Grammar.Builder.Option[0]), conditions);
    }

    @SafeVarargs
    public static void assertGenerates(Grammar grammar, Function<GeneratorFixture, String> ... conditions) {
        StringBuilder actual = new StringBuilder();
        for (Function<GeneratorFixture, String> condition : conditions) {
            GeneratorFixture fixture = new GeneratorFixture();
            String expected = condition.apply(fixture);
            actual.setLength(0);
            new Generator(fixture.random(), grammar, new ProductionReplacement[0]).generate((Output)Output.output((StringBuilder)actual));
            Assert.assertEquals((Object)expected, (Object)actual.toString());
        }
    }

    private GeneratorFixture() {
    }

    public GeneratorFixture picking(String literal) {
        this.state().pick(literal);
        return this;
    }

    public GeneratorFixture picking(Grammar.Term term) {
        this.state().pick(term);
        return this;
    }

    public GeneratorFixture picking(int codePoint) {
        this.state().pick(codePoint);
        return this;
    }

    public String generates(String result) {
        this.random();
        return result;
    }

    public GeneratorFixture includeOptional() {
        this.state().includeOptional();
        return this;
    }

    public GeneratorFixture skipOptional() {
        this.state().excludeOptional();
        return this;
    }

    public GeneratorFixture repeat(int times, ChoicesFixture.Repetition invocation) {
        this.state().repeat(times, invocation);
        return this;
    }

    private ChoicesFixture state() {
        if (this.state instanceof ChoicesFixture) {
            return (ChoicesFixture)this.state;
        }
        throw new IllegalStateException();
    }

    private Choices random() {
        if (!(this.state instanceof Choices)) {
            this.state = this.state().random();
        }
        return (Choices)this.state;
    }
}

