/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.io.Serializable;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.opencypher.generator.ChoicesFixture;
import org.opencypher.generator.Generator;
import org.opencypher.generator.GeneratorFixture;
import org.opencypher.generator.Node;
import org.opencypher.generator.ProductionReplacement;
import org.opencypher.grammar.Fixture;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.io.Output;

public class GeneratorTest {
    @Rule
    public final Fixture fixture = new Fixture();

    @Ignore
    @Test
    public void generateStuff() throws Exception {
        Grammar grammar = this.fixture.grammarResource("/somegrammar.xml", new Grammar.ParserOption[0]);
        Generator generator = new Generator(grammar, new ProductionReplacement[0]);
        Node tree = generator.generateTree(grammar.language());
        tree.sExpression(Output.stdOut());
    }

    @Test
    public void shouldGenerateLiteral() throws Exception {
        GeneratorFixture.assertGenerates(Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("foo", Grammar.literal((String)"Hello"), new Grammar.Term[0]), "Hello");
    }

    @Test
    public void shouldGenerateSequence() throws Exception {
        GeneratorFixture.assertGenerates(Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("foo", Grammar.sequence((Grammar.Term)Grammar.literal((String)"Hello"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"World")}), new Grammar.Term[0]), "HelloWorld");
    }

    @Test
    public void shouldFollowNonTerminals() throws Exception {
        GeneratorFixture.assertGenerates(Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("foo", Grammar.sequence((Grammar.Term)Grammar.nonTerminal((String)"hello"), (Grammar.Term[])new Grammar.Term[]{Grammar.nonTerminal((String)"world")}), new Grammar.Term[0]).production("hello", Grammar.literal((String)"Hello"), new Grammar.Term[0]).production("world", Grammar.literal((String)"World"), new Grammar.Term[0]), "HelloWorld");
    }

    @Test
    public void shouldGenerateOptional() throws Exception {
        GeneratorFixture.assertGenerates(Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("foo", Grammar.sequence((Grammar.Term)Grammar.nonTerminal((String)"hello"), (Grammar.Term[])new Grammar.Term[]{Grammar.optional((Grammar.Term)Grammar.nonTerminal((String)"world"), (Grammar.Term[])new Grammar.Term[0])}), new Grammar.Term[0]).production("hello", Grammar.literal((String)"Hello"), new Grammar.Term[0]).production("world", Grammar.literal((String)"World"), new Grammar.Term[0]), x -> x.skipOptional().generates("Hello"), x -> x.includeOptional().generates("HelloWorld"));
    }

    @Test
    public void shouldGenerateAlternative() throws Exception {
        GeneratorFixture.assertGenerates(Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("foo", Grammar.literal((String)"Hello"), new Grammar.Term[]{Grammar.literal((String)"World")}), x -> x.picking("Hello").generates("Hello"), x -> x.picking("World").generates("World"));
    }

    @Test
    public void shouldGenerateRepetition() throws Exception {
        GeneratorFixture.assertGenerates(Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("foo", Grammar.zeroOrMore((Grammar.Term)Grammar.literal((String)"w"), (Grammar.Term[])new Grammar.Term[0]), new Grammar.Term[0]), x -> x.repeat(0, ChoicesFixture.onRepetition(0)).generates(""), x -> x.repeat(3, ChoicesFixture.onRepetition(0)).generates("www"));
    }

    @Test
    public void shouldGenerateCharactersFromWellKnownSet() throws Exception {
        this.assertCharacterSet("NUL", "\u0000");
        this.assertCharacterSet("TAB", "\t");
        this.assertCharacterSet("LF", "\n");
        this.assertCharacterSet("CR", "\r");
        this.assertCharacterSet("FF", "\f");
    }

    @Test
    public void shouldReplaceProductions() throws Exception {
        String generated = GeneratorTest.generate(Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("foo", Grammar.nonTerminal((String)"bar"), new Grammar.Term[0]).production("bar", Grammar.literal((String)"WRONG!"), new Grammar.Term[0]), (ProductionReplacement & Serializable)bar -> bar.write((CharSequence)"OK"));
        Assert.assertEquals((Object)"OK", (Object)generated);
    }

    @Test
    public void shouldAllowContextSensitiveReplacements() throws Exception {
        Assert.assertEquals((Object)"one - two", (Object)GeneratorTest.generate(Grammar.grammar((String)"lang", (Grammar.Option[])new Grammar.Option[0]).production("lang", Grammar.sequence((Grammar.Term)Grammar.nonTerminal((String)"alpha"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)" - "), Grammar.nonTerminal((String)"beta")}), new Grammar.Term[0]).production("alpha", Grammar.nonTerminal((String)"symbol"), new Grammar.Term[0]).production("beta", Grammar.nonTerminal((String)"symbol"), new Grammar.Term[0]).production("symbol", Grammar.literal((String)"<NOT REPLACED>"), new Grammar.Term[0]), (ProductionReplacement & Serializable)symbol -> {
            switch (symbol.node().parent().name()) {
                case "alpha": {
                    symbol.write((CharSequence)"one");
                    break;
                }
                case "beta": {
                    symbol.write((CharSequence)"two");
                    break;
                }
                default: {
                    symbol.generateDefault();
                }
            }
        }));
    }

    private void assertCharacterSet(String name, String characters) {
        int i;
        int cp;
        Grammar grammar = Grammar.grammar((String)"foo", (Grammar.Option[])new Grammar.Option[0]).production("foo", (Grammar.Term)Grammar.charactersOfSet((String)name), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]);
        StringBuilder expected = new StringBuilder();
        HashSet<Integer> codepoints = new HashSet<Integer>();
        for (i = 0; i < characters.length(); i += Character.charCount(cp)) {
            cp = characters.codePointAt(i);
            expected.setLength(0);
            expected.appendCodePoint(cp);
            int codepoint = cp;
            GeneratorFixture.assertGenerates(grammar, x -> x.picking(codepoint).generates(expected.toString()));
            codepoints.add(cp);
        }
        i = codepoints.size() * 10;
        while (i-- > 0) {
            Assert.assertThat((Object)GeneratorTest.generate(grammar, new ProductionReplacement[0]).codePointAt(0), (Matcher)Matchers.isIn(codepoints));
        }
    }

    @SafeVarargs
    static String generate(Grammar.Builder grammar, ProductionReplacement<Void> ... replacements) {
        return GeneratorTest.generate(grammar.build(new Grammar.Builder.Option[0]), replacements);
    }

    @SafeVarargs
    static String generate(Grammar grammar, ProductionReplacement<Void> ... replacements) {
        StringBuilder result = new StringBuilder();
        new Generator(grammar, replacements).generate((Output)Output.output((StringBuilder)result));
        return result.toString();
    }
}

