/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.opencypher.grammar.CharacterSetNode;
import org.opencypher.grammar.Dependencies;
import org.opencypher.grammar.Description;
import org.opencypher.grammar.Located;
import org.opencypher.grammar.ProductionNode;
import org.opencypher.grammar.ProductionResolver;
import org.opencypher.grammar.ProductionTransformation;
import org.opencypher.grammar.ProductionVisitor;
import org.opencypher.grammar.VocabularyReference;
import org.opencypher.tools.xml.Attribute;
import org.opencypher.tools.xml.Child;
import org.opencypher.tools.xml.Comment;
import org.opencypher.tools.xml.Element;
import org.opencypher.tools.xml.XmlParser;
import org.xml.sax.SAXException;

@Element(uri="http://opencypher.org/grammar", name="grammar")
class Root
implements Iterable<ProductionNode> {
    static final XmlParser<Root> XML = XmlParser.xmlParser(Root.class);
    @Attribute
    String language;
    private final Map<String, ProductionNode> productions = new LinkedHashMap<String, ProductionNode>();
    private StringBuilder header;
    final Map<String, VocabularyReference> referencedFiles = new HashMap<String, VocabularyReference>();

    Root() {
    }

    @Child
    void add(ProductionNode production) {
        if (CharacterSetNode.isReserved(production.name)) {
            throw new IllegalArgumentException("Invalid production name: '" + production.name + "', it is reserved for well known character sets.");
        }
        if (this.productions.put(production.name.toLowerCase(), production) != null) {
            throw new IllegalArgumentException("Duplicate definition of '" + production.name + "' production");
        }
    }

    void markAsBnfSymbols(String productionName) {
        ProductionNode production = this.productions.get(productionName.toLowerCase());
        if (production == null) {
            throw new IllegalStateException("Can't find production " + productionName);
        }
        production.bnfsymbols = true;
    }

    @Child
    void addVocabulary(VocabularyReference vocabulary) throws ParserConfigurationException, SAXException, IOException {
        this.referencedFiles.put(vocabulary.path(), vocabulary);
        for (ProductionNode production : vocabulary.resolve()) {
            this.add(production);
        }
    }

    @Child(value={Comment.Header.class})
    void addHeader(char[] buffer, int start, int length) {
        if (this.header == null) {
            this.header = new StringBuilder(length);
        }
        Description.extract(this.header, buffer, start, length);
    }

    final Grammar resolve(ResolutionOption ... config) {
        Map<String, ProductionNode> filteredProductions;
        EnumSet<ResolutionOption> options = EnumSet.noneOf(ResolutionOption.class);
        if (config != null) {
            Collections.addAll(options, config);
        }
        Dependencies dependencies = new Dependencies();
        Set<String> unused = this.productions.values().stream().map(node -> node.name).collect(Collectors.toSet());
        if (!unused.remove(this.language)) {
            if (options.contains((Object)ResolutionOption.ALLOW_ROOTLESS)) {
                this.productions.values().stream().filter(production -> Objects.equals(production.vocabulary, this.language)).forEach(production -> unused.remove(production.name));
            } else {
                dependencies.missingProduction(this.language, new ProductionNode(this));
            }
        }
        HashSet<String> legacyProductions = new HashSet<String>();
        if (!options.contains((Object)ResolutionOption.INCLUDE_LEGACY)) {
            filteredProductions = new LinkedHashMap<String, ProductionNode>();
            this.productions.values().stream().filter(production1 -> !production1.legacy()).forEach(production -> filteredProductions.put(production.name().toLowerCase(), (ProductionNode)production));
            this.productions.values().stream().filter(ProductionNode::legacy).forEach(production -> legacyProductions.add(production.name.toLowerCase()));
        } else {
            filteredProductions = this.productions;
        }
        ProductionResolver resolver = new ProductionResolver(filteredProductions, dependencies, unused, options, legacyProductions);
        for (ProductionNode productionNode : filteredProductions.values()) {
            productionNode.resolve(resolver);
        }
        dependencies.reportMissingProductions();
        if (!(unused.isEmpty() || legacyProductions.containsAll(unused.stream().map(String::toLowerCase).collect(Collectors.toSet())) || options.contains((Object)ResolutionOption.IGNORE_UNUSED_PRODUCTIONS))) {
            System.err.println("WARNING! Unused productions:");
            for (String string : unused) {
                if (legacyProductions.contains(string.toLowerCase())) continue;
                System.err.println("\t" + string);
            }
        }
        ArrayList<ProductionNode> ordered = new ArrayList<ProductionNode>(filteredProductions.values());
        for (VocabularyReference reference : new ArrayList<VocabularyReference>(this.referencedFiles.values())) {
            reference.flattenTo(this.referencedFiles);
        }
        ordered.sort(Located.comparator(this.referencedFiles));
        LinkedHashMap<String, ProductionNode> linkedHashMap = new LinkedHashMap<String, ProductionNode>();
        for (ProductionNode production3 : ordered) {
            linkedHashMap.put(production3.name, production3);
        }
        return new Grammar(this, linkedHashMap);
    }

    @Override
    public Iterator<ProductionNode> iterator() {
        return this.productions.values().iterator();
    }

    private static final class Grammar
    implements org.opencypher.grammar.Grammar {
        private final String language;
        private final Map<String, ProductionNode> productions;
        private final String header;

        Grammar(Root root, Map<String, ProductionNode> productions) {
            this.language = Objects.requireNonNull(root.language, "language");
            this.header = root.header == null ? null : root.header.toString();
            this.productions = productions;
        }

        @Override
        public String language() {
            return this.language;
        }

        @Override
        public String header() {
            return this.header;
        }

        @Override
        public <EX extends Exception> void accept(ProductionVisitor<EX> visitor) throws EX {
            for (ProductionNode production : this.productions.values()) {
                production.accept(visitor);
            }
        }

        @Override
        public boolean hasProduction(String name) {
            return this.productions.containsKey(name);
        }

        @Override
        public <P, R, EX extends Exception> R transform(String name, ProductionTransformation<P, R, EX> transformation, P param) throws EX {
            ProductionNode production = this.productions.get(name);
            if (production == null) {
                throw new IllegalArgumentException("The grammar for " + this.language + " has no production for: " + name);
            }
            return production.transform(transformation, param);
        }

        @Override
        public <P, A, R, T, EX extends Exception> T transform(ProductionTransformation<P, R, EX> transformation, P param, Collector<R, A, T> collector) throws EX {
            BiConsumer<A, R> accumulator = collector.accumulator();
            A result = collector.supplier().get();
            for (ProductionNode production : this.productions.values()) {
                accumulator.accept(result, production.transform(transformation, param));
            }
            return collector.finisher().apply(result);
        }

        public String toString() {
            return "Grammar{" + this.language + "}";
        }

        public int hashCode() {
            return this.language.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj.getClass() != Grammar.class) {
                return false;
            }
            Grammar that = (Grammar)obj;
            return this.language.equals(that.language) && this.productions.equals(that.productions);
        }
    }

    static enum ResolutionOption {
        ALLOW_ROOTLESS,
        SKIP_UNUSED_PRODUCTIONS,
        IGNORE_UNUSED_PRODUCTIONS,
        INCLUDE_LEGACY;

    }
}

