/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4processors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.GrammarConverter;
import org.opencypher.tools.antlr.bnf.BNFLexer;
import org.opencypher.tools.antlr.bnf.BNFParser;
import org.opencypher.tools.g4processors.BNFListener;
import org.opencypher.tools.g4processors.FailingErrorListener;
import org.opencypher.tools.g4tree.GrammarTop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BNFProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BNFProcessor.class.getName());

    public Grammar processString(String inString) {
        return this.processStream(new ByteArrayInputStream(inString.getBytes()));
    }

    public Grammar processStream(InputStream inStream) {
        try {
            return this.processAntrlStream((CharStream)new ANTLRInputStream(inStream));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read or convert java.io.InputStream", e);
        }
    }

    public Grammar processFile(String fileName) {
        try {
            return this.processAntrlStream((CharStream)new ANTLRFileStream(fileName));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to find or read " + fileName, e);
        }
    }

    private Grammar processAntrlStream(CharStream inStream) {
        BNFLexer lexer = new BNFLexer(inStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        BNFParser parser = new BNFParser((TokenStream)tokens);
        lexer.addErrorListener((ANTLRErrorListener)new FailingErrorListener());
        parser.addErrorListener((ANTLRErrorListener)new FailingErrorListener());
        BNFParser.RulelistContext tree = parser.rulelist();
        ParseTreeWalker walker = new ParseTreeWalker();
        BNFListener listener = new BNFListener(tokens);
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        GrammarTop itemTree = listener.getTreeTop();
        GrammarConverter converter = new GrammarConverter(itemTree);
        return converter.convert();
    }
}

