/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4processors;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.tools.antlr.g4.Gee4BaseListener;
import org.opencypher.tools.antlr.g4.Gee4Parser;
import org.opencypher.tools.g4tree.EOFreference;
import org.opencypher.tools.g4tree.ExclusionCharacterSet;
import org.opencypher.tools.g4tree.FreeTextItem;
import org.opencypher.tools.g4tree.GrammarItem;
import org.opencypher.tools.g4tree.GrammarName;
import org.opencypher.tools.g4tree.GrammarTop;
import org.opencypher.tools.g4tree.Group;
import org.opencypher.tools.g4tree.InAlternative;
import org.opencypher.tools.g4tree.InAlternatives;
import org.opencypher.tools.g4tree.InLiteral;
import org.opencypher.tools.g4tree.InOptional;
import org.opencypher.tools.g4tree.ListedCharacterSet;
import org.opencypher.tools.g4tree.NamedCharacterSet;
import org.opencypher.tools.g4tree.OneOrMore;
import org.opencypher.tools.g4tree.Rule;
import org.opencypher.tools.g4tree.RuleId;
import org.opencypher.tools.g4tree.RuleList;
import org.opencypher.tools.g4tree.ZeroOrMore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class G4Listener
extends Gee4BaseListener {
    private final ParseTreeProperty<GrammarItem> items = new ParseTreeProperty();
    private GrammarTop treeTop = null;
    private final CommonTokenStream tokens;
    private boolean lexerRule = false;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)G4Listener.class.getName());
    private static final Pattern NAMED_CHARSET_PATT = Pattern.compile("\\\\p\\{(\\w+)\\}");

    public G4Listener(CommonTokenStream tokens) {
        this.tokens = tokens;
    }

    public GrammarTop getTreeTop() {
        return this.treeTop;
    }

    @Override
    public void exitWholegrammar(Gee4Parser.WholegrammarContext ctx) {
        GrammarName name = (GrammarName)this.getItem((ParseTree)ctx.grammardef());
        String headerText = this.cleanQuasiComment(ctx.header());
        RuleList rules = (RuleList)this.getItem((ParseTree)ctx.rulelist());
        this.treeTop = new GrammarTop(name, rules, headerText);
    }

    private String cleanQuasiComment(ParserRuleContext cmtCtx) {
        if (cmtCtx != null) {
            return cmtCtx.getText().replaceFirst("/\\*\\*", "").replaceFirst("\\*/", "").replaceAll("\r?\n\\s*\\*", "\n").replaceFirst("\r?\n$", "");
        }
        return null;
    }

    @Override
    public void exitGrammardef(Gee4Parser.GrammardefContext ctx) {
        String name = ctx.IDENTIFIER().getText();
        this.setItem((ParseTree)ctx, new GrammarName(name));
    }

    @Override
    public void exitRulelist(Gee4Parser.RulelistContext ctx) {
        GrammarItem grammarItem;
        RuleList rules = new RuleList();
        for (Gee4Parser.Rule_Context rule_Context : ctx.rule_()) {
            grammarItem = this.getItem((ParseTree)rule_Context);
            LOGGER.debug("adding an item for {}", (Object)rule_Context.getText());
            rules.addItem(grammarItem);
        }
        for (Gee4Parser.FragmentRuleContext fragmentRuleContext : ctx.fragmentRule()) {
            grammarItem = this.getItem((ParseTree)fragmentRuleContext);
            LOGGER.debug("adding a fragment item for {}", (Object)fragmentRuleContext.getText());
            rules.addItem(grammarItem);
        }
        this.setItem((ParseTree)ctx, rules);
    }

    @Override
    public void exitRule_(Gee4Parser.Rule_Context ctx) {
        GrammarItem item = this.getItem((ParseTree)ctx.ruleElements());
        String ruleName = this.getItem((ParseTree)ctx.ruleName()).toString().replaceFirst("^L_", "");
        String description = this.cleanQuasiComment(ctx.description());
        Rule rule = new Rule(this.getItem((ParseTree)ctx.ruleName()), item, description);
        this.setItem((ParseTree)ctx, rule);
    }

    @Override
    public void exitFragmentRule(Gee4Parser.FragmentRuleContext ctx) {
        GrammarItem item = this.getItem((ParseTree)ctx.literal());
        String ruleName = this.getItem((ParseTree)ctx.ruleName()).toString().replaceFirst("^L_", "");
        Rule rule = this.lexerRule && ruleName.matches("[A-Z]+") && item.isKeywordPart() ? new Rule(this.getItem((ParseTree)ctx.ruleName()), item, true, Rule.RuleType.KEYWORD, null) : new Rule(this.getItem((ParseTree)ctx.ruleName()), item, false, Rule.RuleType.FRAGMENT, null);
        this.setItem((ParseTree)ctx, rule);
    }

    @Override
    public void exitSpecialRule(Gee4Parser.SpecialRuleContext ctx) {
        LOGGER.warn("Ignoring special rule {}", (Object)ctx.getText());
    }

    @Override
    public void exitRuleName(Gee4Parser.RuleNameContext ctx) {
        String ruleName = ctx.getText();
        this.lexerRule = ruleName.equals(ruleName.toUpperCase());
        this.setItem((ParseTree)ctx, new RuleId(ruleName.replaceFirst("^L_", "")));
    }

    @Override
    public void exitRuleElements(Gee4Parser.RuleElementsContext ctx) {
        InAlternatives alts = new InAlternatives();
        for (Gee4Parser.RuleAlternativeContext element : ctx.ruleAlternative()) {
            alts.addItem(this.getItem((ParseTree)element));
        }
        this.setItem((ParseTree)ctx, alts);
    }

    @Override
    public void exitRuleAlternative(Gee4Parser.RuleAlternativeContext ctx) {
        InAlternative alt = new InAlternative();
        for (Gee4Parser.RuleItemContext element : ctx.ruleItem()) {
            alt.addItem(this.getItem((ParseTree)element));
        }
        FreeTextItem normal = this.findHiddenText(ctx);
        if (normal != null) {
            alt.addItem(normal);
        }
        this.setItem((ParseTree)ctx, alt);
    }

    private FreeTextItem findHiddenText(ParserRuleContext ctx) {
        Token endAlt = ctx.getStop();
        int i = endAlt.getTokenIndex();
        List normalTextChannel = this.tokens.getHiddenTokensToRight(i, 1);
        if (normalTextChannel != null) {
            String content = normalTextChannel.stream().map(tk -> tk.getText().replaceFirst("//!!\\s*", "")).collect(Collectors.joining());
            return new FreeTextItem(content);
        }
        return null;
    }

    @Override
    public void exitRuleItem(Gee4Parser.RuleItemContext ctx) {
        GrammarItem ourItem;
        boolean singular;
        ParserRuleContext contentCtx;
        if (ctx.ruleComponent() != null) {
            contentCtx = ctx.ruleComponent();
            singular = true;
        } else {
            contentCtx = ctx.ruleElements();
            singular = false;
        }
        GrammarItem contentItem = this.getItem((ParseTree)contentCtx);
        Gee4Parser.CardinalityContext cardinCtx = ctx.cardinality();
        if (cardinCtx == null) {
            ourItem = singular ? contentItem : new Group(contentItem);
        } else if (cardinCtx.QUESTION() != null) {
            ourItem = new InOptional(contentItem);
        } else if (cardinCtx.PLUS() != null) {
            ourItem = new OneOrMore(contentItem);
        } else if (cardinCtx.STAR() != null) {
            ourItem = new ZeroOrMore(contentItem);
        } else {
            throw new IllegalStateException("Cannot find content for RuleItem: " + ctx.getText());
        }
        this.setItem((ParseTree)ctx, ourItem);
    }

    @Override
    public void exitRuleComponent(Gee4Parser.RuleComponentContext ctx) {
        this.pullUpItem((ParseTree)ctx);
    }

    @Override
    public void exitQuotedString(Gee4Parser.QuotedStringContext ctx) {
        String text = ctx.getText().replaceFirst("^'", "").replaceFirst("'$", "");
        this.setItem((ParseTree)ctx, new InLiteral(text));
    }

    @Override
    public void exitNegatedQuotedString(Gee4Parser.NegatedQuotedStringContext ctx) {
        this.setItem((ParseTree)ctx, new ExclusionCharacterSet(ctx.getText().replaceFirst("^~'", "").replaceFirst("'$", "")));
    }

    @Override
    public void exitCharSet(Gee4Parser.CharSetContext ctx) {
        int cp;
        String name;
        String charSetString = ctx.getText().replaceFirst("^\\[", "").replaceFirst("\\]$", "");
        Matcher namedM = NAMED_CHARSET_PATT.matcher(charSetString);
        if (namedM.matches()) {
            this.setItem((ParseTree)ctx, new NamedCharacterSet(namedM.group(1)));
            return;
        }
        if (charSetString.contains("\\") && (charSetString = this.interpret(charSetString)).length() == 1 && (name = CharacterSet.controlCharName(cp = charSetString.codePointAt(0))) != null) {
            this.setItem((ParseTree)ctx, new NamedCharacterSet(name));
            return;
        }
        this.setItem((ParseTree)ctx, new ListedCharacterSet(charSetString));
    }

    private String interpret(String charSetString) {
        LOGGER.debug("interpreting {}", (Object)charSetString);
        boolean escaped = false;
        boolean inRange = false;
        boolean previous = false;
        StringBuilder b = new StringBuilder();
        int end = charSetString.length();
        block13: for (int i = 0; i < end; ++i) {
            int cp = charSetString.codePointAt(i);
            switch (cp) {
                case 92: {
                    if (escaped) {
                        b.append(cp);
                        escaped = false;
                        continue block13;
                    }
                    escaped = true;
                    continue block13;
                }
                default: {
                    if (escaped) {
                        escaped = false;
                        switch (cp) {
                            case 114: {
                                b.append('\r');
                                continue block13;
                            }
                            case 110: {
                                b.append("\n");
                                continue block13;
                            }
                            case 116: {
                                b.append("\t");
                                continue block13;
                            }
                            case 98: {
                                b.append("\b");
                                continue block13;
                            }
                            case 102: {
                                b.append("\f");
                                continue block13;
                            }
                            case 92: {
                                b.append("\\");
                                continue block13;
                            }
                            case 45: {
                                b.append('-');
                                continue block13;
                            }
                            case 117: {
                                if (i + 4 > charSetString.length()) {
                                    throw new IllegalArgumentException("unicode escape requires 4 hex digits");
                                }
                                String hexchars = charSetString.substring(i + 1, i + 5);
                                LOGGER.debug("at {}, hex {}", (Object)i, (Object)hexchars);
                                int ch = Integer.parseInt(hexchars, 16);
                                b.append((char)ch);
                                i += 4;
                                continue block13;
                            }
                        }
                        throw new IllegalArgumentException("Don't know how to interpret escaped character " + cp);
                    }
                    b.append(cp);
                }
            }
        }
        String answer = b.toString();
        LOGGER.debug("became {}, len {}", (Object)answer, (Object)answer.length());
        return answer;
    }

    @Override
    public void exitNegatedCharSet(Gee4Parser.NegatedCharSetContext ctx) {
        this.setItem((ParseTree)ctx, new ExclusionCharacterSet(ctx.getText().replaceFirst("^~\\[", "").replaceFirst("\\]$", "")));
    }

    @Override
    public void exitDotPattern(Gee4Parser.DotPatternContext ctx) {
        throw new UnsupportedOperationException("Cannot handle lexer dot pattern: " + ctx.getText());
    }

    @Override
    public void exitLiteral(Gee4Parser.LiteralContext ctx) {
        this.pullUpItem((ParseTree)ctx);
    }

    private String respaceString(String original) {
        return original.replaceAll("_", " ");
    }

    @Override
    public void exitRuleReference(Gee4Parser.RuleReferenceContext ctx) {
        String ruleName = ctx.getText();
        if (ruleName.startsWith("L_")) {
            this.setItem((ParseTree)ctx, new InLiteral(ruleName.substring(2)));
        } else if (ruleName.equals("EOF")) {
            this.setItem((ParseTree)ctx, new EOFreference());
        } else {
            this.setItem((ParseTree)ctx, new RuleId(ruleName));
        }
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
        super.exitEveryRule(ctx);
    }

    private GrammarItem getItem(ParseTree ctx) {
        return (GrammarItem)this.items.get(ctx);
    }

    private void setItem(ParseTree ctx, GrammarItem item) {
        LOGGER.debug("setting a {} for {}", (Object)item.getClass().getSimpleName(), (Object)ctx.getText());
        this.items.put(ctx, (Object)item);
    }

    private void pullUpItem(ParseTree ctx) {
        LOGGER.debug("promoting a {} from {}", (Object)ctx.getClass().getSimpleName(), (Object)ctx.getChild(0).getClass().getSimpleName());
        this.items.put(ctx, (Object)this.getItem(ctx.getChild(0)));
    }
}

