/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4tree;

import java.util.Collections;
import java.util.List;
import org.opencypher.tools.g4tree.GrammarItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rule
implements GrammarItem {
    private static final int LINE_WIDTH = 85;
    private static final String BNFINDENT = "    ";
    private static final int INDENT_WIDTH = "    ".length();
    private static final int G4LINE_WIDTH = 100;
    private static final String G4INDENT = "         ";
    private static final int G4INDENT_WIDTH = "         ".length();
    private final GrammarItem ruleName;
    private final GrammarItem rhs;
    private final boolean keyWordRule;
    private final String description;
    private RuleType ruleType;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Rule.class.getName());

    public Rule(GrammarItem ruleName, GrammarItem rhs, String description) {
        this(ruleName, rhs, false, RuleType.NORMAL, description);
    }

    public Rule(GrammarItem ruleName, GrammarItem rhs, boolean keyWordRule, RuleType ruleType, String description) {
        this.ruleName = ruleName;
        this.rhs = rhs;
        this.keyWordRule = keyWordRule;
        this.ruleType = ruleType;
        this.description = description;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
    }

    @Override
    public GrammarItem.ItemType getType() {
        return GrammarItem.ItemType.RULE;
    }

    public String getRuleName() {
        return this.ruleName.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public GrammarItem getRhs() {
        return this.rhs;
    }

    @Override
    public List<GrammarItem> getChildren() {
        return Collections.singletonList(this.rhs);
    }

    @Override
    public boolean isPlural() {
        return false;
    }

    @Override
    public String getStructure(String indent) {
        return indent + "Rule (" + (Object)((Object)this.ruleType) + ") :" + this.ruleName + "\n" + this.rhs.getStructure(indent + "   ");
    }

    @Override
    public GrammarItem reachThrough() {
        return this;
    }

    @Override
    public boolean isKeywordPart() {
        return false;
    }

    public static enum RuleType {
        NORMAL(true),
        KEYWORD(false),
        KEYWORD_LITERAL(false),
        LETTER(false),
        BNF(false),
        FRAGMENT(false);

        private final boolean keep;

        private RuleType(boolean keep) {
            this.keep = keep;
        }

        public boolean keep() {
            return this.keep;
        }
    }
}

