/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.TransformerException;
import org.opencypher.grammar.Alternatives;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Literal;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Optional;
import org.opencypher.grammar.Production;
import org.opencypher.grammar.ProductionVisitor;
import org.opencypher.grammar.Repetition;
import org.opencypher.grammar.Sequence;
import org.opencypher.grammar.TermVisitor;
import org.opencypher.tools.grammar.Main;
import org.opencypher.tools.io.Output;
import org.opencypher.tools.xml.XmlGenerator;
import org.xml.sax.SAXException;

public class Xml
extends XmlGenerator
implements ProductionVisitor<SAXException>,
TermVisitor<SAXException> {
    private final Grammar grammar;

    public static void write(Grammar grammar, Writer writer) throws TransformerException {
        Xml.generate((XmlGenerator)new Xml(grammar), writer);
    }

    public static void write(Grammar grammar, OutputStream stream) throws TransformerException {
        Xml.generate((XmlGenerator)new Xml(grammar), stream);
    }

    public static void write(Grammar grammar, Output output) throws TransformerException {
        Xml.write(grammar, output.writer());
    }

    public static void main(String ... args) throws Exception {
        Main.execute(Xml::write, args);
    }

    private Xml(Grammar grammar) {
        this.grammar = grammar;
    }

    @Override
    protected void generate() throws SAXException {
        this.startDocument();
        this.startPrefixMapping("", "http://opencypher.org/grammar");
        String headerText = this.grammar.header();
        if (headerText != null) {
            headerText = "\n\n    " + headerText.replaceAll("\r", "").replaceAll("\n", "\n    ") + "\n";
            this.println("");
            this.comment(headerText);
        }
        this.startElement("grammar", this.attribute("language", this.grammar.language()));
        this.grammar.accept(this);
        this.endElement("grammar");
        this.endPrefixMapping("");
        this.endDocument();
    }

    @Override
    public void visitProduction(Production production) throws SAXException {
        this.startElement("production", this.attribute("name", production.name()));
        String description = production.description();
        if (description != null) {
            this.startElement("description");
            this.characters(description);
            this.endElementSameLine("", "description");
        }
        production.definition().accept(this);
        this.endElement("production");
    }

    @Override
    public void visitAlternatives(Alternatives alternatives) throws SAXException {
        this.startElement("alt");
        for (Grammar.Term term : alternatives) {
            term.accept(this);
        }
        this.endElement("alt");
    }

    @Override
    public void visitSequence(Sequence sequence) throws SAXException {
        this.startElement("seq");
        for (Grammar.Term term : sequence) {
            term.accept(this);
        }
        this.endElement("seq");
    }

    @Override
    public void visitLiteral(Literal value) throws SAXException {
        XmlGenerator.AttributesBuilder attributes = this.attribute("value", value.toString()).attribute("case-sensitive", String.valueOf(value.caseSensitive()));
        this.startElement("literal", attributes);
        this.endElement("literal");
    }

    @Override
    public void visitCharacters(CharacterSet characters) throws SAXException {
        class Writer
        implements CharacterSet.DefinitionVisitor.NamedSetVisitor<SAXException>,
        AutoCloseable {
            Output.Readable set;

            Writer() {
            }

            @Override
            public CharacterSet.ExclusionVisitor<SAXException> visitSet(String name) throws SAXException {
                if (this.set != null) {
                    throw new IllegalStateException();
                }
                this.set = Output.nowhere();
                Xml.this.startElement("character", Xml.this.attribute("set", name));
                return new CharacterSet.ExclusionVisitor<SAXException>(){

                    @Override
                    public void excludeCodePoint(int cp) throws SAXException {
                        Xml.this.startElement("except", Xml.this.attribute("codePoint", Integer.toString(cp)));
                        Xml.this.endElement("except");
                    }

                    @Override
                    public void excludeRange(int start, int end) throws SAXException {
                        Xml.this.startElement("except", Xml.this.attribute("set", String.format("[&#x%04X;-&#x%04X;]", start, end)));
                        Xml.this.endElement("except");
                    }

                    @Override
                    public void excludeSet(String name) throws SAXException {
                        Xml.this.startElement("except", Xml.this.attribute("set", name));
                        Xml.this.endElement("except");
                    }

                    @Override
                    public void close() throws SAXException {
                        Xml.this.endElement("character");
                    }
                };
            }

            @Override
            public void visitCodePoint(int cp) throws SAXException {
                this.format("&#x%04X;", cp);
            }

            @Override
            public void visitRange(int start, int end) throws SAXException {
                this.format("&#x%04X;-&#x%04X;", start, end);
            }

            @Override
            public void close() throws SAXException {
                if (this.set == null) {
                    throw new IllegalStateException();
                }
                if (this.set.length() > 0) {
                    this.set.append(']');
                    Xml.this.startElement("character", Xml.this.attribute("set", this.set.toString()));
                    Xml.this.endElement("character");
                    this.set = Output.nowhere();
                }
            }

            void format(String format, Object ... arguments) {
                if (this.set == null) {
                    this.set = Output.stringBuilder();
                    this.set.append('[');
                }
                if (this.set.length() == 0) {
                    throw new IllegalStateException();
                }
                this.set.format(format, arguments);
            }
        }
        try (Writer writer = new Writer();){
            characters.accept(writer);
        }
    }

    @Override
    public void visitNonTerminal(NonTerminal nonTerminal) throws SAXException {
        this.startElement("non-terminal", this.attribute("ref", nonTerminal.productionName()));
        this.endElement("non-terminal");
    }

    @Override
    public void visitOptional(Optional optional) throws SAXException {
        this.startElement("opt");
        optional.term().accept(this);
        this.endElement("opt");
    }

    @Override
    public void visitRepetition(Repetition repetition) throws SAXException {
        if (repetition.minTimes() > 0) {
            XmlGenerator.AttributesBuilder attributes = this.attribute("min", "" + repetition.minTimes());
            if (repetition.limited()) {
                attributes = attributes.attribute("max", "" + repetition.maxTimes());
            }
            this.startElement("repeat", attributes);
        } else if (repetition.limited()) {
            this.startElement("repeat", this.attribute("max", "" + repetition.maxTimes()));
        } else {
            this.startElement("repeat");
        }
        repetition.term().accept(this);
        this.endElement("repeat");
    }

    @Override
    public void visitEpsilon() throws SAXException {
    }
}

